/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.api;

import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.provider.param.api.IHeaderAccess;
import nom.tam.fits.header.IFitsHeader;

public class HeaderCardAccess
implements IHeaderAccess {
    private final HeaderCard headerCard;

    public HeaderCardAccess(IFitsHeader headerCard, String value) throws IllegalArgumentException {
        try {
            this.headerCard = new HeaderCard(headerCard.key(), value, null);
        }
        catch (HeaderCardException e) {
            throw new IllegalArgumentException("header card could not be created");
        }
    }

    @Override
    public final Header getHeader() {
        Header header = new Header();
        header.addLine(this.headerCard);
        return header;
    }

    public final HeaderCard getHeaderCard() {
        return this.headerCard;
    }

    @Override
    public void addValue(IFitsHeader key, int value) {
        if (this.headerCard.getKey().equals(key.key())) {
            this.headerCard.setValue(value);
        }
    }

    @Override
    public void addValue(IFitsHeader key, String value) {
        if (this.headerCard.getKey().equals(key.key())) {
            this.headerCard.setValue(value);
        }
    }

    @Override
    public HeaderCard findCard(IFitsHeader key) {
        return this.findCard(key.key());
    }

    @Override
    public HeaderCard findCard(String key) {
        if (this.headerCard.getKey().equals(key)) {
            return this.headerCard;
        }
        return null;
    }
}

