/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.base;

import java.util.ArrayList;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.provider.param.api.ICompressColumnParameter;
import nom.tam.fits.compression.provider.param.api.ICompressHeaderParameter;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.fits.compression.provider.param.base.CompressParameters;

public class BundledParameters
extends CompressParameters {
    private ArrayList<ICompressParameters> bundle = new ArrayList();

    public BundledParameters(ICompressParameters ... components) {
        for (ICompressParameters p : components) {
            if (p == null) continue;
            this.bundle.add(p);
        }
    }

    public int size() {
        return this.bundle.size();
    }

    public ICompressParameters get(int index) {
        return this.bundle.get(index);
    }

    @Override
    public BundledParameters copy(ICompressOption option) {
        throw new UnsupportedOperationException("Cannot copy parameter bundle");
    }

    @Override
    protected ICompressColumnParameter[] columnParameters() {
        ArrayList<ICompressColumnParameter> list = new ArrayList<ICompressColumnParameter>();
        for (ICompressParameters parms : this.bundle) {
            for (ICompressColumnParameter p : ((CompressParameters)parms).columnParameters()) {
                list.add(p);
            }
        }
        ICompressColumnParameter[] array = new ICompressColumnParameter[list.size()];
        return list.toArray(array);
    }

    @Override
    protected ICompressHeaderParameter[] headerParameters() {
        ArrayList<ICompressHeaderParameter> list = new ArrayList<ICompressHeaderParameter>();
        for (ICompressParameters parms : this.bundle) {
            for (ICompressHeaderParameter p : ((CompressParameters)parms).headerParameters()) {
                list.add(p);
            }
        }
        ICompressHeaderParameter[] array = new ICompressHeaderParameter[list.size()];
        return list.toArray(array);
    }

    @Override
    public void setTileIndex(int index) {
        for (ICompressParameters parms : this.bundle) {
            parms.setTileIndex(index);
        }
    }
}

