/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.quant;

import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.algorithm.quant.QuantizeOption;
import nom.tam.fits.compression.provider.param.api.ICompressColumnParameter;
import nom.tam.fits.compression.provider.param.api.ICompressHeaderParameter;
import nom.tam.fits.compression.provider.param.base.CompressParameters;
import nom.tam.fits.compression.provider.param.quant.ZBlankColumnParameter;
import nom.tam.fits.compression.provider.param.quant.ZBlankParameter;
import nom.tam.fits.compression.provider.param.quant.ZDither0Parameter;
import nom.tam.fits.compression.provider.param.quant.ZQuantizeParameter;
import nom.tam.fits.compression.provider.param.quant.ZScaleColumnParameter;
import nom.tam.fits.compression.provider.param.quant.ZZeroColumnParameter;

public class QuantizeParameters
extends CompressParameters {
    private ZQuantizeParameter quantz;
    private ZBlankParameter blank;
    private ZDither0Parameter seed;
    private ZBlankColumnParameter blankColumn;
    private ZZeroColumnParameter zero;
    private ZScaleColumnParameter scale;

    public QuantizeParameters(QuantizeOption option) {
        this.quantz = new ZQuantizeParameter(option);
        this.blank = new ZBlankParameter(option);
        this.seed = new ZDither0Parameter(option);
        this.blankColumn = new ZBlankColumnParameter(option);
        this.zero = new ZZeroColumnParameter(option);
        this.scale = new ZScaleColumnParameter(option);
    }

    @Override
    protected ICompressColumnParameter[] columnParameters() {
        return new ICompressColumnParameter[]{this.blankColumn, this.zero, this.scale};
    }

    @Override
    protected ICompressHeaderParameter[] headerParameters() {
        return new ICompressHeaderParameter[]{this.quantz, this.blank, this.seed};
    }

    @Override
    public void setTileIndex(int index) {
        this.seed.setTileIndex(index);
    }

    @Override
    public QuantizeParameters copy(ICompressOption option) {
        if (option instanceof QuantizeOption) {
            QuantizeOption qo = (QuantizeOption)option;
            QuantizeParameters p = (QuantizeParameters)super.clone();
            p.quantz = (ZQuantizeParameter)this.quantz.copy(qo);
            p.blank = (ZBlankParameter)this.blank.copy(qo);
            p.seed = (ZDither0Parameter)this.seed.copy(qo);
            p.blankColumn = (ZBlankColumnParameter)this.blankColumn.copy(qo);
            p.zero = (ZZeroColumnParameter)this.zero.copy(qo);
            p.scale = (ZScaleColumnParameter)this.scale.copy(qo);
            return p;
        }
        return null;
    }
}

