/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.quant;

import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.algorithm.quant.QuantizeOption;
import nom.tam.fits.compression.provider.param.base.CompressHeaderParameter;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.IFitsHeader;

final class ZQuantizeParameter
extends CompressHeaderParameter<QuantizeOption> {
    ZQuantizeParameter(QuantizeOption quantizeOption) {
        super(Compression.ZQUANTIZ.name(), quantizeOption);
    }

    @Override
    public void getValueFromHeader(Header header) throws HeaderCardException {
        if (this.getOption() == null) {
            return;
        }
        HeaderCard card = header.getCard(this.getName());
        String value = card != null ? card.getValue() : null;
        ((QuantizeOption)this.getOption()).setDither(false);
        ((QuantizeOption)this.getOption()).setDither2(false);
        if ("SUBTRACTIVE_DITHER_1".equals(value)) {
            ((QuantizeOption)this.getOption()).setDither(true);
        } else if ("SUBTRACTIVE_DITHER_2".equals(value)) {
            ((QuantizeOption)this.getOption()).setDither(true);
            ((QuantizeOption)this.getOption()).setDither2(true);
        }
    }

    @Override
    public void setValueInHeader(Header header) throws HeaderCardException {
        if (this.getOption() == null) {
            return;
        }
        String value = ((QuantizeOption)this.getOption()).isDither2() ? "SUBTRACTIVE_DITHER_2" : (((QuantizeOption)this.getOption()).isDither() ? "SUBTRACTIVE_DITHER_1" : "NO_DITHER");
        header.addValue((IFitsHeader)Compression.ZQUANTIZ, value);
    }
}

