/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.type.ElementType;

public enum Bitpix {
    BYTE(Byte.TYPE, ElementType.BYTE, "bytes"),
    SHORT(Short.TYPE, ElementType.SHORT, "16-bit integers"),
    INTEGER(Integer.TYPE, ElementType.INT, "32-bit integers"),
    LONG(Long.TYPE, ElementType.LONG, "64-bit integers"),
    FLOAT(Float.TYPE, ElementType.FLOAT, "32-bit floating point"),
    DOUBLE(Double.TYPE, ElementType.DOUBLE, "64-bit floating point");

    private static final Logger LOG;
    private static final int BITS_TO_BYTES_SHIFT = 3;
    public static final int VALUE_FOR_BYTE = 8;
    public static final int VALUE_FOR_SHORT = 16;
    public static final int VALUE_FOR_INT = 32;
    public static final int VALUE_FOR_LONG = 64;
    public static final int VALUE_FOR_FLOAT = -32;
    public static final int VALUE_FOR_DOUBLE = -64;
    private Class<? extends Number> numberType;
    private ElementType<?> elementType;
    private String description;

    private Bitpix(Class<? extends Number> numberType, ElementType<?> elementType, String desc) {
        this.numberType = numberType;
        this.elementType = elementType;
        this.description = desc;
    }

    public final ElementType<?> getElementType() {
        return this.elementType;
    }

    public final Class<? extends Number> getNumberType() {
        return this.numberType;
    }

    public final Class<?> getPrimitiveType() {
        return this.elementType.primitiveClass();
    }

    public final int getHeaderValue() {
        return this.elementType.bitPix();
    }

    public final char getArrayID() {
        return this.elementType.type();
    }

    public final String getDescription() {
        return this.description;
    }

    public final int byteSize() {
        return Math.abs(this.getHeaderValue()) >>> 3;
    }

    public final HeaderCard getHeaderCard() {
        return HeaderCard.create((IFitsHeader)Standard.BITPIX, this.getHeaderValue());
    }

    public static Bitpix forPrimitiveType(Class<?> dataType) throws FitsException {
        if (dataType == Byte.TYPE) {
            return BYTE;
        }
        if (dataType == Short.TYPE) {
            return SHORT;
        }
        if (dataType == Integer.TYPE) {
            return INTEGER;
        }
        if (dataType == Long.TYPE) {
            return LONG;
        }
        if (dataType == Float.TYPE) {
            return FLOAT;
        }
        if (dataType == Double.TYPE) {
            return DOUBLE;
        }
        if (Object.class.isAssignableFrom(dataType)) {
            throw new FitsException("No BITPIX for type: " + dataType + " (expected primitive type)");
        }
        throw new FitsException("No BITPIX for primitive type: " + dataType);
    }

    public static Bitpix forNumberType(Class<? extends Number> dataType) throws FitsException {
        if (Byte.class.isAssignableFrom(dataType)) {
            return BYTE;
        }
        if (Short.class.isAssignableFrom(dataType)) {
            return SHORT;
        }
        if (Integer.class.isAssignableFrom(dataType)) {
            return INTEGER;
        }
        if (Long.class.isAssignableFrom(dataType)) {
            return LONG;
        }
        if (Float.class.isAssignableFrom(dataType)) {
            return FLOAT;
        }
        if (Double.class.isAssignableFrom(dataType)) {
            return DOUBLE;
        }
        throw new FitsException("No BITPIX for Number type " + dataType);
    }

    public static Bitpix fromHeader(Header h) throws FitsException {
        return Bitpix.forValue(h.getIntValue(Standard.BITPIX, 0));
    }

    public static Bitpix fromHeader(Header h, boolean allowRepair) throws FitsException {
        return Bitpix.forValue(h.getIntValue(Standard.BITPIX, 0), allowRepair);
    }

    public static Bitpix forValue(int ival) throws FitsException {
        try {
            return Bitpix.forValue(ival, FitsFactory.isAllowHeaderRepairs());
        }
        catch (FitsException e) {
            throw new FitsException(e.getMessage() + "\n\n --> Try FitsFactory.setAllowHeaderRepairs(true).\n");
        }
    }

    public static Bitpix forValue(int ival, boolean allowRepair) throws FitsException {
        if (ival == 0) {
            throw new FitsException("Invalid BITPIX value:" + ival);
        }
        if (allowRepair) {
            int fixed = 0;
            if (ival < 0) {
                fixed = ival < -32 ? -64 : -32;
            } else if (ival < 8) {
                fixed = 8;
            } else if (ival > 64) {
                fixed = 64;
            } else if (ival > Integer.highestOneBit(ival)) {
                fixed = Integer.highestOneBit(ival) << 1;
            }
            if (fixed != 0) {
                LOG.warning("Repaired invalid BITPIX value:" + ival + " --> " + fixed);
                ival = fixed;
            }
        }
        switch (ival) {
            case 8: {
                return BYTE;
            }
            case 16: {
                return SHORT;
            }
            case 32: {
                return INTEGER;
            }
            case 64: {
                return LONG;
            }
            case -32: {
                return FLOAT;
            }
            case -64: {
                return DOUBLE;
            }
        }
        throw new FitsException("Invalid BITPIX value:" + ival);
    }

    public static Bitpix forArrayID(char id) throws FitsException {
        switch (id) {
            case 'B': {
                return BYTE;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INTEGER;
            }
            case 'J': {
                return LONG;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
        }
        throw new FitsException("Invalid BITPIX data ID: '" + id + "'");
    }

    static {
        LOG = Logger.getLogger("nom.tam.fits.HeaderCardParser");
    }
}

