/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.Checksum;
import nom.tam.fits.header.FitsKey;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;

public enum Compression implements IFitsHeader
{
    ZTABLE(IFitsHeader.VALUE.LOGICAL, "whether this is a compressed table"),
    ZIMAGE(IFitsHeader.VALUE.LOGICAL, "whether this is a compressed image"),
    ZCMPTYPE(IFitsHeader.VALUE.STRING, "compression algorithm"),
    ZBITPIX(IFitsHeader.VALUE.INTEGER, "original BITPIX value", Standard.BITPIX),
    ZNAXIS(IFitsHeader.VALUE.INTEGER, "original NAXIS value", Standard.NAXIS),
    ZNAXISn(IFitsHeader.VALUE.INTEGER, "original NAXISn value", Standard.NAXISn),
    ZTILEn(IFitsHeader.VALUE.INTEGER, "image tile size along dimension"),
    ZNAMEn(IFitsHeader.VALUE.STRING, "indexed compression parameter name"),
    ZVALn(IFitsHeader.VALUE.ANY, "indexed compression parameter value"),
    ZMASKCMP(IFitsHeader.VALUE.STRING, "mask compression algorithm"),
    ZSIMPLE(IFitsHeader.VALUE.LOGICAL, "original SIMPLE value", Standard.SIMPLE),
    ZTENSION(IFitsHeader.VALUE.STRING, "original XTENSION value", Standard.XTENSION),
    ZEXTEND(IFitsHeader.VALUE.LOGICAL, "original EXTEND value", Standard.EXTEND),
    ZBLOCKED(IFitsHeader.VALUE.LOGICAL, "original BLOCKED value", Standard.BLOCKED),
    ZPCOUNT(IFitsHeader.VALUE.INTEGER, "original PCOUNT value", Standard.PCOUNT),
    ZGCOUNT(IFitsHeader.VALUE.INTEGER, "original GCOUNTvalue", Standard.GCOUNT),
    ZHECKSUM(IFitsHeader.VALUE.STRING, "original CHECKSUM string", Checksum.CHECKSUM),
    ZDATASUM(IFitsHeader.VALUE.STRING, "original DATASUM value", Checksum.DATASUM),
    ZQUANTIZ(IFitsHeader.VALUE.STRING, "compression quantization algorithm"),
    ZDITHER0(IFitsHeader.VALUE.INTEGER, "dither algorithm seed value"),
    ZBLANK(IFitsHeader.VALUE.INTEGER, "original BLANK value"),
    ZTHEAP(IFitsHeader.VALUE.INTEGER, "original THEAP value", Standard.THEAP),
    ZTILELEN(IFitsHeader.VALUE.INTEGER, "number of rows compressed per tile"),
    ZFORMn(IFitsHeader.VALUE.STRING, "compressed column data format", Standard.TFORMn),
    ZCTYPn(IFitsHeader.VALUE.STRING, "original CTYPEn");

    public static final String ZQUANTIZ_NO_DITHER = "NO_DITHER";
    public static final String ZQUANTIZ_SUBTRACTIVE_DITHER_1 = "SUBTRACTIVE_DITHER_1";
    public static final String ZQUANTIZ_SUBTRACTIVE_DITHER_2 = "SUBTRACTIVE_DITHER_2";
    public static final String ZCMPTYPE_GZIP_1 = "GZIP_1";
    public static final String ZCMPTYPE_GZIP_2 = "GZIP_2";
    public static final String ZCMPTYPE_RICE_1 = "RICE_1";
    public static final String ZCMPTYPE_PLIO_1 = "PLIO_1";
    public static final String ZCMPTYPE_HCOMPRESS_1 = "HCOMPRESS_1";
    public static final String ZCMPTYPE_RICE_ONE = "RICE_ONE";
    public static final String ZCMPTYPE_NOCOMPRESS = "NOCOMPRESS";
    public static final String COMPRESSED_DATA_COLUMN = "COMPRESSED_DATA";
    public static final String GZIP_COMPRESSED_DATA_COLUMN = "GZIP_COMPRESSED_DATA";
    public static final String UNCOMPRESSED_DATA_COLUMN = "UNCOMPRESSED_DATA";
    public static final String ZBLANK_COLUMN = "ZBLANK";
    public static final String ZZERO_COLUMN = "ZZERO";
    public static final String ZSCALE_COLUMN = "ZSCALE";
    public static final String NULL_PIXEL_MASK_COLUMN = "NULL_PIXEL_MASK_COLUMN";
    public static final String BYTEPIX = "BYTEPIX";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String SCALE = "SCALE";
    public static final String SMOOTH = "SMOOTH";
    private final FitsKey key;
    private final IFitsHeader uncompressedKey;

    private Compression(IFitsHeader.VALUE valueType, String comment) {
        this(valueType, comment, null);
    }

    private Compression(IFitsHeader.VALUE valueType, String comment, IFitsHeader uncompressedKey) {
        this.key = new FitsKey(this.name(), IFitsHeader.SOURCE.INTEGRAL, IFitsHeader.HDU.BINTABLE, valueType, comment);
        this.uncompressedKey = uncompressedKey;
        FitsKey.registerStandard(this);
    }

    @Override
    public final FitsKey impl() {
        return this.key;
    }

    public IFitsHeader getUncompressedKey() {
        return this.uncompressedKey;
    }
}

