/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.FitsKey;
import nom.tam.fits.header.IFitsHeader;

public enum DataDescription implements IFitsHeader
{
    CONFIGUR(IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "software configuration used to process the data"),
    CREATOR(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of the software task that created the file"),
    FILENAME(IFitsHeader.SOURCE.NOAO, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of the file "),
    FILETYPE(IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "type of file"),
    HDUCLASn(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "hierarchical classification of the data"),
    HDUCLASS(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "general identifier for the classification of the data"),
    HDUDOC(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "reference to document describing the data format"),
    HDULEVEL(IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "hierarchical level of the HDU"),
    HDUNAME(IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "descriptive name of the HDU"),
    HDUVER(IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "version number of the HDU"),
    HDUVERS(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "specific version of the document referenced by HDUDOC"),
    NEXTEND(IFitsHeader.SOURCE.STScI, IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.INTEGER, "Number of standard extensions"),
    PROGRAM(IFitsHeader.SOURCE.UCOLICK, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "the name of the software task that created the file"),
    ROOTNAME(IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "rootname of the file"),
    TDBINn(IFitsHeader.SOURCE.CXC, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "default histogram bin size for the column"),
    TDMAXn(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "maximum value in the column"),
    TDMINn(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "minimum value in the column"),
    TITLE(IFitsHeader.SOURCE.ROSAT, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "title for the observation or data"),
    TLMAXn(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "maximum legal value in the column"),
    TLMINn(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "minimum legal value in the column"),
    TSORTKEY(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "defines the sort order of a table");

    private final FitsKey key;

    private DataDescription(IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this.key = new FitsKey(this.name(), status, hdu, valueType, comment);
    }

    @Override
    public final FitsKey impl() {
        return this.key;
    }
}

