/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.FitsKey;
import nom.tam.fits.header.IFitsHeader;

public enum DateTime implements IFitsHeader
{
    DATE(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "date of file creation"),
    DATE_OBS("DATE-OBS", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "date of observation"),
    DOBSn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "date of observation for column"),
    DATE_AVG("DATE-AVG", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "mean date of observation"),
    DAVGn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "mean date of observation for column"),
    DATE_BEG("DATE-BEG", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "start of observation"),
    DATE_END("DATE-END", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "end of observation"),
    DATEREF(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "reference date"),
    MJD_OBS("MJD-OBS", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[day] Modified Julian Date of observation"),
    MJDOBn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[day] MJD of observation for column"),
    MJD_AVG("MJD-AVG", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[day] mean Modified Julian Date of observation"),
    MJDAn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[day] mean MJD of observation for column"),
    MJD_BEG("MJD-BEG", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[day] Modified Julian Date of start of observation"),
    MJD_END("MJD-END", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[day] Modified Julian Date of start of observation"),
    MJDREF(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[day] reference Modified Julian Date"),
    JDREF(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[day] reference Julian Date"),
    TSTART(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "start time of observation"),
    TSTOP(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "end time of observation"),
    BEPOCH(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[Ba] Besselian epoch of observation"),
    JEPOCH(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[yr] Julian epoch of observation"),
    XPOSURE(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "net exposure duration"),
    TELAPSE(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "wall-clock exposure duration"),
    TIMESYS(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "time reference system"),
    TREFPOS(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "time reference location"),
    TRPOSn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "time reference location in column"),
    TREFDIR(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "time reference direction"),
    TRDIRn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "time reference direction in column"),
    PLEPHEM(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "solar-system ephemeris ID"),
    TIMEUNIT(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "time unit"),
    TIMEOFFS(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "time offset"),
    TIMESYER(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "systematic time error"),
    TIMERDER(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "random time error"),
    TIMEDEL(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "time resolution"),
    TIMEPIXR(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "time location within pixel");

    public static final String TIMESYS_TAI = "TAI";
    public static final String TIMESYS_TT = "TT";
    public static final String TIMESYS_TDT = "TDT";
    public static final String TIMESYS_ET = "ET";
    public static final String TIMESYS_IAT = "IAT";
    public static final String TIMESYS_UT1 = "UT1";
    public static final String TIMESYS_UTC = "UTC";
    public static final String TIMESYS_GMT = "GMT";
    public static final String TIMESYS_GPS = "GPS";
    public static final String TIMESYS_TCG = "TCG";
    public static final String TIMESYS_TCB = "TCB";
    public static final String TIMESYS_TDB = "TDB";
    public static final String TIMESYS_LOCAL = "LOCAL";
    public static final String TREFPOS_TOPOCENTER = "TOPOCENTER";
    public static final String TREFPOS_GEOCENTER = "GEOCENTER";
    public static final String TREFPOS_BARYCENTER = "BARYCENTER";
    public static final String TREFPOS_RELOCATABLE = "RELOCATABLE";
    public static final String TREFPOS_CUSTOM = "CUSTOM";
    public static final String TREFPOS_HELIOCENTER = "HELIOCENTER";
    public static final String TREFPOS_GALACTIC = "GALACTIC";
    public static final String TREFPOS_EMBARYCENTER = "EMBARYCENTER";
    public static final String TREFPOS_MERCURY = "MERCURY";
    public static final String TREFPOS_VENUS = "VENUS";
    public static final String TREFPOS_MARS = "MARS";
    public static final String TREFPOS_JUPITER = "JUPITER";
    public static final String TREFPOS_SATURN = "SATURN";
    public static final String TREFPOS_URANUS = "URANUS";
    public static final String TREFPOS_NEPTUNE = "NEPTUNE";
    public static final String PLEPHEM_DE200 = "DE200";
    public static final String PLEPHEM_DE405 = "DE405";
    public static final String PLEPHEM_DE421 = "DE421";
    public static final String PLEPHEM_DE430 = "DE430";
    public static final String PLEPHEM_DE431 = "DE431";
    public static final String PLEPHEM_DE432 = "DE432";
    public static final String PLEPHEM_DE440 = "DE440";
    public static final String PLEPHEM_DE441 = "DE441";
    public static final String TIMEUNIT_SECOND = "s";
    public static final String TIMEUNIT_DAY = "d";
    public static final String TIMEUNIT_JULIAN_YEAR = "a";
    public static final String TIMEUNIT_JULIAN_CENTURY = "cy";
    public static final String TIMEUNIT_MINUTE = "min";
    public static final String TIMEUNIT_HOUR = "h";
    public static final String TIMEUNIT_YEAR = "yr";
    public static final String TIMEUNIT_TROPICAL_YEAR = "ta";
    public static final String TIMEUNIT_BESSELIAN_YEAR = "Ba";
    private final FitsKey key;

    private DateTime(IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this(null, status, hdu, valueType, comment);
    }

    private DateTime(String headerName, IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this.key = new FitsKey(headerName == null ? this.name() : headerName, status, hdu, valueType, comment);
        FitsKey.registerStandard(this);
    }

    @Override
    public final FitsKey impl() {
        return this.key;
    }
}

