/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import nom.tam.fits.header.IFitsHeader;

public class FitsKey
implements IFitsHeader,
Serializable {
    private static final long serialVersionUID = -8312303744399173040L;
    private final String comment;
    private final IFitsHeader.HDU hdu;
    private final String key;
    private final IFitsHeader.SOURCE status;
    private final IFitsHeader.VALUE valueType;
    private static HashSet<String> commentStyleKeys = new HashSet();
    private static final Map<String, IFitsHeader> STANDARD_KEYS = new HashMap<String, IFitsHeader>();
    static final int BASE_10 = 10;

    public FitsKey(String headerName, IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) throws IllegalArgumentException {
        if (headerName.length() > 8) {
            throw new IllegalArgumentException("Keyword " + headerName + " exceeeds the FITS " + 8 + " character limit");
        }
        for (int i = 0; i < headerName.length(); ++i) {
            char c = headerName.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '/' || c == 'n' || c == 'a' && i + 1 == headerName.length()) continue;
            throw new IllegalArgumentException("Invalid FITS keyword: " + headerName);
        }
        this.key = headerName;
        this.status = status;
        this.hdu = hdu;
        this.valueType = valueType;
        this.comment = comment;
        if (valueType == IFitsHeader.VALUE.NONE) {
            commentStyleKeys.add(headerName);
        }
    }

    public FitsKey(String headerName, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) throws IllegalArgumentException {
        this(headerName, IFitsHeader.SOURCE.UNKNOWN, hdu, valueType, comment);
    }

    public FitsKey(String headerName, IFitsHeader.VALUE valueType, String comment) throws IllegalArgumentException {
        this(headerName, IFitsHeader.HDU.ANY, valueType, comment);
    }

    @Override
    public final FitsKey impl() {
        return this;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public IFitsHeader.HDU hdu() {
        return this.hdu;
    }

    @Override
    public String key() {
        if (this.key.endsWith("a")) {
            return this.key.substring(0, this.key.length() - 1);
        }
        return this.key;
    }

    @Override
    public IFitsHeader.SOURCE status() {
        return this.status;
    }

    @Override
    public IFitsHeader.VALUE valueType() {
        return this.valueType;
    }

    public static boolean isCommentStyleKey(String key) {
        return commentStyleKeys.contains(key) || key.trim().isEmpty();
    }

    static void registerStandard(IFitsHeader key) throws IllegalArgumentException {
        STANDARD_KEYS.put(key.key(), key);
    }

    static IFitsHeader matchStandard(String key) {
        int i = 0;
        int l = key.length();
        StringBuilder pattern = new StringBuilder();
        if (l > 1 && Character.isAlphabetic(key.charAt(l - 1)) && Character.isDigit(key.charAt(l - 2))) {
            key = key.substring(0, --l);
        }
        if (i < l && Character.isDigit(key.charAt(i))) {
            pattern.append('n');
            if (++i < l && Character.isDigit(key.charAt(i))) {
                pattern.append('n');
                ++i;
            }
        }
        while (i < l) {
            char c = key.charAt(i);
            if (Character.isDigit(c)) {
                pattern.append('n');
                while (i < l && Character.isDigit(key.charAt(i))) {
                    ++i;
                }
                continue;
            }
            pattern.append(c);
            ++i;
        }
        return STANDARD_KEYS.get(pattern.toString());
    }
}

