/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.FitsKey;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;

public final class GenericKey {
    private static final int NUMBER_BASE = 10;

    public static IFitsHeader create(String key) {
        IFitsHeader result = GenericKey.lookup(key);
        if (result == null) {
            result = new FitsKey(key, IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.ANY, "");
        }
        return result;
    }

    public static IFitsHeader[] create(String[] keys) {
        IFitsHeader[] result = new IFitsHeader[keys.length];
        for (int index = 0; index < result.length; ++index) {
            result[index] = GenericKey.create(keys[index]);
        }
        return result;
    }

    public static int getN(String key) {
        int index = key.length() - 1;
        int n = 0;
        int numberBase = 1;
        if (Character.isAlphabetic(key.charAt(index))) {
            --index;
        }
        while (index >= 0 && Character.isDigit(key.charAt(index))) {
            n += (key.charAt(index) - 48) * numberBase;
            numberBase *= 10;
            --index;
        }
        return n;
    }

    public static IFitsHeader lookup(String key) {
        return Standard.match(key);
    }

    private GenericKey() {
    }
}

