/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import java.util.NoSuchElementException;
import nom.tam.fits.header.FitsKey;

public interface IFitsHeader {
    public static final int MAX_INDEX = 999;

    default public FitsKey impl() {
        return null;
    }

    default public String comment() {
        return this.impl().comment();
    }

    default public HDU hdu() {
        return this.impl().hdu();
    }

    default public String key() {
        return this.impl().key();
    }

    default public IFitsHeader n(int ... numbers) throws IndexOutOfBoundsException, NoSuchElementException, IllegalStateException {
        StringBuffer headerName = new StringBuffer(this.key());
        for (int number : numbers) {
            if (number < 0 || number > 999) {
                throw new IndexOutOfBoundsException(this.key() + ": index " + number + " is out of bounds.");
            }
            int indexOfN = headerName.indexOf("n");
            if (indexOfN < 0) {
                throw new NoSuchElementException("Too many indices (" + numbers.length + ") supplied for " + this.key());
            }
            headerName.replace(indexOfN, indexOfN + 1, Integer.toString(number));
        }
        if (headerName.length() > 8) {
            throw new IllegalStateException("indexed keyword " + headerName.toString() + " is too long.");
        }
        return new FitsKey(headerName.toString(), this.status(), this.hdu(), this.valueType(), this.comment());
    }

    default public SOURCE status() {
        return this.impl().status();
    }

    default public VALUE valueType() {
        return this.impl().valueType();
    }

    default public int[] extractIndices(String key) throws IllegalArgumentException {
        int i;
        String pattern = this.key();
        int j = 0;
        int lp = pattern.length();
        int lk = key.length();
        int n = 0;
        for (i = 0; i < lp; ++i) {
            if (pattern.charAt(i) != 'n') continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        int[] idx = new int[n];
        n = 0;
        for (i = 0; i < lp; ++i) {
            if (pattern.charAt(i) == 'n') {
                if (i + 1 < lp && pattern.charAt(i + 1) == 'n') {
                    idx[n++] = key.charAt(j++) - 48;
                    continue;
                }
                int value = 0;
                while (j < lk && Character.isDigit(key.charAt(j))) {
                    value = 10 * value + key.charAt(j++) - 48;
                }
                idx[n++] = value;
                continue;
            }
            if (key.charAt(j++) == pattern.charAt(i)) continue;
            throw new IllegalArgumentException("Key " + key + " does no match pattern " + pattern);
        }
        return idx;
    }

    public static enum HDU {
        ANY,
        IMAGE,
        GROUPS,
        TABLE,
        ASCII_TABLE,
        BINTABLE,
        PRIMARY,
        EXTENSION,
        PRIMARY_EXTENSION;

    }

    public static enum SOURCE {
        CHECKSUM("http://heasarc.gsfc.nasa.gov/docs/heasarc/ofwg/docs/general/checksum/checksum.html"),
        CXC("http://cxc.harvard.edu/contrib/arots/fits/content.txt"),
        ESO("http://arcdev.hq.eso.org/dicb/dicd/dic-1-1.4.html"),
        HEASARC("http://heasarc.gsfc.nasa.gov/docs/heasarc/ofwg/docs/ofwg_recomm/r13.html"),
        INTEGRAL(null),
        MANDATORY("http://heasarc.gsfc.nasa.gov/docs/fcg/standard_dict.html"),
        MaxImDL("http://www.cyanogen.com/help/maximdl/FITS_File_Header_Definitions.htm"),
        NOAO("http://iraf.noao.edu/iraf/web/projects/ccdmosaic/imagedef/fitsdic.html"),
        RESERVED("http://heasarc.gsfc.nasa.gov/docs/fcg/standard_dict.html"),
        ROSAT(null),
        SBIG("http://archive.sbig.com/pdffiles/SBFITSEXT_1r0.pdf"),
        STScI("http://tucana.noao.edu/ADASS/adass_proc/adass_95/zaraten/zaraten.html"),
        UCOLICK("http://www.ucolick.org"),
        UNKNOWN(null);

        private final String url;

        private SOURCE(String url) {
            this.url = url;
        }

        public String url() {
            return this.url;
        }
    }

    public static enum VALUE {
        NONE,
        LOGICAL,
        STRING,
        INTEGER,
        REAL,
        COMPLEX,
        ANY;

    }
}

