/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.FitsKey;
import nom.tam.fits.header.IFitsHeader;

public enum InstrumentDescription implements IFitsHeader
{
    APERTURE(IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of field of view aperture"),
    DATAMODE(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "pre-processor data mode"),
    DETNAM(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of the detector used to make the observation"),
    FILTER(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of filter used during the observation"),
    FILTERn(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of filters used during the observation"),
    GRATING(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of the grating used during the observation."),
    GRATINGn(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of gratings used during the observation."),
    OBS_MODE(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "instrumental mode of the observation"),
    SATURATE(IFitsHeader.SOURCE.STScI, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "data value at which saturation occurs");

    private final FitsKey key;

    private InstrumentDescription(IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this.key = new FitsKey(this.name(), status, hdu, valueType, comment);
    }

    @Override
    public final FitsKey impl() {
        return this.key;
    }
}

