/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.FitsKey;
import nom.tam.fits.header.IFitsHeader;

public enum ObservationDescription implements IFitsHeader
{
    AIRMASS(IFitsHeader.SOURCE.NOAO, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "air mass"),
    DEC(IFitsHeader.SOURCE.NOAO, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "declination of the observed object"),
    DEC_NOM(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "nominal declination of the observation"),
    DEC_OBJ(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "declination of the observed object"),
    DEC_PNT(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "declination of the pointed direction of the instrument"),
    DEC_SCX(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "declination of the X spacecraft axis"),
    DEC_SCZ(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "declination of the Z spacecraft axis"),
    LATITUDE(IFitsHeader.SOURCE.UCOLICK, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "geographic latitude of the observation"),
    MOONANGL(IFitsHeader.SOURCE.STScI, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "angle between the observation and the moon"),
    OBJNAME(IFitsHeader.SOURCE.NOAO, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "AU name of observed object"),
    OBS_ID(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "unique observation ID"),
    ORIENTAT(IFitsHeader.SOURCE.STScI, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "position angle of image y axis (deg. E of N)"),
    PA_PNT(IFitsHeader.SOURCE.UCOLICK, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "position angle of the pointing"),
    RA(IFitsHeader.SOURCE.NOAO, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "R.A. of the observation"),
    RA_NOM(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "nominal R.A. of the observation"),
    RA_OBJ(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "R.A. of the observed object"),
    RA_PNT(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "R.A. of the pointed direction of the instrument"),
    RA_SCX(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "R.A. of the X spacecraft axis"),
    RA_SCY(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "R.A. of the Y spacecraft axis"),
    RA_SCZ(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "R.A. of the Z spacecraft axis"),
    SUNANGLE(IFitsHeader.SOURCE.STScI, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "angle between the observation and the sun");

    private final FitsKey key;

    private ObservationDescription(IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this.key = new FitsKey(this.name(), status, hdu, valueType, comment);
    }

    @Override
    public final FitsKey impl() {
        return this.key;
    }
}

