/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import java.util.Date;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.ImageData;
import nom.tam.fits.RandomGroupsData;
import nom.tam.fits.TableData;
import nom.tam.fits.UndefinedData;
import nom.tam.fits.header.FitsKey;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.StandardCommentReplacement;

public enum Standard implements IFitsHeader
{
    AUTHOR(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "author name(s)", new StandardCommentReplacement[0]),
    BITPIX(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "bits per data element", Standard.replaceable("header:bitpix", Object.class)),
    BLANK(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.INTEGER, "value used for undefined array elements", new StandardCommentReplacement[0]),
    BLANKS("", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.NONE, null, new StandardCommentReplacement[0]),
    BLOCKED(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.LOGICAL, "Non-standard FITS block size", new StandardCommentReplacement[0]),
    BSCALE(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "data quantization scaling", new StandardCommentReplacement[0]),
    BUNIT(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "data physical unit", new StandardCommentReplacement[0]),
    BZERO(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "data quantization offset", new StandardCommentReplacement[0]),
    CDELTn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate spacing along axis", new StandardCommentReplacement[0]),
    COMMENT(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.NONE, null, new StandardCommentReplacement[0]),
    CONTINUE(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.NONE, null, new StandardCommentReplacement[0]),
    CROTAn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "[deg] coordinate axis rotation angle", new StandardCommentReplacement[0]),
    CRPIXn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate axis reference pixel", new StandardCommentReplacement[0]),
    CRVALn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate axis value at reference pixel", new StandardCommentReplacement[0]),
    CTYPEn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "coordinate axis type / name", new StandardCommentReplacement[0]),
    DATAMAX(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "maximum data value", new StandardCommentReplacement[0]),
    DATAMIN(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "minimum data value", new StandardCommentReplacement[0]),
    DATE(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "date of file creation", new StandardCommentReplacement[0]),
    DATE_OBS("DATE-OBS", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "date of the observation", new StandardCommentReplacement[0]),
    END(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.NONE, null, new StandardCommentReplacement[0]),
    EPOCH(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[yr] equinox of celestial coordinate system", new StandardCommentReplacement[0]),
    EQUINOX(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[yr] equinox of celestial coordinate system", new StandardCommentReplacement[0]),
    EXTEND(IFitsHeader.SOURCE.INTEGRAL, IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.LOGICAL, "allow extensions", new StandardCommentReplacement[0]),
    EXTLEVEL(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "hierarchical level of the extension", new StandardCommentReplacement[0]),
    EXTNAME(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "HDU name", new StandardCommentReplacement[0]),
    EXTVER(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "HDU version", new StandardCommentReplacement[0]),
    GCOUNT(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "group count", Standard.replaceable("randomgroupsdata:groups", RandomGroupsData.class), Standard.replaceable("undefineddata:groups", UndefinedData.class), Standard.replaceable("header:groups", RandomGroupsData.class)),
    GROUPS(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.GROUPS, IFitsHeader.VALUE.LOGICAL, "random groups data", Standard.replaceable("randomgroupsdata:groups", RandomGroupsData.class)),
    HISTORY(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.NONE, "processing history of the data", new StandardCommentReplacement[0]),
    INSTRUME(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of instrument", new StandardCommentReplacement[0]),
    NAXIS(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "dimensionality of data", new StandardCommentReplacement[0]),
    NAXISn(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "n'th data dimension", Standard.replaceable("tablehdu:naxis1", TableData.class, "Size of table row in bytes"), Standard.replaceable("tablehdu:naxis2", TableData.class, "Number of table rows"), Standard.replaceable("header:naxis2", Object.class)),
    OBJECT(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of observed object", new StandardCommentReplacement[0]),
    OBSERVER(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "observer(s) who acquired the data", new StandardCommentReplacement[0]),
    ORIGIN(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "organization responsible for the data", new StandardCommentReplacement[0]),
    PCOUNT(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "associated parameter count", Standard.replaceable("binarytable:pcount", TableData.class, "heap size in bytes"), Standard.replaceable("randomgroups:pcount", RandomGroupsData.class, "parameter values per group"), Standard.replaceable("undefineddata:pcount", UndefinedData.class), Standard.replaceable("header:pcount", Object.class)),
    PSCALn(IFitsHeader.SOURCE.INTEGRAL, IFitsHeader.HDU.GROUPS, IFitsHeader.VALUE.REAL, "parameter quantization scaling", new StandardCommentReplacement[0]),
    PTYPEn(IFitsHeader.SOURCE.INTEGRAL, IFitsHeader.HDU.GROUPS, IFitsHeader.VALUE.STRING, "name of random groups parameter", new StandardCommentReplacement[0]),
    PZEROn(IFitsHeader.SOURCE.INTEGRAL, IFitsHeader.HDU.GROUPS, IFitsHeader.VALUE.REAL, "parameter quantization offset", new StandardCommentReplacement[0]),
    RADESYS(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "celestial coordinate reference frame", new StandardCommentReplacement[0]),
    RADECSYS(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "celestial coordinate reference frame", new StandardCommentReplacement[0]),
    RESTFRQ(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "[Hz] line rest frequency", new StandardCommentReplacement[0]),
    RESTFREQ(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[Hz] observed line rest frequency", new StandardCommentReplacement[0]),
    REFERENC(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "bibliographic reference", new StandardCommentReplacement[0]),
    SIMPLE(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.LOGICAL, "primary HDU", Standard.replaceable("header:simple", Object.class, "Java FITS: " + new Date())),
    TBCOLn(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ASCII_TABLE, IFitsHeader.VALUE.INTEGER, "column byte offset", Standard.replaceable("asciitable:tbcolN", AsciiTable.class)),
    TDIMn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.BINTABLE, IFitsHeader.VALUE.STRING, "dimensionality of column array elements", Standard.replaceable("binarytable:tdimN", BinaryTable.class)),
    TDISPn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column display format", new StandardCommentReplacement[0]),
    TELESCOP(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of telescope / observatory", new StandardCommentReplacement[0]),
    TFIELDS(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.INTEGER, "number of columns in the table", new StandardCommentReplacement[0]),
    TFORMn(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column data format", Standard.replaceable("asciitable:tformN", AsciiTable.class), Standard.replaceable("binarytable:tformN", BinaryTable.class)),
    THEAP(IFitsHeader.SOURCE.INTEGRAL, IFitsHeader.HDU.BINTABLE, IFitsHeader.VALUE.INTEGER, "heap byte offset", Standard.replaceable("binarytable:theap", BinaryTable.class)),
    TNULLn(IFitsHeader.SOURCE.INTEGRAL, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.ANY, "column value for undefined elements", new StandardCommentReplacement[0]),
    TSCALn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column quantization scaling", new StandardCommentReplacement[0]),
    TTYPEn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column name", new StandardCommentReplacement[0]),
    TUNITn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column physical unit", new StandardCommentReplacement[0]),
    TZEROn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column quantization offset", new StandardCommentReplacement[0]),
    TDMAXn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "maximum value in the column", new StandardCommentReplacement[0]),
    TDMINn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "minimum value in the column", new StandardCommentReplacement[0]),
    TLMAXn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "maximum legal value in the column", new StandardCommentReplacement[0]),
    TLMINn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "minimum legal value in the column", new StandardCommentReplacement[0]),
    XTENSION(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.STRING, "HDU extension type", Standard.replaceable("imagedata:xtension", ImageData.class, "image HDU"), Standard.replaceable("binarytable:xtension", BinaryTable.class, "binary table HDU"), Standard.replaceable("asciitable:xtension", AsciiTable.class, "ASCII table HDU"), Standard.replaceable("undefineddata:xtension", UndefinedData.class), Standard.replaceable("header:xtension", Object.class)),
    INHERIT(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.LOGICAL, "inherit primary header entries", new StandardCommentReplacement[0]);

    private static final ThreadLocal<Class<?>> COMMENT_CONTEXT;
    public static final IFitsHeader NAXIS1;
    public static final IFitsHeader NAXIS2;
    public static final String XTENSION_ASCIITABLE = "TABLE";
    public static final String XTENSION_BINTABLE = "BINTABLE";
    public static final String XTENSION_IMAGE = "IMAGE";
    private final StandardCommentReplacement[] commentReplacements;
    private final FitsKey key;

    private Standard(IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment, StandardCommentReplacement ... replacements) {
        this(null, status, hdu, valueType, comment, replacements);
    }

    private Standard(String headerName, IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment, StandardCommentReplacement ... replacements) {
        this.key = new FitsKey(headerName == null ? this.name() : headerName, status, hdu, valueType, comment);
        this.commentReplacements = replacements;
        FitsKey.registerStandard(this);
    }

    @Override
    public final FitsKey impl() {
        return this.key;
    }

    @Override
    public String comment() {
        Class<Object> contextClass = COMMENT_CONTEXT.get();
        if (contextClass == null) {
            contextClass = Object.class;
        }
        for (StandardCommentReplacement stdCommentReplacement : this.commentReplacements) {
            if (!stdCommentReplacement.getContext().isAssignableFrom(contextClass) || stdCommentReplacement.getComment() == null) continue;
            return stdCommentReplacement.getComment();
        }
        return this.key.comment();
    }

    public static void context(Class<?> clazz) {
        COMMENT_CONTEXT.set(clazz);
    }

    public String getCommentByKey(String commentKey) {
        for (StandardCommentReplacement commentReplacement : this.commentReplacements) {
            if (!commentReplacement.getRef().equals(commentKey)) continue;
            String foundcommentReplacement = commentReplacement.getComment();
            if (foundcommentReplacement == null) {
                return this.comment();
            }
            return foundcommentReplacement;
        }
        return null;
    }

    public void setCommentByKey(String commentKey, String value) {
        for (StandardCommentReplacement commentReplacement : this.commentReplacements) {
            if (!commentReplacement.getRef().equals(commentKey)) continue;
            commentReplacement.setComment(value);
            return;
        }
    }

    private static StandardCommentReplacement replaceable(String string, Class<?> clazz) {
        return new StandardCommentReplacement(string, clazz);
    }

    private static StandardCommentReplacement replaceable(String string, Class<?> clazz, String comment) {
        return new StandardCommentReplacement(string, clazz, comment);
    }

    public static IFitsHeader match(String key) {
        return FitsKey.matchStandard(key);
    }

    static {
        COMMENT_CONTEXT = new ThreadLocal();
        NAXIS1 = NAXISn.n(1);
        NAXIS2 = NAXISn.n(2);
    }
}

