/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.header.Standard;
import nom.tam.fits.header.WCS;

public enum Stokes {
    I(1),
    Q(2),
    U(3),
    V(4),
    RR(-1),
    LL(-2),
    RL(-3),
    LR(-4),
    XX(-5),
    YY(-6),
    XY(-7),
    YX(-8);

    public static final String CTYPE = "STOKES";
    private int index;
    private static Stokes[] ordered;
    private static final int STANDARD_PARAMETER_COUNT = 4;
    private static final int FULL_PARAMETER_COUNT = 8;
    static final int REVERSED_ORDER = 1;
    public static final int LINEAR_CROSS_POLARIZATION = 2;
    public static final int CIRCULAR_CROSS_POLARIZATION = 4;
    public static final int FULL_CROSS_POLARIZATION = 6;

    private Stokes(int value) {
        this.index = value;
    }

    public final int getCoordinateValue() {
        return this.index;
    }

    public static Stokes forCoordinateValue(int value) throws IndexOutOfBoundsException {
        return ordered[value - YX.getCoordinateValue()];
    }

    public static Parameters parameters() {
        return Stokes.parameters(0);
    }

    public static Parameters parameters(int flags) {
        return new Parameters(flags);
    }

    private static Parameters forCoords(double start, double delt, int count) throws FitsException {
        int offset = (int)start;
        if (start != (double)offset) {
            throw new FitsException("Invalid (non-integer) Stokes coordinate start: " + start);
        }
        int step = (int)delt;
        if (delt != (double)step) {
            throw new FitsException("Invalid (non-integer) Stokes coordinate step: " + delt);
        }
        int end = offset + step * (count - 1);
        if (Math.min(offset, end) <= 0 && Math.max(offset, end) >= 0) {
            throw new FitsException("Invalid Stokes coordinate range: " + offset + ":" + end);
        }
        return new Parameters(offset, step, count);
    }

    public static Map.Entry<Integer, Parameters> fromImageHeader(Header header) throws FitsException {
        int n = header.getIntValue(Standard.NAXIS);
        if (n <= 0) {
            throw new FitsException("Missing, invalid, or insufficient NAXIS in header");
        }
        int i = 1;
        while (i <= n) {
            if (!CTYPE.equalsIgnoreCase(header.getStringValue(WCS.CTYPEna.n(i++)))) continue;
            if (header.getDoubleValue(WCS.CRPIXna.n(i), 1.0) != 1.0) {
                throw new FitsException("Invalid Stokes " + WCS.CRPIXna.n(i).key() + " value: " + header.getDoubleValue(WCS.CRPIXna.n(i)) + ", expected 1");
            }
            Parameters p = Stokes.forCoords(header.getDoubleValue(WCS.CRVALna.n(i), 0.0), header.getDoubleValue(WCS.CDELTna.n(i), 1.0), header.getIntValue(Standard.NAXISn.n(i), 1));
            return new AbstractMap.SimpleImmutableEntry<Integer, Parameters>(n - i, p);
        }
        return null;
    }

    public static Map.Entry<Integer, Parameters> fromTableHeader(Header header, int column) throws IndexOutOfBoundsException, FitsException {
        String dims;
        if (column < 0) {
            throw new IndexOutOfBoundsException("Invalid Java column index " + column);
        }
        if ((dims = header.getStringValue(Standard.TDIMn.n(++column))) == null) {
            throw new FitsException("Missing TDIM" + column + " in header");
        }
        StringTokenizer tokens = new StringTokenizer(dims, "(, )");
        int n = tokens.countTokens();
        int i = 1;
        while (i <= n) {
            String d = tokens.nextToken();
            if (!CTYPE.equalsIgnoreCase(header.getStringValue(WCS.nCTYPn.n(i++, column)))) continue;
            if (header.getDoubleValue(WCS.nCRPXn.n(i, column), 1.0) != 1.0) {
                throw new FitsException("Invalid Stokes " + WCS.nCRPXn.n(i, column).key() + " value: " + header.getDoubleValue(WCS.nCRPXn.n(i, column)) + ", expected 1");
            }
            Parameters p = Stokes.forCoords(header.getDoubleValue(WCS.nCRVLn.n(i, column), 0.0), header.getDoubleValue(WCS.nCDLTn.n(i, column), 1.0), Integer.parseInt(d));
            return new AbstractMap.SimpleImmutableEntry<Integer, Parameters>(n - i, p);
        }
        return null;
    }

    static {
        ordered = new Stokes[]{YX, XY, YY, XX, LR, RL, LL, RR, null, I, Q, U, V};
    }

    public static final class Parameters {
        private int flags;
        private int offset;
        private int step;
        private int count;

        private Parameters(int flags) {
            this.flags = flags;
            boolean reversed = (flags & 1) != 0;
            this.step = reversed ? -1 : 1;
            this.count = 4;
            if ((flags & 6) == 0) {
                this.offset = reversed ? V.getCoordinateValue() : I.getCoordinateValue();
            } else {
                this.step = -this.step;
                if ((flags & 4) == 0) {
                    this.offset = reversed ? YX.getCoordinateValue() : XX.getCoordinateValue();
                } else if ((flags & 2) == 0) {
                    this.offset = reversed ? LR.getCoordinateValue() : RR.getCoordinateValue();
                } else {
                    this.offset = reversed ? YX.getCoordinateValue() : RR.getCoordinateValue();
                    this.count = 8;
                }
            }
        }

        private Parameters(int offset, int step, int n) {
            this.offset = offset;
            this.step = step;
            this.count = n;
            if (offset < 0) {
                int end = offset + (n - 1) * step;
                if (Math.min(offset, end) <= XX.index) {
                    this.flags |= 2;
                }
                if (Math.max(offset, end) > XX.index) {
                    this.flags |= 4;
                }
                step = -step;
            }
            if (step < 0) {
                this.flags |= 1;
            }
        }

        public int hashCode() {
            return this.flags ^ Integer.hashCode(this.offset) ^ Integer.hashCode(this.step);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Parameters)) {
                return false;
            }
            Parameters p = (Parameters)o;
            if (p.flags != this.flags) {
                return false;
            }
            if (p.offset != this.offset) {
                return false;
            }
            return p.step == this.step;
        }

        boolean isReversedOrder() {
            return (this.flags & 1) != 0;
        }

        public boolean isCrossPolarization() {
            return (this.flags & 6) != 0;
        }

        public boolean hasLinearPolarization() {
            return (this.flags & 6) != 4;
        }

        public boolean hasCircularPolarization() {
            return (this.flags & 6) != 2;
        }

        public Stokes getParameter(int idx) throws IndexOutOfBoundsException {
            if (idx < 0 || idx >= this.count) {
                throw new IndexOutOfBoundsException();
            }
            return Stokes.forCoordinateValue(this.offset + this.step * idx);
        }

        public ArrayList<Stokes> getAvailableParameters() {
            ArrayList<Stokes> list = new ArrayList<Stokes>(this.count);
            for (int i = 0; i < this.count; ++i) {
                list.add(this.getParameter(i));
            }
            return list;
        }

        public int getArrayIndex(Stokes s) {
            return (s.getCoordinateValue() - this.offset) / this.step;
        }

        public void fillImageHeader(Header header, int coordinateIndex) throws FitsException {
            int n = header.getIntValue(Standard.NAXIS);
            if (n == 0) {
                throw new FitsException("Missing NAXIS in header");
            }
            if (coordinateIndex < 0 || coordinateIndex >= n) {
                throw new IndexOutOfBoundsException("Invalid Java coordinate index " + coordinateIndex + " (for " + n + " dimensions)");
            }
            int i = n - coordinateIndex;
            header.addValue(WCS.CTYPEna.n(i), Stokes.CTYPE);
            header.addValue(WCS.CRPIXna.n(i), 1);
            header.addValue(WCS.CRVALna.n(i), this.offset);
            header.addValue(WCS.CDELTna.n(i), this.step);
        }

        public void fillTableHeader(Header header, int column, int coordinateIndex) throws IndexOutOfBoundsException, FitsException {
            String dims;
            if (column < 0) {
                throw new IndexOutOfBoundsException("Invalid Java column index " + column);
            }
            if ((dims = header.getStringValue(Standard.TDIMn.n(++column))) == null) {
                throw new FitsException("Missing TDIM" + column + " in header");
            }
            StringTokenizer tokens = new StringTokenizer(dims, "(, )");
            int n = tokens.countTokens();
            if (coordinateIndex < 0 || coordinateIndex >= n) {
                throw new IndexOutOfBoundsException("Invalid Java coordinate index " + coordinateIndex + " (for " + n + " dimensions)");
            }
            int i = n - coordinateIndex;
            header.addValue(WCS.nCTYPn.n(i, column), Stokes.CTYPE);
            header.addValue(WCS.nCRPXn.n(i, column), 1);
            header.addValue(WCS.nCRVLn.n(i, column), this.offset);
            header.addValue(WCS.nCDLTn.n(i, column), this.step);
        }
    }
}

