/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import java.util.Arrays;
import nom.tam.fits.header.DataDescription;
import nom.tam.fits.header.DateTime;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.ObservationDurationDescription;
import nom.tam.fits.header.Standard;
import nom.tam.fits.header.WCS;
import nom.tam.fits.header.extra.NOAOExt;
import nom.tam.fits.header.extra.SBFitsExt;
import nom.tam.fits.header.extra.STScIExt;

public enum Synonyms {
    EQUINOX(Standard.EQUINOX, Standard.EPOCH),
    TIMESYS(NOAOExt.TIMESYS, STScIExt.TIMESYS),
    RADESYS(Standard.RADESYS, Standard.RADECSYS),
    RESTFRQ(Standard.RESTFRQ, WCS.RESTFREQ),
    TPn_na(WCS.TPn_na, WCS.TPCn_na),
    TCn_na(WCS.TCn_na, WCS.TCDn_na),
    TSn_na(WCS.TVn_na, WCS.TPSn_na),
    TVn_na(WCS.TVn_na, WCS.TPVn_na),
    WCSna(WCS.WCSna, WCS.TWCSna),
    nSn_na(WCS.nSn_na, WCS.nPSn_na),
    nVn_na(WCS.nVn_na, WCS.nPVn_na),
    EXTNAME(Standard.EXTNAME, DataDescription.HDUNAME),
    EXTVER(Standard.EXTVER, DataDescription.HDUVER),
    EXTLEVEL(Standard.EXTLEVEL, DataDescription.HDULEVEL),
    EXPOSURE(ObservationDurationDescription.EXPOSURE, ObservationDurationDescription.EXPTIME, ObservationDurationDescription.ONTIME),
    TSTART(DateTime.TSTART, ObservationDurationDescription.TIME_OBS),
    TSTOP(DateTime.TSTOP, ObservationDurationDescription.TIME_END),
    DARKTIME(NOAOExt.DARKTIME, SBFitsExt.DARKTIME);

    private final IFitsHeader primaryKeyword;
    private final IFitsHeader[] synonyms;

    private Synonyms(IFitsHeader primaryKeyword, IFitsHeader ... synonyms) {
        this.primaryKeyword = primaryKeyword;
        this.synonyms = synonyms;
    }

    public IFitsHeader[] getSynonyms() {
        return Arrays.copyOf(this.synonyms, this.synonyms.length);
    }

    public IFitsHeader primaryKeyword() {
        return this.primaryKeyword;
    }

    public static IFitsHeader primaryKeyword(IFitsHeader key) {
        for (Synonyms synonym : Synonyms.values()) {
            for (IFitsHeader synHeader : synonym.synonyms) {
                if (!synHeader.equals(key)) continue;
                return synonym.primaryKeyword();
            }
        }
        return key;
    }

    public static String primaryKeyword(String header) {
        for (Synonyms synonym : Synonyms.values()) {
            for (IFitsHeader synHeader : synonym.synonyms) {
                if (!synHeader.key().equals(header)) continue;
                return synonym.primaryKeyword().key();
            }
        }
        return header;
    }
}

