/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.FitsKey;
import nom.tam.fits.header.IFitsHeader;

public enum WCS implements IFitsHeader
{
    WCSNAMEa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "coordinate system name"),
    WCSAXESa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.INTEGER, "coordinate dimensions"),
    RADESYSa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "celestial coordinate reference frame."),
    RADECSYS(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "celestial coordinate reference frame."),
    LONPOLEa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "[deg] celestial pole longitude"),
    LATPOLEa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "[deg] celestial pole latitude"),
    EPOCH(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[yr] equinox of celestial coordinate system"),
    EQUINOXa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "[yr] equinox of celestial coordinate system"),
    CNAMEna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "coordinate system display name"),
    CRPIXna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate axis reference pixel"),
    CRVALna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate axis value at reference pixel"),
    CTYPEna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "name of the coordinate axis"),
    CDELTna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate spacing along axis"),
    CRDERna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "random error in coordinate"),
    CSYERna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "systematic error in coordinate"),
    CZPHSna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "phase axis zero point"),
    CPERIna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "phase axis period"),
    RESTFRQa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "[Hz] line rest frequency"),
    RESTFREQ(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[Hz] observed line rest frequency"),
    RESTWAVa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "[m] line rest wavelength"),
    SPECSYSa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "spectral reference frame"),
    SSYSOBSa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "spectral reference frame of observer"),
    SSYSSRCa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "spectral reference frame of source"),
    VELOSYSa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "[m/s] source radial velocity"),
    ZSOURCEa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "source redshift value"),
    VELANGLa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "[deg] true velocity angle"),
    OBSGEO_X("OBSGEO-X", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[m] geodetic location x of observer"),
    OBSGEO_Y("OBSGEO-Y", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[m] geodetic location y of observer"),
    OBSGEO_Z("OBSGEO-Z", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "[m] geodetic location z of observer"),
    WCSNna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column coordinate syste name"),
    LONPna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[deg] column celestial pole longitude"),
    LATPna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[deg] column celestial pole latitude"),
    EQUIna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[yr] column coordinate epoch"),
    RADEna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column equatorial coordinate frame"),
    RFRQna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[Hz] line rest frequency in column"),
    RWAVna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[m] line rest wavelength in column"),
    SPECna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column spectral reference frame"),
    SOBSna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column observer spectral frame"),
    SSRCna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column source spectral frame"),
    VSYSna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[m/s] column radial velocity"),
    VANGna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[deg] angle of velocity in column"),
    ZSOUna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column redshift value"),
    OBSGXn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[m] column geodetic location x"),
    OBSGYn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[m] column geodetic location y"),
    OBSGZn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[m] column geodetic location z"),
    nCTYPn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column coordinate axis type"),
    nCTYna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column coordinate axis type"),
    nCNAna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column coordinate axis type"),
    nCUNIn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column coordinate axis unit"),
    nCUNna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column coordinate axis unit"),
    nCRVLn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coordinate axis reference value"),
    nCRVna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coordinate axis reference value"),
    nCRDna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coordinate axis random error"),
    nCSYna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coordinate axis systematic error"),
    nCZPna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "phase axis zero point"),
    nCPRna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "phase axis period"),
    nCDLTn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coordinate axis spacing"),
    nCDEna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coordinate axis spacing"),
    nCRPXn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coordinate axis reference pixel"),
    nCRPna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coordinate axis reference pixel"),
    nCROTn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[deg] column coordinate axis rotation"),
    nnPCna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coord. trans. matrix element"),
    nnCDna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column coord. trans. matrix element"),
    nPSn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column axis parameter name"),
    nSn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column axis parameter name"),
    nPVn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column axis parameter value"),
    nVn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column axis parameter value"),
    nVn_Xa(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column parameter array"),
    WCSna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column WCS name"),
    TWCSna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column WCS name"),
    WCAXna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.INTEGER, "column coordinate dimensions"),
    TCTYPn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column pixel axis type"),
    TCTYna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column pixel axis type"),
    TCNAna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column pixel axis name"),
    TCUNIn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column pixel axis unit"),
    TCUNna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column pixel axis unit"),
    TCRVLn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis reference value"),
    TCRVna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis reference value"),
    TCDLTn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis spacing"),
    TCDEna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis spacing"),
    TCRDna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis random error"),
    TCSYna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis random error"),
    TCZPna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "phase axis zero point"),
    TCPRna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "phase axis period"),
    TCRPXn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis reference pixel"),
    TCRPna(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis reference pixel"),
    TPCn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pix trans. matrix element"),
    TPn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pix trans. matrix element"),
    TCROTn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "[deg] column pixel axis rotation"),
    TCDn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pix trans. matrix element"),
    TCn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pix trans. matrix element"),
    TPSn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column axis parameter name"),
    TSn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column axis parameter name"),
    TPVn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis parameter value"),
    TVn_na(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column pixel axis parameter value");

    public static final int WCSAXES_MAX_VALUE = 9;
    public static final String RADESYS_ICRS = "ICRS";
    public static final String RADESYS_FK5 = "FK5";
    public static final String RADESYS_FK4 = "FK4";
    public static final String RADESYS_FK4_NO_E = "FK4-NO-E";
    public static final String RADESYS_GAPPT = "GAPPT";
    public static final String ALGO_LOG = "LOG";
    public static final String ALGO_GRI = "GRI";
    public static final String ALGO_GRA = "GRA";
    public static final String ALGO_TAB = "TAB";
    public static final String SPECTRAL_TYPE_FREQ = "FREQ";
    public static final String SPECTRAL_TYPE_ENER = "ENER";
    public static final String SPECTRAL_TYPE_WAVN = "WAVN";
    public static final String SPECTRAL_TYPE_VRAD = "VRAD";
    public static final String SPECTRAL_TYPE_WAVE = "WAVE";
    public static final String SPECTRAL_TYPE_VOPT = "VOPT";
    public static final String SPECTRAL_TYPE_ZOPT = "ZOPT";
    public static final String SPECTRAL_TYPE_AWAV = "AWAV";
    public static final String SPECTRAL_TYPE_VELO = "VELO";
    public static final String SPECTRAL_TYPE_BETA = "BETA";
    public static final String SPECTRAL_ALGO_F2W = "F2W";
    public static final String SPECTRAL_ALGO_F2V = "F2V";
    public static final String SPECTRAL_ALGO_F2A = "F2A";
    public static final String SPECTRAL_ALGO_W2F = "W2F";
    public static final String SPECTRAL_ALGO_W2V = "W2V";
    public static final String SPECTRAL_ALGO_W2A = "W2A";
    public static final String SPECTRAL_ALGO_V2F = "V2F";
    public static final String SPECTRAL_ALGO_V2W = "V2W";
    public static final String SPECTRAL_ALGO_V2A = "V2A";
    public static final String SPECTRAL_ALGO_A2F = "A2F";
    public static final String SPECTRAL_ALGO_A2W = "A2W";
    public static final String SPECTRAL_ALGO_A2V = "A2V";
    private final FitsKey key;

    private WCS(IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this(null, status, hdu, valueType, comment);
    }

    private WCS(String headerName, IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this.key = new FitsKey(headerName == null ? this.name() : headerName, status, hdu, valueType, comment);
        FitsKey.registerStandard(this);
    }

    @Override
    public final FitsKey impl() {
        return this.key;
    }

    public IFitsHeader alt(char c) throws IllegalArgumentException, UnsupportedOperationException {
        if (!this.name().endsWith("a")) {
            throw new UnsupportedOperationException("WCS keyword " + this.key.key() + " does not support alternatives.");
        }
        if ((c = Character.toUpperCase(c)) < 'A' || c > 'Z') {
            throw new IllegalArgumentException("Expected 'A' through 'Z': Got '%c'");
        }
        return new FitsKey(this.key() + Character.toUpperCase(c), this.status(), this.hdu(), this.valueType(), this.comment());
    }
}

