/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header.hierarch;

import java.util.Locale;
import nom.tam.fits.header.NonStandard;
import nom.tam.fits.header.hierarch.IHierarchKeyFormatter;
import nom.tam.fits.utilities.FitsLineAppender;

public class BlanksDotHierarchKeyFormatter
implements IHierarchKeyFormatter {
    private final String blanks;
    private boolean allowMixedCase;

    public BlanksDotHierarchKeyFormatter(int count) throws IllegalArgumentException {
        if (count < 1) {
            throw new IllegalArgumentException("HIERARCH needs at least one blank space after it.");
        }
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < count; ++index) {
            builder.append(' ');
        }
        this.blanks = builder.toString();
    }

    @Override
    public void append(String key, FitsLineAppender buffer) {
        buffer.append(this.toHeaderString(key));
    }

    @Override
    public int getExtraSpaceRequired(String key) {
        return this.blanks.length();
    }

    @Override
    public String toHeaderString(String key) {
        if (!this.allowMixedCase) {
            key = key.toUpperCase(Locale.US);
        }
        return NonStandard.HIERARCH.key() + this.blanks + key.substring(NonStandard.HIERARCH.key().length() + 1) + " ";
    }

    @Override
    public void setCaseSensitive(boolean value) {
        this.allowMixedCase = value;
    }

    @Override
    public final boolean isCaseSensitive() {
        return this.allowMixedCase;
    }
}

