/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header.hierarch;

import java.util.Locale;
import nom.tam.fits.header.hierarch.IHierarchKeyFormatter;
import nom.tam.fits.utilities.FitsLineAppender;

public class StandardIHierarchKeyFormatter
implements IHierarchKeyFormatter {
    private boolean allowMixedCase;

    @Override
    public String toHeaderString(String key) {
        if (!this.allowMixedCase) {
            key = key.toUpperCase(Locale.US);
        }
        return key.replace('.', ' ') + " ";
    }

    @Override
    public void append(String key, FitsLineAppender buffer) {
        buffer.append(this.toHeaderString(key));
    }

    @Override
    public int getExtraSpaceRequired(String key) {
        return 1;
    }

    @Override
    public void setCaseSensitive(boolean value) {
        this.allowMixedCase = value;
    }

    @Override
    public final boolean isCaseSensitive() {
        return this.allowMixedCase;
    }
}

