/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.utilities;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.util.FitsOutputStream;
import nom.tam.util.RandomAccess;

public final class FitsCheckSum {
    private static final int CHECKSUM_BLOCK_SIZE = 4;
    private static final int CHECKSUM_BLOCK_MASK = 3;
    private static final int CHECKSUM_STRING_SIZE = 16;
    private static final int SHIFT_2_BYTES = 16;
    private static final int MASK_2_BYTES = 65535;
    private static final int MASK_4_BYTES = -1;
    private static final int MASK_BYTE = 255;
    private static final int ASCII_ZERO = 48;
    private static final int BUFFER_SIZE = 32768;
    private static final int[] SELECT_BYTE = new int[]{24, 16, 8, 0};
    private static final String EXCLUDE = ":;<=>?@[\\]^_`";
    private static final String CHECKSUM_DEFAULT = "0000000000000000";
    public static final long HDU_CHECKSUM = 0xFFFFFFFFL;

    private FitsCheckSum() {
    }

    public static long checksum(byte[] data) {
        return FitsCheckSum.checksum(ByteBuffer.wrap(data));
    }

    public static long checksum(byte[] data, int from, int to) {
        return FitsCheckSum.checksum(ByteBuffer.wrap(data, from, to));
    }

    public static long checksum(ByteBuffer data) {
        Checksum sum = new Checksum(0L);
        if (data.remaining() % 4 != 0) {
            throw new IllegalArgumentException("fits blocks must always be divisible by 4");
        }
        data.position(0);
        data.order(ByteOrder.BIG_ENDIAN);
        IntBuffer iData = data.asIntBuffer();
        while (iData.hasRemaining()) {
            sum.add(iData.get());
        }
        return sum.getChecksum();
    }

    private static long checksum(InputStream in) throws IOException {
        Checksum sum = new Checksum(0L);
        DataInputStream din = new DataInputStream(in);
        try {
            while (true) {
                sum.add(din.readInt());
            }
        }
        catch (EOFException e) {
            return sum.getChecksum();
        }
    }

    private static long compute(FitsElement data) throws FitsException {
        long l;
        PipedInputStream in = new PipedInputStream();
        try {
            PipeWriter writer = new PipeWriter(data, in);
            writer.start();
            long sum = FitsCheckSum.checksum(in);
            in.close();
            writer.join();
            if (writer.getException() != null) {
                throw writer.getException();
            }
            l = sum;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (e instanceof FitsException) {
                    throw (FitsException)e;
                }
                throw new FitsException("Exception while checksumming FITS element: " + e.getMessage(), e);
            }
        }
        in.close();
        return l;
    }

    public static long checksum(Data data) throws FitsException {
        return FitsCheckSum.compute(data);
    }

    public static long checksum(Header header) throws FitsException {
        HeaderCard hc = header.getCard(nom.tam.fits.header.Checksum.CHECKSUM);
        String prior = null;
        if (hc != null) {
            prior = hc.getValue();
            hc.setValue(CHECKSUM_DEFAULT);
            hc.setComment(nom.tam.fits.header.Checksum.CHECKSUM.comment());
        } else {
            header.seekTail();
            hc = header.addValue((IFitsHeader)nom.tam.fits.header.Checksum.CHECKSUM, CHECKSUM_DEFAULT);
        }
        long sum = FitsCheckSum.compute(header);
        hc.setValue(prior == null ? FitsCheckSum.encode(sum) : prior);
        return sum;
    }

    public static long checksum(BasicHDU<?> hdu) throws FitsException {
        return FitsCheckSum.sumOf(FitsCheckSum.checksum(hdu.getHeader()), FitsCheckSum.checksum(hdu.getData()));
    }

    public static long checksum(RandomAccess f, long from, long size) throws IOException {
        if (f == null) {
            return 0L;
        }
        int len = (int)Math.min(32768L, size);
        byte[] buf = new byte[len];
        long oldpos = f.position();
        f.position(from);
        long sum = 0L;
        while (size > 0L) {
            len = (int)Math.min(32768L, size);
            len = f.read(buf, 0, len);
            sum = FitsCheckSum.sumOf(sum, FitsCheckSum.checksum(buf, 0, len));
            from += (long)len;
            size -= (long)len;
        }
        f.position(oldpos);
        return sum;
    }

    @Deprecated
    public static String checksumEnc(long c, boolean compl) {
        return FitsCheckSum.encode(c, compl);
    }

    public static String encode(long checksum) {
        return FitsCheckSum.encode(checksum, true);
    }

    public static String encode(long checksum, boolean compl) {
        if (compl) {
            checksum = (checksum ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
        }
        byte[] asc = new byte[16];
        byte[] ch = new byte[4];
        int sum = (int)checksum;
        for (int i = 0; i < 4; ++i) {
            int j;
            int byt = 0xFF & sum >>> SELECT_BYTE[i];
            Arrays.fill(ch, (byte)((byt >>> 2) + 48));
            ch[0] = (byte)(ch[0] + (byte)(byt & 3));
            for (j = 0; j < 4; j += 2) {
                while (EXCLUDE.indexOf(ch[j]) >= 0 || EXCLUDE.indexOf(ch[j + 1]) >= 0) {
                    int n = j;
                    ch[n] = (byte)(ch[n] + 1);
                    int n2 = j + 1;
                    ch[n2] = (byte)(ch[n2] - 1);
                }
            }
            for (j = 0; j < 4; ++j) {
                int k = 4 * j + i;
                k = k == 15 ? 0 : k + 1;
                asc[k] = ch[j];
            }
        }
        return new String(asc, StandardCharsets.US_ASCII);
    }

    public static long decode(String encoded) throws IllegalArgumentException {
        return FitsCheckSum.decode(encoded, true);
    }

    public static long decode(String encoded, boolean compl) throws IllegalArgumentException {
        byte[] bytes = encoded.getBytes(StandardCharsets.US_ASCII);
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Bad checksum with " + bytes.length + " chars (expected 16)");
        }
        byte tmp = bytes[0];
        System.arraycopy(bytes, 1, bytes, 0, 15);
        bytes[15] = tmp;
        int i = 0;
        while (i < 16) {
            if (bytes[i] < 48) {
                throw new IllegalArgumentException("Bad checksum with illegal char " + Integer.toHexString(bytes[i]) + " at pos " + i + " (ASCII below 0x30)");
            }
            int n = i++;
            bytes[n] = (byte)(bytes[n] - 48);
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        long sum = bb.getInt() + bb.getInt() + bb.getInt() + bb.getInt();
        return (compl ? sum ^ 0xFFFFFFFFFFFFFFFFL : sum) & 0xFFFFFFFFL;
    }

    public static long sumOf(long ... parts) {
        Checksum sum = new Checksum(0L);
        for (long part : parts) {
            sum.h += part >>> 16;
            sum.l += part & 0xFFFFL;
        }
        return sum.getChecksum();
    }

    public static long differenceOf(long total, long part) {
        Checksum sum = new Checksum(total);
        sum.h -= part >>> 16;
        sum.l -= part & 0xFFFFL;
        return sum.getChecksum();
    }

    public static void setDatasum(Header header, long datasum) throws FitsException {
        header.addValue((IFitsHeader)nom.tam.fits.header.Checksum.DATASUM, Long.toString(datasum));
        long hsum = FitsCheckSum.checksum(header);
        header.getCard(nom.tam.fits.header.Checksum.CHECKSUM).setValue(FitsCheckSum.encode(FitsCheckSum.sumOf(hsum, datasum)));
    }

    public static void setChecksum(BasicHDU<?> hdu) throws FitsException {
        try {
            FitsCheckSum.setDatasum(hdu.getHeader(), FitsCheckSum.checksum(hdu.getData()));
        }
        catch (FitsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FitsException("Exception while computing data checksum: " + e.getMessage(), e);
        }
    }

    public static long getStoredDatasum(Header header) throws FitsException {
        HeaderCard hc = header.getCard(nom.tam.fits.header.Checksum.DATASUM);
        if (hc == null) {
            throw new FitsException("Header does not have a DATASUM value.");
        }
        return hc.getValue(Long.class, 0L) & 0xFFFFFFFFL;
    }

    public static long getStoredChecksum(Header header) throws FitsException {
        String encoded = header.getStringValue(nom.tam.fits.header.Checksum.CHECKSUM);
        if (encoded == null) {
            throw new FitsException("Header does not have a CHECKUM value.");
        }
        return FitsCheckSum.decode(encoded);
    }

    private static class Checksum {
        private long h;
        private long l;

        Checksum(long prior) {
            this.h = prior >>> 16 & 0xFFFFL;
            this.l = prior & 0xFFFFL;
        }

        void add(int i) {
            this.h += (long)(i >>> 16);
            this.l += (long)(i & 0xFFFF);
        }

        long getChecksum() {
            long locarry;
            long hicarry;
            long hi = this.h & 0xFFFFFFFFFFFFFFFFL;
            long lo = this.l & 0xFFFFFFFFFFFFFFFFL;
            while (((hicarry = hi >>> 16) | (locarry = lo >>> 16)) != 0L) {
                hi = (hi & 0xFFFFL) + locarry;
                lo = (lo & 0xFFFFL) + hicarry;
            }
            return hi << 16 | lo;
        }
    }

    private static class PipeWriter
    extends Thread {
        private Exception exception;
        private PipedOutputStream out;
        private FitsElement data;

        PipeWriter(FitsElement data, PipedInputStream in) throws IOException {
            this.data = data;
            this.out = new PipedOutputStream(in);
        }

        @Override
        public void run() {
            this.exception = null;
            try (FitsOutputStream fos = new FitsOutputStream(this.out);){
                this.data.write(fos);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

