/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import nom.tam.image.ImageTiler;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.RandomAccess;
import nom.tam.util.type.ElementType;

public abstract class StandardImageTiler
implements ImageTiler {
    private final RandomAccess randomAccessFile;
    private final long fileOffset;
    private final int[] dims;
    private final Class<?> base;

    public static long getOffset(int[] dims, int[] pos) {
        long offset = 0L;
        for (int i = 0; i < dims.length; ++i) {
            if (i > 0) {
                offset *= (long)dims[i];
            }
            offset += (long)pos[i];
        }
        return offset;
    }

    protected static boolean incrementPosition(int[] start, int[] current, int[] lengths) {
        int[] steps = new int[start.length];
        Arrays.fill(steps, 1);
        return StandardImageTiler.incrementPosition(start, current, lengths, steps);
    }

    protected static boolean incrementPosition(int[] start, int[] current, int[] lengths, int[] steps) {
        for (int i = start.length - 2; i >= 0; --i) {
            if (current[i] - start[i] >= lengths[i] - steps[i]) continue;
            int n = i;
            current[n] = current[n] + steps[i];
            if (start.length - 1 - (i + 1) >= 0) {
                System.arraycopy(start, i + 1, current, i + 1, start.length - 1 - (i + 1));
            }
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public StandardImageTiler(RandomAccess f, long fileOffset, int[] dims, Class<?> base) {
        this.randomAccessFile = f;
        this.fileOffset = fileOffset;
        this.dims = dims;
        this.base = base;
    }

    @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="this read will never return less than the requested length")
    protected void fillFileData(Object output, long delta, int outputOffset, int segment) throws IOException {
        this.fillFileData(output, delta, outputOffset, segment, 1);
    }

    protected void fillFileData(Object output, long delta, int outputOffset, int segment, int step) throws IOException {
        if (output instanceof ArrayDataOutput) {
            this.fillFileData((ArrayDataOutput)output, delta, segment, step);
        } else {
            this.randomAccessFile.seek(this.fileOffset + delta);
            int got = 0;
            if (this.base == Float.TYPE) {
                got = this.randomAccessFile.read((float[])output, outputOffset, segment);
            } else if (this.base == Integer.TYPE) {
                got = this.randomAccessFile.read((int[])output, outputOffset, segment);
            } else if (this.base == Short.TYPE) {
                got = this.randomAccessFile.read((short[])output, outputOffset, segment);
            } else if (this.base == Double.TYPE) {
                got = this.randomAccessFile.read((double[])output, outputOffset, segment);
            } else if (this.base == Byte.TYPE) {
                got = this.randomAccessFile.read((byte[])output, outputOffset, segment);
            } else if (this.base == Long.TYPE) {
                got = this.randomAccessFile.read((long[])output, outputOffset, segment);
            } else {
                throw new IOException("Invalid type for tile array");
            }
            if (got < 0) {
                throw new EOFException();
            }
        }
    }

    @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="this read will never return less than the requested length")
    protected void fillFileData(ArrayDataOutput output, long delta, int segment) throws IOException {
        this.fillFileData(output, delta, segment, 1);
    }

    @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="this read will never return less than the requested length")
    protected void fillFileData(ArrayDataOutput output, long delta, int segment, int step) throws IOException {
        int currReadByteCount;
        int byteSize = ElementType.forClass(this.base).size();
        int stepSize = (step - 1) * byteSize;
        this.randomAccessFile.seek(this.fileOffset + delta);
        byte[] buffer = new byte[byteSize];
        long seekOffset = this.randomAccessFile.position();
        int expectedBytes = segment * byteSize;
        for (int bytesRead = 0; bytesRead < expectedBytes; bytesRead += currReadByteCount + stepSize) {
            this.randomAccessFile.seek(seekOffset);
            currReadByteCount = this.randomAccessFile.read(buffer, 0, buffer.length);
            if (currReadByteCount < 0) break;
            output.write(buffer, 0, currReadByteCount);
            seekOffset = this.randomAccessFile.position() + (long)stepSize;
        }
        output.flush();
    }

    protected void fillMemData(Object data, int[] posits, int length, Object output, int outputOffset, int dim) throws IOException {
        this.fillMemData(data, posits, length, output, outputOffset, dim, 1);
    }

    protected void fillMemData(Object data, int[] posits, int length, Object output, int outputOffset, int dim, int step) throws IOException {
        if (data instanceof Object[]) {
            Object[] xo = (Object[])data;
            this.fillMemData(xo[posits[dim]], posits, length, output, outputOffset, dim + 1, step);
        } else {
            int startFrom = posits[dim];
            int startTo = outputOffset;
            int copyLength = length;
            if (posits[dim] < 0) {
                startFrom -= posits[dim];
                startTo -= posits[dim];
                copyLength += posits[dim];
            }
            if (posits[dim] + length > this.dims[dim]) {
                copyLength -= posits[dim] + length - this.dims[dim];
            }
            if (output instanceof ArrayDataOutput) {
                ArrayDataOutput arrayDataOutput = (ArrayDataOutput)output;
                for (int i = startFrom; i < startFrom + copyLength; i += step) {
                    if (this.base == Float.TYPE) {
                        arrayDataOutput.writeFloat(Array.getFloat(data, i));
                        continue;
                    }
                    if (this.base == Integer.TYPE) {
                        arrayDataOutput.writeInt(Array.getInt(data, i));
                        continue;
                    }
                    if (this.base == Double.TYPE) {
                        arrayDataOutput.writeDouble(Array.getDouble(data, i));
                        continue;
                    }
                    if (this.base == Long.TYPE) {
                        arrayDataOutput.writeLong(Array.getLong(data, i));
                        continue;
                    }
                    if (this.base == Short.TYPE) {
                        arrayDataOutput.writeShort(Array.getShort(data, i));
                        continue;
                    }
                    if (this.base != Byte.TYPE) continue;
                    arrayDataOutput.writeByte(Array.getByte(data, i));
                }
                arrayDataOutput.flush();
            } else {
                ArrayFuncs.copy(data, startFrom, output, startTo, copyLength, step);
            }
        }
    }

    protected void fillTile(Object data, Object o, int[] newDims, int[] corners, int[] lengths) throws IOException {
        int[] steps = new int[corners.length];
        Arrays.fill(steps, 1);
        this.fillTile(data, o, newDims, corners, lengths, steps);
    }

    protected void fillTile(Object data, Object o, int[] newDims, int[] corners, int[] lengths, int[] steps) throws IOException {
        int n = newDims.length;
        int[] posits = new int[n];
        boolean isStreaming = o instanceof ArrayDataOutput;
        int baseLength = isStreaming ? ElementType.forClass(this.base).size() : ArrayFuncs.getBaseLength(o);
        int segment = lengths[n - 1];
        int segmentStep = steps[n - 1];
        System.arraycopy(corners, 0, posits, 0, n);
        long currentOffset = 0L;
        if (data == null) {
            currentOffset = this.randomAccessFile.getFilePointer();
        }
        int outputOffset = 0;
        boolean hasNoOverlap = true;
        do {
            int mx;
            boolean validSegment;
            boolean bl = validSegment = posits[mx = newDims.length - 1] + lengths[mx] >= 0 && posits[mx] < newDims[mx];
            if (validSegment) {
                for (int i = 0; i < mx; ++i) {
                    if (posits[i] >= 0 && posits[i] < newDims[i]) continue;
                    validSegment = false;
                    break;
                }
            }
            if (validSegment) {
                hasNoOverlap = false;
                if (data != null) {
                    this.fillMemData(data, posits, segment, o, outputOffset, 0, segmentStep);
                } else {
                    long offset = StandardImageTiler.getOffset(newDims, posits) * (long)baseLength;
                    int actualLen = segment;
                    long actualOffset = offset;
                    int actualOutput = outputOffset;
                    if (posits[mx] < 0) {
                        actualOffset -= (long)posits[mx] * (long)baseLength;
                        actualOutput -= posits[mx];
                        actualLen += posits[mx];
                    }
                    if (posits[mx] + segment > newDims[mx]) {
                        actualLen -= posits[mx] + segment - newDims[mx];
                    }
                    this.fillFileData(o, actualOffset, actualOutput, actualLen, segmentStep);
                }
            }
            if (isStreaming) continue;
            outputOffset += segment;
        } while (StandardImageTiler.incrementPosition(corners, posits, lengths, steps));
        if (data == null) {
            this.randomAccessFile.seek(currentOffset);
        }
        if (isStreaming && hasNoOverlap) {
            throw new IOException("Sub-image not within image");
        }
    }

    @Override
    public Object getCompleteImage() throws IOException {
        if (this.randomAccessFile == null) {
            throw new IOException("Attempt to read from null file");
        }
        long currentOffset = this.randomAccessFile.getFilePointer();
        Object o = ArrayFuncs.newInstance(this.base, this.dims);
        this.randomAccessFile.seek(this.fileOffset);
        this.randomAccessFile.readImage(o);
        this.randomAccessFile.seek(currentOffset);
        return o;
    }

    protected abstract Object getMemoryImage();

    @Override
    public Object getTile(int[] corners, int[] lengths) throws IOException {
        int[] steps = new int[corners.length];
        Arrays.fill(steps, 1);
        return this.getTile(corners, lengths, steps);
    }

    @Override
    public Object getTile(int[] corners, int[] lengths, int[] steps) throws IOException {
        if (corners.length != this.dims.length || lengths.length != this.dims.length) {
            throw new IOException("Inconsistent sub-image request");
        }
        int arraySize = 1;
        for (int i = 0; i < this.dims.length; ++i) {
            if (corners[i] < 0 || lengths[i] < 0 || corners[i] + lengths[i] > this.dims[i]) {
                throw new IOException("Sub-image not within image");
            }
            if (steps[i] < 1) {
                throw new IOException("Step value cannot be less than 1.");
            }
            arraySize *= lengths[i];
        }
        Object outArray = ArrayFuncs.newInstance(this.base, arraySize);
        this.getTile(outArray, corners, lengths, steps);
        return outArray;
    }

    @Override
    public void getTile(Object output, int[] corners, int[] lengths) throws IOException {
        int[] steps = new int[corners.length];
        Arrays.fill(steps, 1);
        this.getTile(output, corners, lengths, steps);
    }

    @Override
    public void getTile(Object output, int[] corners, int[] lengths, int[] steps) throws IOException {
        Object data = this.getMemoryImage();
        if (data == null && this.randomAccessFile == null) {
            throw new IOException("No data source for tile subset");
        }
        this.fillTile(data, output, this.dims, corners, lengths, steps);
    }
}

