/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image;

import java.io.IOException;
import java.util.Arrays;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.image.ImageTiler;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;

public class StreamingTileImageData
extends ImageData {
    private final int[] corners;
    private final int[] lengths;
    private final int[] steps;
    private final ImageTiler imageTiler;

    public StreamingTileImageData(Header header, ImageTiler tiler, int[] corners, int[] lengths, int[] steps) throws FitsException {
        super(header);
        if (ArrayFuncs.isEmpty(corners) || ArrayFuncs.isEmpty(lengths)) {
            throw new IllegalArgumentException("Cannot tile out with empty corners or lengths.  Use ImageData if no tiling is desired.");
        }
        if (ArrayFuncs.isEmpty(steps)) {
            this.steps = new int[corners.length];
            Arrays.fill(this.steps, 1);
        } else {
            if (Arrays.stream(steps).anyMatch(i -> i < 1)) {
                throw new IllegalArgumentException("Negative or zero step values not supported.");
            }
            this.steps = steps;
        }
        this.imageTiler = tiler;
        this.corners = corners;
        this.lengths = lengths;
    }

    public int[] getSteps() {
        return Arrays.copyOf(this.steps, this.steps.length);
    }

    @Override
    public void write(ArrayDataOutput o) throws FitsException {
        try {
            ImageTiler tiler = this.imageTiler;
            if (tiler == null || this.getTrueSize() == 0L) {
                super.write(o);
            } else {
                tiler.getTile(o, this.corners, this.lengths, this.steps);
                FitsUtil.pad(o, this.getTrueSize());
            }
        }
        catch (IOException ioException) {
            throw new FitsException(ioException.getMessage(), ioException);
        }
    }
}

