/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.fits.compression.algorithm.quant.QuantizeOption;
import nom.tam.fits.compression.algorithm.rice.RiceCompressOption;
import nom.tam.fits.compression.provider.CompressorProvider;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.Standard;
import nom.tam.image.ImageTiler;
import nom.tam.image.StandardImageTiler;
import nom.tam.image.compression.hdu.CompressedImageHDU;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.type.ElementType;

public class CompressedImageTiler
implements ImageTiler {
    private static final Logger LOGGER = Logger.getLogger(CompressedImageTiler.class.getName());
    static final int DEFAULT_BLOCK_SIZE = 32;
    private final CompressedImageHDU compressedImageHDU;
    private final List<String> columnNames = new ArrayList<String>();

    static boolean incrementPosition(int[] start, int[] current, int[] lengths, int[] steps) {
        for (int i = start.length - 2; i >= 0; --i) {
            if (current[i] - start[i] >= lengths[i] - steps[i]) continue;
            int n = i;
            current[n] = current[n] + steps[i];
            if (start.length - 1 - (i + 1) >= 0) {
                System.arraycopy(start, i + 1, current, i + 1, start.length - 1 - (i + 1));
            }
            return true;
        }
        return false;
    }

    static boolean isValidSegment(int position, int length, int dimension) {
        return position + length >= 0 && position < dimension;
    }

    public CompressedImageTiler(CompressedImageHDU compressedImageHDU) {
        this.compressedImageHDU = compressedImageHDU;
        this.init();
    }

    void init() {
        int columnCount = this.compressedImageHDU.getData().getNCols();
        Header header = this.compressedImageHDU.getHeader();
        for (int index = 0; index < columnCount; ++index) {
            String ttype = header.getStringValue(Standard.TTYPEn.n(index + 1));
            if (ttype == null) continue;
            this.addColumn(ttype.trim());
        }
    }

    void addColumn(String column) {
        this.columnNames.add(column);
    }

    void getTile(ArrayDataOutput output, int[] imageDimensions, int[] corners, int[] lengths, int[] steps) throws IOException, FitsException {
        int n = imageDimensions.length;
        int[] posits = new int[n];
        int segmentStepValue = steps[n - 1];
        int segment = lengths[n - 1];
        Class<?> base = this.getBaseType().primitiveClass();
        System.arraycopy(corners, 0, posits, 0, n);
        int[] tileDimensions = ArrayFuncs.reverseIndices(this.getTileDimensions());
        do {
            int tileReadLength;
            int mx;
            boolean validSegment;
            if (!(validSegment = CompressedImageTiler.isValidSegment(posits[mx = imageDimensions.length - 1], lengths[mx], imageDimensions[mx]))) continue;
            int stepOffset = 0;
            int[] tileRowPositions = new int[n];
            System.arraycopy(posits, 0, tileRowPositions, 0, n);
            for (int pixelsRead = 0; pixelsRead < segment; pixelsRead += tileReadLength) {
                int[] tileOffsets = this.getTileOffsets(tileRowPositions, tileDimensions);
                final Object tileData = this.getDecompressedTileData(tileRowPositions, tileDimensions);
                StandardImageTiler standardImageTiler = new StandardImageTiler(null, -1L, tileDimensions, base){

                    @Override
                    protected Object getMemoryImage() {
                        return tileData;
                    }
                };
                int remaining = segment - pixelsRead;
                int n2 = mx;
                tileOffsets[n2] = tileOffsets[n2] + stepOffset;
                int segmentLength = Math.min(segment, tileDimensions[mx] - tileOffsets[mx]);
                tileReadLength = Math.max(1, Math.min(remaining, segmentLength));
                int[] tileReadLengths = new int[tileDimensions.length];
                Arrays.fill(tileReadLengths, 1);
                tileReadLengths[tileReadLengths.length - 1] = tileReadLength;
                int[] tileSteps = new int[tileDimensions.length];
                Arrays.fill(tileSteps, 1);
                tileSteps[tileSteps.length - 1] = segmentStepValue;
                standardImageTiler.getTile(output, tileOffsets, tileReadLengths, tileSteps);
                int unreadSteps = tileReadLength % segmentStepValue;
                stepOffset = unreadSteps > 0 ? segmentStepValue - unreadSteps : 0;
                tileRowPositions[mx] = tileRowPositions[mx] + tileReadLength;
            }
        } while (CompressedImageTiler.incrementPosition(corners, posits, lengths, steps));
        output.flush();
    }

    Object getDecompressedTileData(int[] positions, int[] tileDimensions) throws FitsException {
        Object decompressedArray;
        int compressedDataColumnIndex = this.columnNames.indexOf("COMPRESSED_DATA");
        int uncompressedDataColumnIndex = this.columnNames.indexOf("UNCOMPRESSED_DATA");
        int gZipCompressedDataColumnIndex = this.columnNames.indexOf("GZIP_COMPRESSED_DATA");
        Object[] row = this.getRow(positions, tileDimensions);
        byte[] compressedRowData = (byte[])row[compressedDataColumnIndex];
        if (compressedRowData.length > 0) {
            decompressedArray = this.decompressRow(compressedDataColumnIndex, row);
        } else if (gZipCompressedDataColumnIndex >= 0) {
            decompressedArray = this.decompressRow(gZipCompressedDataColumnIndex, row);
        } else if (uncompressedDataColumnIndex >= 0) {
            decompressedArray = row[uncompressedDataColumnIndex];
        } else {
            throw new FitsException("Nothing in row to read: (" + Arrays.deepToString(row) + ").");
        }
        return ArrayFuncs.curl(decompressedArray, tileDimensions);
    }

    int[] getTileIndexes(int[] pixelPositions, int[] tileDimensions) {
        int[] tileIndexes = new int[pixelPositions.length];
        for (int i = 0; i < pixelPositions.length; ++i) {
            tileIndexes[i] = pixelPositions[i] / tileDimensions[i];
        }
        return tileIndexes;
    }

    Object decompressRow(int columnIndex, Object[] row) throws FitsException {
        byte[] compressedRowData = (byte[])row[columnIndex];
        ByteBuffer compressed = ByteBuffer.wrap(compressedRowData);
        compressed.rewind();
        try {
            Buffer tileBuffer = this.decompressIntoBuffer(row, compressed);
            if (this.hasData(tileBuffer)) {
                return tileBuffer.array();
            }
            throw new FitsException("No tile available at column " + columnIndex + ": (" + Arrays.deepToString(row) + ")");
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.severe("Unable to decompress row data from column " + columnIndex + ": (" + Arrays.deepToString(row) + ")");
            throw new FitsException(illegalStateException.getMessage(), illegalStateException);
        }
    }

    Buffer decompressIntoBuffer(Object[] row, ByteBuffer compressed) {
        ElementType<Buffer> bufferElementType = this.getBaseType();
        Buffer tileBuffer = bufferElementType.newBuffer(this.getTileSize());
        tileBuffer.rewind();
        ICompressorControl compressorControl = this.getCompressorControl(this.getBaseType());
        ICompressOption option = this.initCompressionOption(compressorControl.option(), bufferElementType.size());
        this.initRowOption(option, row);
        compressorControl.decompress(compressed, tileBuffer, option);
        tileBuffer.rewind();
        return tileBuffer;
    }

    ICompressorControl getCompressorControl(ElementType<? extends Buffer> elementType) {
        return CompressorProvider.findCompressorControl(this.getQuantizAlgorithmName(), this.getCompressionAlgorithmName(), elementType.primitiveClass());
    }

    ICompressOption initCompressionOption(ICompressOption option, int bytePix) {
        if (option instanceof RiceCompressOption) {
            ((RiceCompressOption)option).setBlockSize(this.getBlockSize());
            ((RiceCompressOption)option).setBytePix(bytePix);
        } else if (option instanceof QuantizeOption) {
            this.initCompressionOption(((QuantizeOption)option).getCompressOption(), bytePix);
        }
        option.setTileHeight(this.getTileHeight()).setTileWidth(this.getTileWidth());
        return option;
    }

    ElementType<Buffer> getBaseType() {
        int zBitPix = this.getZBitPix();
        ElementType<Buffer> bufferElementType = ElementType.forBitpix(zBitPix);
        if (bufferElementType == null) {
            return ElementType.forNearestBitpix(zBitPix);
        }
        return bufferElementType;
    }

    boolean hasData(Buffer buffer) {
        return buffer.hasArray();
    }

    Object[] getRow(int[] positions, int[] tileDimensions) throws FitsException {
        int[] tileIndexes = this.getTileIndexes(ArrayFuncs.reverseIndices(positions), ArrayFuncs.reverseIndices(tileDimensions));
        int rowNumber = this.getRowNumber(tileIndexes);
        return this.compressedImageHDU.getRow(rowNumber);
    }

    int getRowNumber(int[] tileIndexes) throws FitsException {
        int offset = 0;
        int[] tableDimensions = this.getTableDimensions();
        for (int i = 0; i < tableDimensions.length; ++i) {
            if (i > 0) {
                offset += tileIndexes[i] * tableDimensions[i - 1];
                continue;
            }
            offset += tileIndexes[i];
        }
        return offset;
    }

    int[] getTileOffsets(int[] corners, int[] tileDimensions) {
        int numberOfDimensions = this.getNumberOfDimensions();
        int[] tileOffsets = new int[numberOfDimensions];
        for (int i = 0; i < numberOfDimensions; ++i) {
            int pixelOffset = corners[i];
            int tileDimension = tileDimensions[i];
            if (pixelOffset % tileDimension == 0 || tileDimension == 1) {
                tileOffsets[i] = 0;
                continue;
            }
            int currentTile = corners[i] / tileDimensions[i];
            int lastTile = Math.max(0, currentTile - 1);
            int pixelsToEndOfLastTile = lastTile * tileDimension + tileDimension;
            int tileOffset = pixelOffset < tileDimension ? pixelOffset : pixelOffset - pixelsToEndOfLastTile;
            tileOffsets[i] = tileOffset;
        }
        return tileOffsets;
    }

    @Override
    public Object getCompleteImage() throws IOException {
        try {
            return ((ImageData)this.compressedImageHDU.asImageHDU().getData()).getData();
        }
        catch (FitsException fitsException) {
            throw new IOException(fitsException.getMessage(), fitsException);
        }
    }

    @Override
    public void getTile(Object output, int[] corners, int[] lengths) throws IOException {
        int[] steps = new int[lengths.length];
        Arrays.fill(steps, 1);
        this.getTile(output, corners, lengths, steps);
    }

    @Override
    public void getTile(Object output, int[] corners, int[] lengths, int[] steps) throws IOException {
        int[] imageDimensions = this.getImageDimensions();
        if (corners.length != imageDimensions.length || lengths.length != imageDimensions.length || steps.length != imageDimensions.length) {
            throw new IOException("Inconsistent sub-image request");
        }
        if (output == null) {
            throw new IOException("Attempt to write to null data output");
        }
        for (int i = 0; i < imageDimensions.length; ++i) {
            if (corners[i] >= 0 && lengths[i] >= 0 && corners[i] + lengths[i] <= imageDimensions[i]) continue;
            throw new IOException("Sub-image not within image");
        }
        if (!(output instanceof ArrayDataOutput)) {
            throw new UnsupportedOperationException("Only streaming to ArrayDataOutput is supported.  See getTile(ArrayDataOutput, int[], int[], int[].");
        }
        try {
            this.getTile((ArrayDataOutput)output, imageDimensions, corners, lengths, steps);
        }
        catch (FitsException fitsException) {
            throw new IOException(fitsException.getMessage(), fitsException);
        }
    }

    @Override
    public Object getTile(int[] corners, int[] lengths) throws IOException {
        throw new UnsupportedOperationException("Only streaming to ArrayDataOutput is supported.  See getTile(ArrayDataOutput, int[], int[], int[].");
    }

    void initRowOption(ICompressOption option, Object[] row) {
        int zScaleColumnIndex = this.columnNames.indexOf("ZSCALE");
        int zZeroColumnIndex = this.columnNames.indexOf("ZZERO");
        if (option instanceof QuantizeOption) {
            double bScale = zScaleColumnIndex >= 0 ? ((double[])row[zScaleColumnIndex])[0] : Double.NaN;
            ((QuantizeOption)option).setBScale(bScale);
            double bZero = zZeroColumnIndex >= 0 ? ((double[])row[zZeroColumnIndex])[0] : Double.NaN;
            ((QuantizeOption)option).setBZero(bZero);
        }
    }

    Header getHeader() {
        return this.compressedImageHDU.getHeader();
    }

    private String getQuantizAlgorithmName() {
        return this.getHeader().getStringValue(Compression.ZQUANTIZ);
    }

    private String getCompressionAlgorithmName() {
        return this.getHeader().getStringValue(Compression.ZCMPTYPE);
    }

    int getBlockSize() {
        int axesLength = this.getNumberOfDimensions();
        for (int i = 0; i < axesLength; ++i) {
            int nextAxis = i + 1;
            String zNameValue = this.getHeader().getStringValue(Compression.ZNAMEn.n(nextAxis));
            if (!"BLOCKSIZE".equals(zNameValue)) continue;
            return this.getHeader().getIntValue(Compression.ZVALn.n(nextAxis));
        }
        return 32;
    }

    int getNumberOfDimensions() {
        return this.getHeader().getIntValue(Compression.ZNAXIS);
    }

    int getZBitPix() {
        return this.getHeader().getIntValue(Compression.ZBITPIX);
    }

    int getImageAxisLength(int axis) {
        return this.getHeader().getIntValue(Compression.ZNAXISn.n(axis));
    }

    int[] getTableDimensions() throws FitsException {
        int n = this.getNumberOfDimensions();
        int[] tableDimensions = new int[n];
        for (int i = 0; i < n; ++i) {
            tableDimensions[i] = Double.valueOf(Math.ceil(Integer.valueOf(this.getImageAxisLength(i + 1)).doubleValue() / (double)this.getTileDimensionLength(i + 1))).intValue();
        }
        return tableDimensions;
    }

    int[] getImageDimensions() {
        int n = this.getNumberOfDimensions();
        int[] imageDimensions = new int[n];
        Header header = this.getHeader();
        for (int i = 0; i < n; ++i) {
            imageDimensions[n - i - 1] = header.getIntValue(Compression.ZNAXISn.n(i + 1));
        }
        return imageDimensions;
    }

    int getTileHeight() {
        return this.getHeader().getIntValue(Compression.ZTILEn.n(2), 1);
    }

    int getTileWidth() {
        return this.getHeader().getIntValue(Compression.ZTILEn.n(1), this.getHeader().getIntValue(Compression.ZNAXISn.n(1)));
    }

    int[] getTileDimensions() throws FitsException {
        int totalDimensions = this.getNumberOfDimensions();
        int[] tileDimensions = new int[totalDimensions];
        for (int n = 0; n < totalDimensions; ++n) {
            tileDimensions[n] = this.getTileDimensionLength(n + 1);
        }
        return tileDimensions;
    }

    int getTileDimensionLength(int dimension) throws FitsException {
        int totalDimensions = this.getNumberOfDimensions();
        if (dimension < 1) {
            throw new FitsException("Dimensions are 1-based (got " + dimension + ").");
        }
        if (dimension > totalDimensions) {
            throw new FitsException("Trying to get tile for dimension " + dimension + " where there are only " + totalDimensions + " dimensions in total.");
        }
        int dimensionLength = dimension == 1 ? this.getHeader().getIntValue(Compression.ZTILEn.n(1), this.getHeader().getIntValue(Compression.ZNAXISn.n(1))) : this.getHeader().getIntValue(Compression.ZTILEn.n(dimension), 1);
        return dimensionLength;
    }

    int getTileSize() {
        int n = this.getNumberOfDimensions();
        int tileSize = this.getHeader().getIntValue(Compression.ZTILEn.n(1), this.getHeader().getIntValue(Compression.ZNAXISn.n(1)));
        int i = 2;
        while (i <= n) {
            tileSize *= this.getHeader().getIntValue(Compression.ZTILEn.n(i++), 1);
        }
        return tileSize;
    }
}

