/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.bintable;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.image.compression.bintable.BinaryTableTile;
import nom.tam.image.compression.bintable.BinaryTableTileDescription;
import nom.tam.image.compression.hdu.CompressedTableData;
import nom.tam.util.ByteBufferOutputStream;
import nom.tam.util.ColumnTable;
import nom.tam.util.FitsOutputStream;
import nom.tam.util.type.ElementType;

public class BinaryTableTileCompressor
extends BinaryTableTile {
    private static final double NORMAL_OVERHEAD = 1.2;
    private static final int MINIMUM_EXTRA_SPACE = 1024;
    private final CompressedTableData compressed;
    private BinaryTable orig;
    private byte[][] compressedBytes;
    private long[][] cdesc;
    private Object udesc;

    public BinaryTableTileCompressor(CompressedTableData compressedTable, ColumnTable<?> columnTable, BinaryTableTileDescription description) {
        super(columnTable, description);
        this.compressed = compressedTable;
    }

    public BinaryTableTileCompressor(CompressedTableData compressedTable, BinaryTable table, BinaryTableTileDescription description) {
        this(compressedTable, (ColumnTable<?>)table.getData(), description);
        this.orig = table;
    }

    private int getCushion(int size, double factor) throws IllegalStateException {
        long lsize = (long)Math.ceil((double)size * factor + 1024.0);
        return lsize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lsize;
    }

    private byte[] getCompressedBytes(ByteBuffer buffer, ElementType<?> t, ICompressorControl compressor) {
        buffer.flip();
        int need = this.getCushion(this.getUncompressedSizeInBytes(), 1.2);
        ByteBuffer cbuf = ByteBuffer.allocateDirect(need);
        Object tb = t.asTypedBuffer(buffer);
        if (!compressor.compress((Buffer)tb, cbuf, null)) {
            throw new IllegalStateException("Compression error");
        }
        cbuf.flip();
        byte[] cdata = new byte[cbuf.limit()];
        cbuf.get(cdata);
        buffer.clear();
        return cdata;
    }

    private void compressRegular() throws IOException {
        this.compressedBytes = new byte[1][];
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.getUncompressedSizeInBytes());
        try (FitsOutputStream os = new FitsOutputStream(new ByteBufferOutputStream(buffer));){
            this.data.write(os, this.rowStart, this.rowEnd, this.column);
        }
        this.compressedBytes[0] = this.getCompressedBytes(buffer, this.type, this.getCompressorControl());
    }

    private void compressVariable() throws IOException {
        int nRows = this.rowEnd - this.rowStart;
        boolean longPointers = this.orig.getDescriptor(this.column).hasLongPointers();
        long max = 0L;
        this.udesc = longPointers ? new long[nRows][] : (long[][])new int[nRows][2];
        for (int r = 0; r < nRows; ++r) {
            Object desc = this.data.getElement(this.rowStart + r, this.column);
            long n = 0L;
            if (longPointers) {
                ((long[][])this.udesc)[r] = (long[])desc;
                n = ((long[])desc)[0];
            } else {
                ((int[][])this.udesc)[r] = (int[])desc;
                n = ((int[])desc)[0];
            }
            if (n <= max) continue;
            max = n;
        }
        if ((max *= (long)this.type.size()) > Integer.MAX_VALUE) {
            throw new IllegalStateException("Uncompressed data too large for Java arrays: max=" + max);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)max);
        ElementType dataType = ElementType.forClass(this.orig.getDescriptor(this.column).getElementClass());
        ICompressorControl compressor = this.getCompressorControl(dataType.primitiveClass());
        this.compressedBytes = new byte[nRows][];
        for (int r = 0; r < nRows; ++r) {
            try (FitsOutputStream os = new FitsOutputStream(new ByteBufferOutputStream(buffer));){
                Object entry = this.orig.get(this.rowStart + r, this.column);
                os.writeArray(entry);
            }
            this.compressedBytes[r] = this.getCompressedBytes(buffer, dataType, compressor);
        }
    }

    @Override
    public void run() {
        try {
            if (this.orig != null && this.orig.getDescriptor(this.column).isVariableSize()) {
                this.compressVariable();
            } else {
                this.compressRegular();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setCompressedData(byte[] data) {
        CompressedTableData compressedTableData = this.compressed;
        synchronized (compressedTableData) {
            Object p = ((ColumnTable)this.compressed.getData()).getElement(this.getTileIndex(), this.column);
            if (p instanceof long[]) {
                Arrays.fill((long[])p, 0L);
            } else {
                Arrays.fill((int[])p, 0);
            }
            ((ColumnTable)this.compressed.getData()).setElement(this.getTileIndex(), this.column, p);
            this.compressed.setElement(this.getTileIndex(), this.column, data);
            return ((ColumnTable)this.compressed.getData()).getElement(this.getTileIndex(), this.column);
        }
    }

    private void setRegularData() {
        this.setCompressedData(this.compressedBytes[0]);
        this.compressedBytes = null;
    }

    private void setVariableData() throws IOException {
        int nRows = this.compressedBytes.length;
        boolean longPointers = this.orig.getDescriptor(this.column).hasLongPointers();
        this.cdesc = new long[nRows][2];
        ByteBuffer buffer = ByteBuffer.allocateDirect(nRows * 2 * (64 + (longPointers ? 8 : 4)));
        for (int r = 0; r < nRows; ++r) {
            Object cp = this.setCompressedData(this.compressedBytes[r]);
            if (cp instanceof long[]) {
                this.cdesc[r] = (long[])cp;
                continue;
            }
            this.cdesc[r][0] = ((int[])cp)[0];
            this.cdesc[r][1] = ((int[])cp)[1];
        }
        try (FitsOutputStream os = new FitsOutputStream(new ByteBufferOutputStream(buffer));){
            os.writeArray(this.udesc);
            os.writeArray(this.cdesc);
        }
        this.setCompressedData(this.getCompressedBytes(buffer, ElementType.BYTE, this.getGZipCompressorControl()));
        this.compressedBytes = null;
        this.cdesc = null;
        this.udesc = null;
    }

    @Override
    public void waitForResult() {
        super.waitForResult();
        if (this.orig != null && this.orig.getDescriptor(this.column).isVariableSize()) {
            try {
                this.setVariableData();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        } else {
            this.setRegularData();
        }
    }
}

