/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.bintable;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.FitsException;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.image.compression.bintable.BinaryTableTile;
import nom.tam.image.compression.bintable.BinaryTableTileDescription;
import nom.tam.image.compression.hdu.CompressedTableData;
import nom.tam.image.compression.hdu.CompressedTableHDU;
import nom.tam.util.ByteBufferInputStream;
import nom.tam.util.ColumnTable;
import nom.tam.util.FitsInputStream;
import nom.tam.util.type.ElementType;

public class BinaryTableTileDecompressor
extends BinaryTableTile {
    private BinaryTable orig;
    private final CompressedTableData compressed;
    private int targetColumn;

    public BinaryTableTileDecompressor(CompressedTableData compressedTable, ColumnTable<?> columnTable, BinaryTableTileDescription description) throws FitsException {
        super(columnTable, description);
        this.targetColumn = this.column;
        this.compressed = compressedTable;
    }

    public BinaryTableTileDecompressor(CompressedTableData compressedTable, BinaryTable table, BinaryTableTileDescription description) throws FitsException {
        this(compressedTable, (ColumnTable<?>)table.getData(), description);
        this.orig = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompressVariable() throws IOException {
        int nRows = this.rowEnd - this.rowStart;
        boolean longPointers = this.orig.getDescriptor(this.targetColumn).hasLongPointers();
        ByteBuffer pdata = ByteBuffer.wrap((byte[])this.compressed.getElement(this.getTileIndex(), this.column));
        ByteBuffer pointers = ByteBuffer.allocateDirect(2 * nRows * (8 + (longPointers ? 8 : 4)));
        this.getGZipCompressorControl().decompress(pdata, pointers, null);
        pointers.flip();
        long[][] cdesc = new long[nRows][2];
        Object p = longPointers ? new long[nRows][2] : (Object)new int[nRows][2];
        try (FitsInputStream ips = new FitsInputStream(new ByteBufferInputStream(pointers));){
            if (CompressedTableHDU.hasOldStandardVLAIndexing()) {
                ips.readLArray(cdesc);
                ips.readLArray(p);
            } else {
                ips.readLArray(p);
                ips.readLArray(cdesc);
            }
        }
        ElementType dataType = ElementType.forClass(this.orig.getDescriptor(this.column).getElementClass());
        ICompressorControl compressor = this.getCompressorControl(dataType.primitiveClass());
        Object bak = ((ColumnTable)this.compressed.getData()).getElement(this.getTileIndex(), this.column);
        try {
            for (int r = 0; r < nRows; ++r) {
                Object[] objectArray;
                long doffset;
                long csize = cdesc[r][0];
                long coffset = cdesc[r][1];
                if (csize < 0L || csize > Integer.MAX_VALUE || coffset < 0L || coffset > Integer.MAX_VALUE) {
                    throw new FitsException("Illegal or unsupported compressed heap pointer (offset=" + coffset + ", size=" + csize);
                }
                long dcount = longPointers ? p[r][0] : (long)((int[][])p)[r][0];
                long l = doffset = longPointers ? p[r][1] : (long)((int[][])p)[r][1];
                if (dcount < 0L || dcount > Integer.MAX_VALUE || doffset < 0L || doffset > Integer.MAX_VALUE) {
                    throw new FitsException("Illegal or unsupported uncompressed heap pointer (offset=" + doffset + ", size=" + dcount);
                }
                if (bak instanceof long[]) {
                    long[] lArray = new long[2];
                    lArray[0] = csize;
                    objectArray = lArray;
                    lArray[1] = coffset;
                } else {
                    int[] nArray = new int[2];
                    nArray[0] = (int)csize;
                    objectArray = nArray;
                    nArray[1] = (int)coffset;
                }
                Object[] temp = objectArray;
                ((ColumnTable)this.compressed.getData()).setElement(this.getTileIndex(), this.column, temp);
                ByteBuffer zip = ByteBuffer.wrap((byte[])this.compressed.getElement(this.getTileIndex(), this.column));
                Object buf = dataType.newBuffer(dcount);
                compressor.decompress(zip, (Buffer)buf, null);
                ((Buffer)buf).flip();
                this.data.setElement(this.rowStart + r, this.targetColumn, longPointers ? p[r] : (long[])((int[][])p)[r]);
                this.orig.setElement(this.rowStart + r, this.targetColumn, ((Buffer)buf).array());
            }
        }
        finally {
            ((ColumnTable)this.compressed.getData()).setElement(this.getTileIndex(), this.column, bak);
        }
    }

    private void decompressTableTile() throws IOException {
        ByteBuffer zip = ByteBuffer.wrap((byte[])this.compressed.getElement(this.getTileIndex(), this.column));
        ByteBuffer buf = ByteBuffer.allocateDirect(this.getUncompressedSizeInBytes());
        this.getCompressorControl().decompress(zip, (Buffer)this.type.asTypedBuffer(buf), null);
        buf.rewind();
        try (FitsInputStream is = new FitsInputStream(new ByteBufferInputStream(buf));){
            this.data.read(is, this.rowStart, this.rowEnd, this.targetColumn);
        }
    }

    @Override
    public void run() {
        try {
            if (this.orig != null && this.orig.getDescriptor(this.targetColumn).isVariableSize()) {
                this.decompressVariable();
            } else {
                this.decompressTableTile();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public BinaryTableTileDecompressor decompressToColumn(int col) {
        this.targetColumn = col;
        return this;
    }
}

