/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.hdu;

import java.util.Map;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.header.Checksum;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.GenericKey;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.hdu.CompressedImageHDU;
import nom.tam.util.Cursor;

enum CompressedCard {
    MAP_ANY(null){

        @Override
        protected void backupCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
            headerIterator.add(card.copy());
        }

        @Override
        protected void restoreCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
            headerIterator.add(card.copy());
        }
    }
    ,
    MAP_BITPIX(Standard.BITPIX),
    MAP_CHECKSUM(Checksum.CHECKSUM),
    MAP_DATASUM(Checksum.DATASUM),
    MAP_EXTNAME(Standard.EXTNAME){

        @Override
        protected void backupCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
            if (!card.getValue().equals("COMPRESSED_IMAGE")) {
                super.backupCard(card, headerIterator);
            }
        }
    }
    ,
    MAP_GCOUNT(Standard.GCOUNT),
    MAP_NAXIS(Standard.NAXIS),
    MAP_NAXISn(Standard.NAXISn),
    MAP_PCOUNT(Standard.PCOUNT),
    MAP_ZFORMn(Compression.ZFORMn){

        @Override
        protected void backupCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
            String newKey = this.uncompressedHeaderKey().n(GenericKey.getN(card.getKey())).key();
            headerIterator.add(new HeaderCard(newKey, card.getValue(String.class, ""), card.getComment()));
        }

        @Override
        protected void restoreCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
            String newKey = this.compressedHeaderKey().n(GenericKey.getN(card.getKey())).key();
            headerIterator.add(new HeaderCard(newKey, card.getValue(String.class, ""), card.getComment()));
        }
    }
    ,
    MAP_TFORMn(Standard.TFORMn),
    MAP_XTENSION(Standard.XTENSION),
    MAP_ZBITPIX(Compression.ZBITPIX),
    MAP_ZBLANK(Compression.ZBLANK),
    MAP_ZTILELEN(Compression.ZTILELEN),
    MAP_ZCTYPn(Compression.ZCTYPn),
    MAP_ZBLOCKED(Compression.ZBLOCKED),
    MAP_ZCMPTYPE(Compression.ZCMPTYPE),
    MAP_ZDATASUM(Compression.ZDATASUM),
    MAP_ZDITHER0(Compression.ZDITHER0),
    MAP_ZEXTEND(Compression.ZEXTEND),
    MAP_ZGCOUNT(Compression.ZGCOUNT),
    MAP_ZHECKSUM(Compression.ZHECKSUM),
    MAP_ZIMAGE(Compression.ZIMAGE),
    MAP_ZTABLE(Compression.ZTABLE),
    MAP_ZNAMEn(Compression.ZNAMEn),
    MAP_ZNAXIS(Compression.ZNAXIS),
    MAP_THEAP(Standard.THEAP),
    MAP_ZNAXISn(Compression.ZNAXISn){

        @Override
        protected void backupCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
            String newKey = this.uncompressedHeaderKey().n(GenericKey.getN(card.getKey())).key();
            headerIterator.add(new HeaderCard(newKey, card.getValue(Integer.class, 0), card.getComment()));
        }

        @Override
        protected void restoreCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
            String newKey = this.compressedHeaderKey().n(GenericKey.getN(card.getKey())).key();
            headerIterator.add(new HeaderCard(newKey, card.getValue(Integer.class, 0), card.getComment()));
        }
    }
    ,
    MAP_ZPCOUNT(Compression.ZPCOUNT),
    MAP_ZTHEAP(Compression.ZTHEAP),
    MAP_ZQUANTIZ(Compression.ZQUANTIZ),
    MAP_ZSIMPLE(Compression.ZSIMPLE),
    MAP_ZTENSION(Compression.ZTENSION),
    MAP_ZTILEn(Compression.ZTILEn),
    MAP_ZVALn(Compression.ZVALn);

    private final IFitsHeader compressedHeaderKey;
    private final IFitsHeader uncompressedHeaderKey;

    public static void backup(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
        CompressedCard mapping = CompressedCard.selectMapping(CompressedImageHDU.UNCOMPRESSED_HEADER_MAPPING, card);
        mapping.backupCard(card, headerIterator);
    }

    public static void restore(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
        CompressedCard mapping = CompressedCard.selectMapping(CompressedImageHDU.COMPRESSED_HEADER_MAPPING, card);
        mapping.restoreCard(card, headerIterator);
    }

    protected static CompressedCard selectMapping(Map<IFitsHeader, CompressedCard> mappings, HeaderCard card) {
        CompressedCard mapping;
        IFitsHeader key = GenericKey.lookup(card.getKey());
        if (key != null && (mapping = mappings.get(key)) != null) {
            return mapping;
        }
        return MAP_ANY;
    }

    private CompressedCard(IFitsHeader header) {
        this.compressedHeaderKey = header;
        this.uncompressedHeaderKey = header instanceof Compression ? ((Compression)this.compressedHeaderKey).getUncompressedKey() : null;
        CompressedImageHDU.UNCOMPRESSED_HEADER_MAPPING.put(header, this);
        if (this.uncompressedHeaderKey != null) {
            CompressedImageHDU.COMPRESSED_HEADER_MAPPING.put(this.uncompressedHeaderKey, this);
        }
    }

    private void addHeaderCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator, IFitsHeader targetKey) throws HeaderCardException {
        if (targetKey != null) {
            if (targetKey.valueType() == IFitsHeader.VALUE.INTEGER) {
                headerIterator.add(new HeaderCard(targetKey.key(), card.getValue(Integer.class, 0), card.getComment()));
            } else if (targetKey.valueType() == IFitsHeader.VALUE.STRING) {
                headerIterator.add(new HeaderCard(targetKey.key(), card.getValue(), card.getComment()));
            } else if (targetKey.valueType() == IFitsHeader.VALUE.LOGICAL) {
                headerIterator.add(new HeaderCard(targetKey.key(), card.getValue(Boolean.class, false), card.getComment()));
            }
        }
    }

    protected void backupCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
        IFitsHeader uncompressedKey = this.uncompressedHeaderKey;
        this.addHeaderCard(card, headerIterator, uncompressedKey);
    }

    protected IFitsHeader compressedHeaderKey() {
        return this.compressedHeaderKey;
    }

    protected void restoreCard(HeaderCard card, Cursor<String, HeaderCard> headerIterator) throws HeaderCardException {
        this.addHeaderCard(card, headerIterator, this.compressedHeaderKey);
    }

    protected IFitsHeader uncompressedHeaderKey() {
        return this.uncompressedHeaderKey;
    }
}

