/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.hdu;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.GenericKey;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.CompressedImageTiler;
import nom.tam.image.compression.hdu.CompressedCard;
import nom.tam.image.compression.hdu.CompressedImageData;
import nom.tam.util.ByteBufferInputStream;
import nom.tam.util.ByteBufferOutputStream;
import nom.tam.util.Cursor;
import nom.tam.util.FitsInputStream;
import nom.tam.util.FitsOutputStream;

public class CompressedImageHDU
extends BinaryTableHDU {
    public static final int MAX_NAXIS_ALLOWED = 999;
    private static final List<IFitsHeader> TABLE_COLUMN_KEYS = Arrays.asList(CompressedImageHDU.binaryTableColumnKeyStems());
    static final Map<IFitsHeader, CompressedCard> COMPRESSED_HEADER_MAPPING = new HashMap<IFitsHeader, CompressedCard>();
    static final Map<IFitsHeader, CompressedCard> UNCOMPRESSED_HEADER_MAPPING = new HashMap<IFitsHeader, CompressedCard>();

    public static CompressedImageHDU fromImageHDU(ImageHDU imageHDU, int ... tileAxis) throws FitsException {
        Header header = new Header();
        CompressedImageData compressedData = new CompressedImageData();
        int[] size = imageHDU.getAxes();
        int[] tileSize = new int[size.length];
        compressedData.setAxis(size);
        int nm1 = size.length - 1;
        Arrays.fill(tileSize, 1);
        tileSize[nm1] = size[nm1];
        int n = Math.min(size.length, tileAxis.length);
        for (int i = 0; i < n; ++i) {
            if (tileAxis[i] <= 0) continue;
            tileSize[nm1 - i] = Math.min(tileAxis[i], size[nm1 - i]);
        }
        compressedData.setTileSize(tileSize);
        compressedData.fillHeader(header);
        Cursor<String, HeaderCard> iterator = header.iterator();
        Cursor<String, HeaderCard> imageIterator = imageHDU.getHeader().iterator();
        while (imageIterator.hasNext()) {
            HeaderCard card = (HeaderCard)imageIterator.next();
            CompressedCard.restore(card, iterator);
        }
        CompressedImageHDU compressedImageHDU = new CompressedImageHDU(header, compressedData);
        compressedData.prepareUncompressedData(((ImageData)imageHDU.getData()).getData(), header);
        return compressedImageHDU;
    }

    @Deprecated
    public static boolean isHeader(Header hdr) {
        return hdr.getBooleanValue(Compression.ZIMAGE, false);
    }

    @Deprecated
    public static CompressedImageData manufactureData(Header hdr) throws FitsException {
        return new CompressedImageData(hdr);
    }

    public CompressedImageHDU(Header hdr, CompressedImageData datum) {
        super(hdr, datum);
    }

    public ImageHDU asImageHDU() throws FitsException {
        Header header = this.getImageHeader();
        ImageData data = ImageHDU.manufactureData(header);
        ImageHDU imageHDU = new ImageHDU(header, data);
        data.setBuffer(this.getUncompressedData());
        return imageHDU;
    }

    public ImageHDU getTileHDU(int[] corners, int[] lengths) throws IOException, FitsException, IllegalArgumentException {
        Header h = this.getImageHeader();
        int dim = h.getIntValue(Standard.NAXIS);
        if (corners.length != lengths.length || corners.length != dim) {
            throw new IllegalArgumentException("arguments for mismatched dimensions");
        }
        for (int i = 0; i < corners.length; ++i) {
            int naxis = h.getIntValue(Standard.NAXISn.n(dim - i));
            if (lengths[0] <= 0) {
                throw new IllegalArgumentException("Illegal tile size in dim " + i + ": " + lengths[i]);
            }
            if (corners[i] < 0 || corners[i] + lengths[i] > naxis) {
                throw new IllegalArgumentException("tile out of bounds in dim " + i + ": [" + corners[i] + ":" + (corners[i] + lengths[i]) + "] in " + naxis);
            }
            h.addValue(Standard.NAXISn.n(dim - i), lengths[i]);
            HeaderCard crpix = h.getCard(Standard.CRPIXn.n(dim - i));
            if (crpix != null) {
                crpix.setValue(crpix.getValue(Double.class, Double.NaN) - (double)corners[i]);
            }
            for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                crpix = h.getCard("CRPIX" + (dim - i) + Character.toString(c));
                if (crpix == null) continue;
                crpix.setValue(crpix.getValue(Double.class, Double.NaN) - (double)corners[i]);
            }
        }
        ImageData im = ImageHDU.manufactureData(h);
        ByteBuffer buf = ByteBuffer.wrap(new byte[(int)FitsUtil.addPadding(im.getSize())]);
        try (FitsOutputStream out = new FitsOutputStream(new ByteBufferOutputStream(buf));){
            new CompressedImageTiler(this).getTile(out, corners, lengths);
            out.close();
        }
        buf.limit(buf.capacity());
        buf.position(0);
        try (FitsInputStream in = new FitsInputStream(new ByteBufferInputStream(buf));){
            im.read(in);
            in.close();
        }
        return new ImageHDU(h, im);
    }

    public int[] getImageAxes() throws FitsException {
        int nAxis = this.myHeader.getIntValue(Compression.ZNAXIS);
        if (nAxis < 0) {
            throw new FitsException("Negative ZNAXIS (or NAXIS) value " + nAxis);
        }
        if (nAxis > 999) {
            throw new FitsException("ZNAXIS/NAXIS value " + nAxis + " too large");
        }
        if (nAxis == 0) {
            return null;
        }
        int[] axes = new int[nAxis];
        for (int i = 1; i <= nAxis; ++i) {
            axes[nAxis - i] = this.myHeader.getIntValue(Compression.ZNAXISn.n(i));
        }
        return axes;
    }

    public Header getImageHeader() throws HeaderCardException {
        Header header = new Header();
        Cursor<String, HeaderCard> imageIterator = header.iterator();
        Cursor<String, HeaderCard> iterator = this.getHeader().iterator();
        while (iterator.hasNext()) {
            HeaderCard card = (HeaderCard)iterator.next();
            if (TABLE_COLUMN_KEYS.contains(GenericKey.lookup(card.getKey()))) continue;
            CompressedCard.backup(card, imageIterator);
        }
        return header;
    }

    public void compress() throws FitsException {
        this.getData().compress(this);
    }

    public CompressedImageHDU forceNoLoss(int x, int y, int width, int heigth) {
        this.getData().forceNoLoss(x, y, width, heigth);
        return this;
    }

    public <T extends ICompressOption> T getCompressOption(Class<T> clazz) {
        return this.getData().getCompressOption(clazz);
    }

    @Override
    public CompressedImageData getData() {
        return (CompressedImageData)super.getData();
    }

    @Deprecated
    public Buffer getUncompressedData() throws FitsException {
        return this.getData().getUncompressedData(this.getHeader());
    }

    @Override
    @Deprecated
    public boolean isHeader() {
        return super.isHeader() && CompressedImageHDU.isHeader(this.myHeader);
    }

    public CompressedImageHDU preserveNulls(String compressionAlgorithm) {
        long nullValue = this.getHeader().getLongValue(Standard.BLANK, Long.MIN_VALUE);
        this.getData().preserveNulls(nullValue, compressionAlgorithm);
        return this;
    }

    public CompressedImageHDU setCompressAlgorithm(String compressAlgorithm) throws FitsException {
        HeaderCard compressAlgorithmCard = HeaderCard.create((IFitsHeader)Compression.ZCMPTYPE, compressAlgorithm);
        this.getData().setCompressAlgorithm(compressAlgorithmCard);
        return this;
    }

    public CompressedImageHDU setQuantAlgorithm(String quantAlgorithm) throws FitsException {
        if (quantAlgorithm != null && !quantAlgorithm.isEmpty()) {
            HeaderCard quantAlgorithmCard = HeaderCard.create((IFitsHeader)Compression.ZQUANTIZ, quantAlgorithm);
            this.getData().setQuantAlgorithm(quantAlgorithmCard);
        } else {
            this.getData().setQuantAlgorithm(null);
        }
        return this;
    }
}

