/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.hdu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.bintable.BinaryTableTile;
import nom.tam.image.compression.bintable.BinaryTableTileCompressor;
import nom.tam.image.compression.bintable.BinaryTableTileDecompressor;
import nom.tam.image.compression.bintable.BinaryTableTileDescription;
import nom.tam.util.ColumnTable;

public class CompressedTableData
extends BinaryTable {
    private static final List<String> ALLOWED_ALGORITHMS = Arrays.asList("GZIP_1", "GZIP_2", "RICE_1", "NOCOMPRESS");
    private int rowsPerTile;
    private List<BinaryTableTile> tiles;
    private BinaryTable orig;
    private boolean isPrepped;
    private String[] colAlgorithm;

    public CompressedTableData() {
    }

    public CompressedTableData(Header header) throws FitsException {
        super(header);
        this.rowsPerTile = header.getIntValue(Compression.ZTILELEN, header.getIntValue(Standard.NAXIS2));
        this.setColumnCompressionAlgorithms(header);
    }

    public void compress(Header header) throws FitsException {
        this.discardVLAs();
        for (BinaryTableTile tile : this.tiles) {
            tile.execute(FitsFactory.threadPool());
        }
        for (BinaryTableTile tile : this.tiles) {
            tile.waitForResult();
        }
    }

    @Override
    public synchronized long defragment() throws FitsException {
        if (this.orig != null && this.orig.containsHeap()) {
            return 0L;
        }
        return super.defragment();
    }

    @Override
    public void fillHeader(Header h) throws FitsException {
        super.fillHeader(h);
        h.setNaxis(2, ((ColumnTable)this.getData()).getNRows());
        h.addValue((IFitsHeader)Compression.ZTABLE, true);
        h.addValue((IFitsHeader)Compression.ZTILELEN, this.getRowsPerTile());
        for (int i = 0; i < this.getNCols(); ++i) {
            h.findCard(Compression.ZFORMn.n(i + 1));
            h.addValue(Compression.ZCTYPn.n(i + 1), this.getAlgorithm(i));
        }
        h.deleteKey(Compression.ZIMAGE);
    }

    void prepareUncompressedData(BinaryTable fromTable) throws FitsException {
        this.orig = fromTable;
        this.prepareUncompressedData((ColumnTable<?>)this.orig.getData());
    }

    public void prepareUncompressedData(ColumnTable<?> data) throws FitsException {
        int column;
        this.tiles = new ArrayList<BinaryTableTile>();
        int nrows = data.getNRows();
        int ncols = data.getNCols();
        if (!this.isPrepped) {
            for (column = 0; column < ncols; ++column) {
                this.addColumn(BinaryTable.ColumnDesc.createForVariableSize(Byte.TYPE));
            }
            for (int rowStart = 0; rowStart < nrows; rowStart += this.getRowsPerTile()) {
                this.addRow((Object[])new byte[ncols][0]);
            }
        }
        for (column = 0; column < ncols; ++column) {
            int tileIndex = 0;
            for (int rowStart = 0; rowStart < nrows; rowStart += this.getRowsPerTile()) {
                BinaryTableTileDescription td = BinaryTableTileDescription.tile().rowStart(rowStart).rowEnd(Math.min(nrows, rowStart + this.getRowsPerTile())).column(column).tileIndex(tileIndex + 1).compressionAlgorithm(this.getAlgorithm(column));
                BinaryTableTileCompressor tile = this.orig == null ? new BinaryTableTileCompressor(this, data, td) : new BinaryTableTileCompressor(this, this.orig, td);
                this.tiles.add(tile);
                ++tileIndex;
            }
        }
        this.isPrepped = true;
    }

    protected BinaryTable asBinaryTable(BinaryTable toTable, Header compressedHeader, Header targetHeader) throws FitsException {
        return this.asBinaryTable(toTable, compressedHeader, targetHeader, 0);
    }

    /*
     * WARNING - void declaration
     */
    BinaryTable asBinaryTable(BinaryTable toTable, Header compressedHeader, Header targetHeader, int fromTile) throws FitsException {
        void var10_12;
        int nrows = targetHeader.getIntValue(Standard.NAXIS2);
        int ncols = compressedHeader.getIntValue(Standard.TFIELDS);
        int tileSize = compressedHeader.getIntValue(Compression.ZTILELEN, nrows);
        this.ensureData();
        this.setColumnCompressionAlgorithms(compressedHeader);
        BinaryTable.createColumnDataFor(toTable);
        ArrayList<BinaryTableTileDecompressor> tileList = new ArrayList<BinaryTableTileDecompressor>();
        int tileIndex = fromTile;
        boolean bl = false;
        while (var10_12 < nrows) {
            for (int column = 0; column < ncols; ++column) {
                BinaryTableTileDecompressor tile = new BinaryTableTileDecompressor(this, toTable, BinaryTableTileDescription.tile().rowStart((int)var10_12).rowEnd(Math.min(nrows, (int)(var10_12 + tileSize))).column(column).tileIndex(tileIndex + 1).compressionAlgorithm(this.getAlgorithm(column)));
                tileList.add(tile);
                tile.execute(FitsFactory.threadPool());
            }
            ++tileIndex;
            var10_12 += tileSize;
        }
        for (BinaryTableTile binaryTableTile : tileList) {
            binaryTableTile.waitForResult();
        }
        return toTable;
    }

    /*
     * WARNING - void declaration
     */
    Object getColumnData(int col, int fromTile, int toTile, Header compressedHeader, Header targetHeader) throws FitsException {
        void var14_16;
        if (fromTile < 0 || fromTile >= this.getNRows()) {
            throw new IllegalArgumentException("start tile " + fromTile + " is outof bounds for " + this.getNRows() + " tiles.");
        }
        if (toTile > this.getNRows()) {
            throw new IllegalArgumentException("end tile " + toTile + " is outof bounds for " + this.getNRows() + " tiles.");
        }
        if (toTile <= fromTile) {
            return null;
        }
        this.setColumnCompressionAlgorithms(compressedHeader);
        int nr = targetHeader.getIntValue(Standard.NAXIS2);
        int tileSize = compressedHeader.getIntValue(Compression.ZTILELEN, nr);
        int nRows = (toTile - fromTile) * tileSize;
        if (nRows > nr) {
            nRows = nr;
        }
        BinaryTable.ColumnDesc c = CompressedTableData.getDescriptor(targetHeader, col);
        class UncompressedTable
        extends BinaryTable {
            UncompressedTable() {
            }

            @Override
            public void createTable(int nRows) throws FitsException {
                super.createTable(nRows);
            }
        }
        UncompressedTable data = new UncompressedTable();
        data.addColumn(c);
        data.createTable(nRows);
        ArrayList<BinaryTableTileDecompressor> tileList = new ArrayList<BinaryTableTileDecompressor>();
        String algorithm = compressedHeader.getStringValue(Compression.ZCTYPn.n(col + 1));
        int tileIndex = fromTile;
        boolean bl = false;
        while (var14_16 < nRows) {
            BinaryTableTileDecompressor tile = new BinaryTableTileDecompressor(this, data, BinaryTableTileDescription.tile().rowStart((int)var14_16).rowEnd(Math.min(nr, (int)(var14_16 + tileSize))).column(col).tileIndex(tileIndex + 1).compressionAlgorithm(algorithm));
            tile.decompressToColumn(0);
            tileList.add(tile);
            tile.execute(FitsFactory.threadPool());
            ++tileIndex;
            var14_16 += tileSize;
        }
        for (BinaryTableTile binaryTableTile : tileList) {
            binaryTableTile.waitForResult();
        }
        return data.getColumn(0);
    }

    protected final int getRowsPerTile() {
        return this.rowsPerTile;
    }

    private String getAlgorithm(int column) {
        if (this.colAlgorithm != null && column < this.colAlgorithm.length && this.colAlgorithm[column] != null) {
            return this.colAlgorithm[column];
        }
        return "GZIP_2";
    }

    protected void setColumnCompressionAlgorithms(String[] columnCompressionAlgorithms) {
        for (String algo : columnCompressionAlgorithms) {
            if (ALLOWED_ALGORITHMS.contains(algo.toUpperCase(Locale.US))) continue;
            throw new IllegalArgumentException(algo + " cannot be used to compress tables.");
        }
        this.colAlgorithm = columnCompressionAlgorithms;
    }

    private void setColumnCompressionAlgorithms(Header header) {
        int ncols = header.getIntValue(Standard.TFIELDS);
        this.colAlgorithm = new String[ncols];
        for (int column = 0; column < ncols; ++column) {
            this.colAlgorithm[column] = header.getStringValue(Compression.ZCTYPn.n(column + 1));
        }
    }

    protected CompressedTableData setRowsPerTile(int value) {
        this.rowsPerTile = value;
        return this;
    }
}

