/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.hdu;

import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.hdu.CompressedCard;
import nom.tam.image.compression.hdu.CompressedTableData;
import nom.tam.util.Cursor;
import nom.tam.util.type.ElementType;

public class CompressedTableHDU
extends BinaryTableHDU {
    private static boolean reversedVLAIndices = false;

    public static void useOldStandardVLAIndexing(boolean value) {
        reversedVLAIndices = value;
    }

    public static boolean hasOldStandardVLAIndexing() {
        return reversedVLAIndices;
    }

    public static CompressedTableHDU fromBinaryTableHDU(BinaryTableHDU binaryTableHDU, int tileRows, String ... columnCompressionAlgorithms) throws FitsException {
        Header header = new Header();
        CompressedTableData compressedData = new CompressedTableData();
        compressedData.setColumnCompressionAlgorithms(columnCompressionAlgorithms);
        int rowsPerTile = tileRows > 0 ? tileRows : ((BinaryTable)binaryTableHDU.getData()).getNRows();
        compressedData.setRowsPerTile(rowsPerTile);
        Cursor<String, HeaderCard> headerIterator = header.iterator();
        Cursor<String, HeaderCard> imageIterator = binaryTableHDU.getHeader().iterator();
        while (imageIterator.hasNext()) {
            HeaderCard card = (HeaderCard)imageIterator.next();
            CompressedCard.restore(card, headerIterator);
        }
        CompressedTableHDU compressedImageHDU = new CompressedTableHDU(header, compressedData);
        compressedData.prepareUncompressedData((BinaryTable)binaryTableHDU.getData());
        compressedData.fillHeader(header);
        return compressedImageHDU;
    }

    @Deprecated
    public static boolean isHeader(Header hdr) {
        return hdr.getBooleanValue(Compression.ZTABLE, false);
    }

    @Deprecated
    public static CompressedTableData manufactureData(Header hdr) throws FitsException {
        return new CompressedTableData(hdr);
    }

    public CompressedTableHDU(Header hdr, CompressedTableData datum) {
        super(hdr, datum);
    }

    public BinaryTableHDU asBinaryTableHDU() throws FitsException {
        return this.asBinaryTableHDU(0, this.getTileCount());
    }

    public int getTileRows() throws FitsException {
        int n = this.getHeader().getIntValue(Compression.ZTILELEN, -1);
        if (n <= 0) {
            throw new FitsException("imnvalid or missing ZTILELEN header keyword");
        }
        return n;
    }

    public int getTileCount() {
        return this.getNRows();
    }

    public BinaryTableHDU asBinaryTableHDU(int fromTile, int toTile) throws FitsException, IllegalArgumentException {
        Header header = this.getTableHeader();
        int tileSize = this.getTileRows();
        this.getData().setRowsPerTile(tileSize);
        if (fromTile < 0 || toTile > this.getTileCount() || toTile <= fromTile) {
            throw new IllegalArgumentException("illegal tile range [" + fromTile + ", " + toTile + "] for " + this.getTileCount() + " tiles");
        }
        int rows = this.getHeader().getIntValue(Compression.ZNAXISn.n(2));
        header.addValue(Standard.NAXIS2, Integer.min(rows, toTile * tileSize) - fromTile * tileSize);
        BinaryTable data = BinaryTableHDU.manufactureData(header);
        BinaryTableHDU tableHDU = new BinaryTableHDU(header, data);
        this.getData().asBinaryTable(data, this.getHeader(), header, fromTile);
        return tableHDU;
    }

    public final BinaryTableHDU asBinaryTableHDU(int tile) throws FitsException, IllegalArgumentException {
        return this.asBinaryTableHDU(tile, tile + 1);
    }

    public Object getColumnData(int col) throws FitsException, IllegalArgumentException {
        return this.getColumnData(col, 0, this.getTileCount());
    }

    public Object getColumnData(int col, int fromTile, int toTile) throws FitsException, IllegalArgumentException {
        this.getData().setRowsPerTile(this.getTileRows());
        return this.getData().getColumnData(col, fromTile, toTile, this.getHeader(), this.getTableHeader());
    }

    public CompressedTableHDU compress() throws FitsException {
        this.getData().compress(this.getHeader());
        return this;
    }

    public Header getTableHeader() throws HeaderCardException {
        Header header = new Header();
        header.addValue((IFitsHeader)Standard.XTENSION, "BINTABLE");
        header.addValue((IFitsHeader)Standard.BITPIX, ElementType.BYTE.bitPix());
        header.addValue((IFitsHeader)Standard.NAXIS, 2);
        Cursor<String, HeaderCard> tableIterator = header.iterator();
        Cursor<String, HeaderCard> iterator = this.getHeader().iterator();
        while (iterator.hasNext()) {
            CompressedCard.backup((HeaderCard)iterator.next(), tableIterator);
        }
        return header;
    }

    @Override
    public CompressedTableData getData() {
        return (CompressedTableData)super.getData();
    }
}

