/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.image.compression.tile.TileCompressionType;
import nom.tam.image.compression.tile.TiledImageCompressionOperation;
import nom.tam.image.compression.tile.mask.AbstractNullPixelMask;
import nom.tam.image.compression.tile.mask.ImageNullPixelMask;
import nom.tam.image.tile.operation.AbstractTileOperation;
import nom.tam.image.tile.operation.ITileOperation;
import nom.tam.image.tile.operation.TileArea;
import nom.tam.util.type.ElementType;

abstract class TileCompressionOperation
extends AbstractTileOperation
implements ITileOperation {
    protected ByteBuffer compressedData;
    protected int compressedOffset;
    protected TileCompressionType compressionType;
    protected ICompressOption tileOptions;

    protected TileCompressionOperation(TiledImageCompressionOperation operation, int tileIndex, TileArea area) {
        super(operation, tileIndex, area);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getTileIndex() + "," + (Object)((Object)this.compressionType) + "," + this.compressedOffset + ")";
    }

    private ByteBuffer convertToBuffer(Object data) {
        return ElementType.forClass(data.getClass().getComponentType()).convertToByteBuffer(data);
    }

    protected void forceNoLoss(boolean value) {
    }

    protected byte[] getCompressedData() {
        byte[] data = new byte[this.compressedData.limit()];
        this.compressedData.rewind();
        ElementType.BYTE.getArray(this.compressedData, data);
        return data;
    }

    protected ByteBuffer getCompressedWholeArea() {
        return this.getTiledImageOperation().getCompressedWholeArea();
    }

    protected TileCompressionType getCompressionType() {
        return this.compressionType;
    }

    protected ICompressorControl getCompressorControl() {
        return this.getTiledImageOperation().getCompressorControl();
    }

    protected ICompressorControl getGzipCompressorControl() {
        return this.getTiledImageOperation().getGzipCompressorControl();
    }

    protected TileCompressionOperation initTileOptions() {
        this.tileOptions = this.getTiledImageOperation().compressOptions().copy().setTileWidth(this.getTileBuffer().getWidth()).setTileHeight(this.getTileBuffer().getHeight());
        return this;
    }

    protected TileCompressionOperation setCompressed(Object data, TileCompressionType type) {
        if (data != null && Array.getLength(data) > 0) {
            this.compressionType = type;
            this.compressedData = this.convertToBuffer(data);
            this.compressedOffset = 0;
        }
        return this;
    }

    protected TileCompressionOperation setCompressedOffset(int value) {
        this.compressedOffset = value;
        return this;
    }

    @Override
    public TileCompressionOperation setDimensions(int dataOffset, int width, int height) {
        super.setDimensions(dataOffset, width, height);
        return this;
    }

    protected void setWholeImageCompressedBuffer(ByteBuffer compressed) {
        compressed.position(this.compressedOffset * this.getBaseType().size());
        this.compressedData = compressed.slice();
        this.compressedOffset = 0;
    }

    protected abstract AbstractNullPixelMask createImageNullPixelMask(ImageNullPixelMask var1);
}

