/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile;

import java.nio.ByteBuffer;
import nom.tam.image.compression.tile.TileCompressionOperation;
import nom.tam.image.compression.tile.TileCompressionType;
import nom.tam.image.compression.tile.TiledImageCompressionOperation;
import nom.tam.image.compression.tile.mask.ImageNullPixelMask;
import nom.tam.image.compression.tile.mask.NullPixelMaskPreserver;
import nom.tam.image.tile.operation.TileArea;
import nom.tam.util.type.ElementType;

public class TileCompressor
extends TileCompressionOperation {
    private boolean forceNoLoss = false;
    private NullPixelMaskPreserver nullPixelMaskPerserver;

    protected TileCompressor(TiledImageCompressionOperation array, int tileIndex, TileArea area) {
        super(array, tileIndex, area);
    }

    @Override
    public void run() {
        this.compress();
    }

    private void compactCompressedData() {
        if (this.getTileIndex() > 0) {
            this.getPreviousTileOperation().waitForResult();
            ByteBuffer compressedWholeArea = this.getCompressedWholeArea();
            this.compressedOffset = compressedWholeArea.position();
            ElementType.BYTE.appendBuffer(compressedWholeArea, this.compressedData);
            this.replaceCompressedBufferWithTargetArea(compressedWholeArea);
        } else {
            this.compressedOffset = 0;
            this.getCompressedWholeArea().position(this.compressedData.limit());
        }
    }

    private void compress() {
        this.initTileOptions();
        this.compressedData.limit(this.getTileBuffer().getPixelSize() * this.getBaseType().size());
        this.compressionType = TileCompressionType.COMPRESSED;
        boolean compressSuccess = false;
        boolean tryNormalCompression = !this.tileOptions.isLossyCompression() || !this.forceNoLoss;
        this.tileOptions.getCompressionParameters().setTileIndex(this.getTileIndex());
        if (tryNormalCompression && (compressSuccess = this.getCompressorControl().compress(this.getTileBuffer().getBuffer(), this.compressedData, this.tileOptions))) {
            if (this.nullPixelMaskPerserver != null) {
                this.nullPixelMaskPerserver.preserveNull();
            }
            this.tileOptions.getCompressionParameters().setValuesInColumn(this.getTileIndex());
        }
        if (!compressSuccess) {
            this.compressionType = TileCompressionType.GZIP_COMPRESSED;
            this.compressedData.rewind();
            this.getTileBuffer().getBuffer().rewind();
            compressSuccess = this.getGzipCompressorControl().compress(this.getTileBuffer().getBuffer(), this.compressedData, null);
            if (compressSuccess) {
                this.tileOptions.getCompressionParameters().setValuesInColumn(this.getTileIndex());
            }
        }
        if (!compressSuccess) {
            this.compressionType = TileCompressionType.UNCOMPRESSED;
            this.compressedData.rewind();
            this.getTileBuffer().getBuffer().rewind();
            this.getBaseType().appendToByteBuffer(this.compressedData, this.getTileBuffer().getBuffer());
        }
        this.compressedData.limit(this.compressedData.position());
        this.compressedData.rewind();
        this.compactCompressedData();
    }

    private void replaceCompressedBufferWithTargetArea(ByteBuffer compressedWholeArea) {
        int compressedSize = this.compressedData.limit();
        int latest = compressedWholeArea.position();
        compressedWholeArea.position(this.compressedOffset);
        this.compressedData = compressedWholeArea.slice();
        this.compressedData.limit(compressedSize);
        compressedWholeArea.position(latest);
    }

    @Override
    protected NullPixelMaskPreserver createImageNullPixelMask(ImageNullPixelMask imageNullPixelMask) {
        if (imageNullPixelMask != null) {
            this.nullPixelMaskPerserver = imageNullPixelMask.createTilePreserver(this.getTileBuffer(), this.getTileIndex());
        }
        return this.nullPixelMaskPerserver;
    }

    @Override
    protected void forceNoLoss(boolean value) {
        this.forceNoLoss = value;
    }
}

