/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardBuilder;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.fits.compression.provider.CompressorProvider;
import nom.tam.fits.compression.provider.param.api.HeaderAccess;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.tile.TileCompressionOperation;
import nom.tam.image.compression.tile.TileCompressionType;
import nom.tam.image.compression.tile.TileCompressorInitialisation;
import nom.tam.image.compression.tile.TileDecompressorInitialisation;
import nom.tam.image.compression.tile.mask.ImageNullPixelMask;
import nom.tam.image.tile.operation.AbstractTiledImageOperation;
import nom.tam.image.tile.operation.TileArea;
import nom.tam.util.type.ElementType;

public class TiledImageCompressionOperation
extends AbstractTiledImageOperation<TileCompressionOperation> {
    private String compressAlgorithm;
    private final BinaryTable binaryTable;
    private ByteBuffer compressedWholeArea;
    private ICompressorControl compressorControl;
    private ICompressOption compressOptions;
    private String quantAlgorithm;
    private ICompressorControl gzipCompressorControl;
    private ImageNullPixelMask imageNullPixelMask;

    private static void addColumnToTable(BinaryTableHDU hdu, Object column, String columnName) throws FitsException {
        if (column != null) {
            hdu.setColumnName(hdu.addColumn(column) - 1, columnName, null);
        }
    }

    private static void setNullEntries(Object column, Object defaultValue) {
        if (column != null) {
            for (int index = 0; index < Array.getLength(column); ++index) {
                if (Array.get(column, index) != null) continue;
                Array.set(column, index, defaultValue);
            }
        }
    }

    public TiledImageCompressionOperation(BinaryTable binaryTable) {
        super(TileCompressionOperation.class);
        this.binaryTable = binaryTable;
    }

    public void compress(BinaryTableHDU hdu) throws FitsException {
        this.processAllTiles();
        this.writeColumns(hdu);
        this.writeHeader(hdu.getHeader());
    }

    @Override
    public synchronized ICompressOption compressOptions() {
        if (this.compressorControl == null) {
            this.getCompressorControl();
            this.compressOptions = this.compressorControl.option();
            if (this.quantAlgorithm != null) {
                Header h = new Header();
                h.addLine(HeaderCard.create((IFitsHeader)Compression.ZQUANTIZ, this.quantAlgorithm));
                this.compressOptions.getCompressionParameters().getValuesFromHeader(h);
            }
            this.compressOptions.getCompressionParameters().initializeColumns(this.getNumberOfTileOperations());
        }
        return this.compressOptions;
    }

    public Buffer decompress() {
        Buffer decompressedWholeArea = this.getBaseType().newBuffer(this.getBufferSize());
        for (TileCompressionOperation tileOperation : (TileCompressionOperation[])this.getTileOperations()) {
            tileOperation.setWholeImageBuffer(decompressedWholeArea);
        }
        this.processAllTiles();
        decompressedWholeArea.rewind();
        return decompressedWholeArea;
    }

    public void forceNoLoss(int x, int y, int width, int heigth) {
        TileArea tileArea = new TileArea().start(x, y).end(x + width, y + heigth);
        for (TileCompressionOperation operation : (TileCompressionOperation[])this.getTileOperations()) {
            if (!operation.getArea().intersects(tileArea)) continue;
            operation.forceNoLoss(true);
        }
    }

    @Override
    public ByteBuffer getCompressedWholeArea() {
        return this.compressedWholeArea;
    }

    @Override
    public synchronized ICompressorControl getCompressorControl() {
        if (this.compressorControl == null) {
            this.compressorControl = CompressorProvider.findCompressorControl(this.quantAlgorithm, this.compressAlgorithm, this.getBaseType().primitiveClass());
            if (this.compressorControl == null) {
                throw new IllegalStateException("Found no compressor control for compression algorithm:" + this.compressAlgorithm + " (quantize algorithm = " + this.quantAlgorithm + ", base type = " + this.getBaseType().primitiveClass() + ")");
            }
        }
        return this.compressorControl;
    }

    @Override
    public synchronized ICompressorControl getGzipCompressorControl() {
        if (this.gzipCompressorControl == null) {
            this.gzipCompressorControl = CompressorProvider.findCompressorControl(null, "GZIP_1", this.getBaseType().primitiveClass());
        }
        return this.gzipCompressorControl;
    }

    public TiledImageCompressionOperation prepareUncompressedData(Buffer buffer) throws FitsException {
        this.compressedWholeArea = ByteBuffer.wrap(new byte[this.getBaseType().size() * this.getBufferSize()]);
        this.createTiles(new TileCompressorInitialisation(this, buffer));
        this.compressedWholeArea.rewind();
        return this;
    }

    public ImageNullPixelMask preserveNulls(long nullValue, String compressionAlgorithm) {
        this.imageNullPixelMask = new ImageNullPixelMask(((TileCompressionOperation[])this.getTileOperations()).length, nullValue, compressionAlgorithm);
        for (TileCompressionOperation tileOperation : (TileCompressionOperation[])this.getTileOperations()) {
            tileOperation.createImageNullPixelMask(this.getImageNullPixelMask());
        }
        return this.imageNullPixelMask;
    }

    private synchronized void setQuantAlgorithm(Header header) {
        this.setQuantAlgorithm(header.getCard(Compression.ZQUANTIZ));
        if (this.quantAlgorithm != null) {
            return;
        }
        boolean hasScale = false;
        boolean hasZero = false;
        int nFields = header.getIntValue(Standard.TFIELDS);
        for (int i = 1; i <= nFields; ++i) {
            String type = header.getStringValue(Standard.TTYPEn.n(i));
            if ("ZSCALE".equals(type)) {
                hasScale = true;
            } else {
                if (!"ZZERO".equals(type)) continue;
                hasZero = true;
            }
            if (!hasScale || !hasZero) continue;
            this.setQuantAlgorithm(HeaderCard.create((IFitsHeader)Compression.ZQUANTIZ, "NO_DITHER"));
            break;
        }
    }

    public TiledImageCompressionOperation read(Header header) throws FitsException {
        this.readPrimaryHeaders(header);
        this.setCompressAlgorithm(header.getCard(Compression.ZCMPTYPE));
        this.setQuantAlgorithm(header);
        this.createTiles(new TileDecompressorInitialisation(this, this.getNullableColumn(header, Object[].class, "UNCOMPRESSED_DATA"), this.getNullableColumn(header, Object[].class, "COMPRESSED_DATA"), this.getNullableColumn(header, Object[].class, "GZIP_COMPRESSED_DATA"), header));
        byte[][] nullPixels = this.getNullableColumn(header, byte[][].class, "NULL_PIXEL_MASK_COLUMN");
        if (nullPixels != null) {
            this.preserveNulls(0L, header.getStringValue(Compression.ZMASKCMP)).setColumn(nullPixels);
        }
        this.readCompressionHeaders(header);
        return this;
    }

    public void readPrimaryHeaders(Header header) throws FitsException {
        this.readBaseType(header);
        this.readAxis(header);
        this.readTileAxis(header);
    }

    public TiledImageCompressionOperation setCompressAlgorithm(HeaderCard compressAlgorithmCard) {
        this.compressAlgorithm = null;
        if (compressAlgorithmCard == null) {
            return this;
        }
        String algo = compressAlgorithmCard.getValue().toUpperCase(Locale.US);
        if (algo.equals("GZIP_1") || algo.equals("GZIP_2") || algo.equals("RICE_1") || algo.equals("PLIO_1") || algo.equals("HCOMPRESS_1") || algo.equals("NOCOMPRESS")) {
            this.compressAlgorithm = algo;
        } else {
            Logger.getLogger(HeaderCard.class.getName()).warning("Ignored invalid ZCMPTYPE value: " + algo);
        }
        return this;
    }

    public synchronized TiledImageCompressionOperation setQuantAlgorithm(HeaderCard quantAlgorithmCard) {
        this.quantAlgorithm = null;
        if (quantAlgorithmCard == null) {
            return this;
        }
        String algo = quantAlgorithmCard.getValue().toUpperCase();
        if (algo.equals("NO_DITHER") || algo.equals("SUBTRACTIVE_DITHER_1") || algo.equals("SUBTRACTIVE_DITHER_2")) {
            this.quantAlgorithm = algo;
        } else {
            Logger.getLogger(HeaderCard.class.getName()).warning("Ignored invalid ZQUANTIZ value: " + algo);
        }
        return this;
    }

    public synchronized String getQuantAlgorithm() {
        return this.quantAlgorithm;
    }

    public String getCompressAlgorithm() {
        return this.compressAlgorithm;
    }

    private <T> T getNullableColumn(Header header, Class<T> class1, String columnName) throws FitsException {
        for (int i = 1; i <= this.binaryTable.getNCols(); ++i) {
            String val = header.getStringValue(Standard.TTYPEn.n(i));
            if (val == null || !val.trim().equals(columnName)) continue;
            return class1.cast(this.binaryTable.getColumn(i - 1));
        }
        return null;
    }

    private void processAllTiles() {
        this.compressOptions();
        ExecutorService threadPool = FitsFactory.threadPool();
        for (TileCompressionOperation tileOperation : (TileCompressionOperation[])this.getTileOperations()) {
            tileOperation.execute(threadPool);
        }
        for (TileCompressionOperation tileOperation : (TileCompressionOperation[])this.getTileOperations()) {
            tileOperation.waitForResult();
        }
    }

    private void readAxis(Header header) throws FitsException {
        if (this.hasAxes()) {
            return;
        }
        int naxis = header.getIntValue(Compression.ZNAXIS);
        int[] axes = new int[naxis];
        for (int i = 1; i <= naxis; ++i) {
            int axisValue = header.getIntValue(Compression.ZNAXISn.n(i), -1);
            if (axisValue == -1) {
                throw new FitsException("Required ZNAXISn not found");
            }
            axes[naxis - i] = axisValue;
        }
        this.setAxes(axes);
    }

    private void readBaseType(Header header) {
        if (this.getBaseType() == null) {
            int zBitPix = header.getIntValue(Compression.ZBITPIX);
            ElementType<Buffer> elementType = ElementType.forNearestBitpix(zBitPix);
            if (elementType == ElementType.UNKNOWN) {
                throw new IllegalArgumentException("Illegal value for ZBITPIX: " + zBitPix);
            }
            this.setBaseType(elementType);
        }
    }

    private void readCompressionHeaders(Header header) {
        this.compressOptions().getCompressionParameters().getValuesFromHeader(new HeaderAccess(header));
    }

    private void readTileAxis(Header header) throws FitsException {
        if (this.hasTileAxes()) {
            return;
        }
        int naxes = this.getNAxes();
        int[] tileAxes = new int[naxes];
        for (int i = 1; i <= naxes; ++i) {
            tileAxes[naxes - i] = header.getIntValue(Compression.ZTILEn.n(i), i == 1 ? header.getIntValue(Compression.ZNAXISn.n(1)) : 1);
        }
        this.setTileAxes(tileAxes);
    }

    private <T> Object setInColumn(Object column, boolean predicate, TileCompressionOperation tileOperation, Class<T> clazz, T value) {
        if (predicate) {
            if (column == null) {
                column = Array.newInstance(clazz, this.getNumberOfTileOperations());
            }
            Array.set(column, tileOperation.getTileIndex(), value);
        }
        return column;
    }

    private synchronized void writeColumns(BinaryTableHDU hdu) throws FitsException {
        Object compressedColumn = null;
        Object uncompressedColumn = null;
        Object gzipColumn = null;
        for (TileCompressionOperation tileOperation : (TileCompressionOperation[])this.getTileOperations()) {
            TileCompressionType compression = tileOperation.getCompressionType();
            byte[] compressedData = tileOperation.getCompressedData();
            compressedColumn = this.setInColumn(compressedColumn, compression == TileCompressionType.COMPRESSED, tileOperation, byte[].class, compressedData);
            gzipColumn = this.setInColumn(gzipColumn, compression == TileCompressionType.GZIP_COMPRESSED, tileOperation, byte[].class, compressedData);
            uncompressedColumn = this.setInColumn(uncompressedColumn, compression == TileCompressionType.UNCOMPRESSED, tileOperation, byte[].class, compressedData);
        }
        TiledImageCompressionOperation.setNullEntries(compressedColumn, new byte[0]);
        TiledImageCompressionOperation.setNullEntries(gzipColumn, new byte[0]);
        TiledImageCompressionOperation.setNullEntries(uncompressedColumn, new byte[0]);
        TiledImageCompressionOperation.addColumnToTable(hdu, compressedColumn, "COMPRESSED_DATA");
        TiledImageCompressionOperation.addColumnToTable(hdu, gzipColumn, "GZIP_COMPRESSED_DATA");
        TiledImageCompressionOperation.addColumnToTable(hdu, uncompressedColumn, "UNCOMPRESSED_DATA");
        if (this.imageNullPixelMask != null) {
            TiledImageCompressionOperation.addColumnToTable(hdu, this.imageNullPixelMask.getColumn(), "NULL_PIXEL_MASK_COLUMN");
        }
        this.compressOptions.getCompressionParameters().addColumnsToTable(hdu);
        ((BinaryTable)hdu.getData()).fillHeader(hdu.getHeader());
    }

    private void writeHeader(Header header) throws FitsException {
        HeaderCardBuilder cardBuilder = header.card(Compression.ZBITPIX).value(this.getBaseType().bitPix()).card(Compression.ZCMPTYPE).value(this.compressAlgorithm);
        int[] tileAxes = this.getTileAxes();
        int naxes = tileAxes.length;
        for (int i = 1; i <= naxes; ++i) {
            cardBuilder.card(Compression.ZTILEn.n(i)).value(tileAxes[naxes - i]);
        }
        this.compressOptions().getCompressionParameters().setValuesInHeader(new HeaderAccess(header));
        if (this.imageNullPixelMask != null) {
            cardBuilder.card(Compression.ZMASKCMP).value(this.imageNullPixelMask.getCompressAlgorithm());
        }
    }

    protected BinaryTable getBinaryTable() {
        return this.binaryTable;
    }

    protected ImageNullPixelMask getImageNullPixelMask() {
        return this.imageNullPixelMask;
    }
}

