/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile.mask;

import java.nio.ByteBuffer;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.image.tile.operation.buffer.TileBuffer;

public class AbstractNullPixelMask {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected static final byte NULL_INDICATOR = 1;
    private final TileBuffer tileBuffer;
    private final int tileIndex;
    private final long nullValue;
    private ByteBuffer mask;
    private final ICompressorControl compressorControl;

    protected AbstractNullPixelMask(TileBuffer tileBuffer, int tileIndex, long nullValue, ICompressorControl compressorControl) throws IllegalStateException {
        this.tileBuffer = tileBuffer;
        this.tileIndex = tileIndex;
        this.nullValue = nullValue;
        this.compressorControl = compressorControl;
        if (this.compressorControl == null) {
            throw new IllegalStateException("Compression algorithm for the null pixel mask not available");
        }
    }

    public byte[] getMaskBytes() {
        if (this.mask == null) {
            return EMPTY_BYTE_ARRAY;
        }
        int size = this.mask.position();
        byte[] result = new byte[size];
        this.mask.rewind();
        this.mask.get(result);
        return result;
    }

    public void setMask(ByteBuffer mask) {
        this.mask = mask;
    }

    protected ICompressorControl getCompressorControl() {
        return this.compressorControl;
    }

    protected ByteBuffer getMask() {
        return this.mask;
    }

    protected long getNullValue() {
        return this.nullValue;
    }

    protected TileBuffer getTileBuffer() {
        return this.tileBuffer;
    }

    protected int getTileIndex() {
        return this.tileIndex;
    }

    protected ByteBuffer initializedMask(int remaining) {
        if (this.mask == null) {
            this.mask = ByteBuffer.allocate(remaining);
        }
        return this.mask;
    }
}

