/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile.mask;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.image.compression.tile.mask.AbstractNullPixelMask;
import nom.tam.image.tile.operation.buffer.TileBuffer;
import nom.tam.util.type.ElementType;

public class NullPixelMaskPreserver
extends AbstractNullPixelMask {
    public NullPixelMaskPreserver(TileBuffer tileBuffer, int tileIndex, long nullValue, ICompressorControl compressorControl) {
        super(tileBuffer, tileIndex, nullValue, compressorControl);
    }

    public void preserveNull() {
        if (this.getTileBuffer().getBaseType().is(ElementType.DOUBLE)) {
            this.preserveNullDoubles();
        } else if (this.getTileBuffer().getBaseType().is(ElementType.FLOAT)) {
            this.preserveNullFloats();
        } else if (this.getTileBuffer().getBaseType().is(ElementType.LONG)) {
            this.preserveNullLongs();
        } else if (this.getTileBuffer().getBaseType().is(ElementType.INT)) {
            this.preserveNullInts();
        } else if (this.getTileBuffer().getBaseType().is(ElementType.SHORT)) {
            this.preserveNullShorts();
        } else if (this.getTileBuffer().getBaseType().is(ElementType.BYTE)) {
            this.preserveNullBytes();
        }
        if (this.getMask() != null) {
            ByteBuffer compressed = ByteBuffer.allocate(this.getTileBuffer().getPixelSize());
            if (!this.getCompressorControl().compress(this.getMask(), compressed, this.getCompressorControl().option())) {
                throw new IllegalStateException("could not compress the null pixel mask");
            }
            this.setMask(compressed);
        }
    }

    private void preserveNullBytes() {
        ByteBuffer buffer = (ByteBuffer)this.getTileBuffer().getBuffer();
        byte nullValue = (byte)this.getNullValue();
        int size = buffer.remaining();
        for (int index = 0; index < size; ++index) {
            if (nullValue != buffer.get(index)) continue;
            this.initializedMask(size).put(index, (byte)1);
        }
    }

    private void preserveNullDoubles() {
        DoubleBuffer buffer = (DoubleBuffer)this.getTileBuffer().getBuffer();
        int size = this.getTileBuffer().getPixelSize();
        for (int index = 0; index < size; ++index) {
            if (!Double.isNaN(buffer.get(index))) continue;
            this.initializedMask(size).put(index, (byte)1);
        }
    }

    private void preserveNullFloats() {
        FloatBuffer buffer = (FloatBuffer)this.getTileBuffer().getBuffer();
        int size = this.getTileBuffer().getPixelSize();
        for (int index = 0; index < size; ++index) {
            if (!Float.isNaN(buffer.get(index))) continue;
            this.initializedMask(size).put(index, (byte)1);
        }
    }

    private void preserveNullInts() {
        IntBuffer buffer = (IntBuffer)this.getTileBuffer().getBuffer();
        int nullValue = (int)this.getNullValue();
        int size = this.getTileBuffer().getPixelSize();
        for (int index = 0; index < size; ++index) {
            if (nullValue != buffer.get(index)) continue;
            this.initializedMask(size).put(index, (byte)1);
        }
    }

    private void preserveNullLongs() {
        LongBuffer buffer = (LongBuffer)this.getTileBuffer().getBuffer();
        long nullValue = this.getNullValue();
        int size = this.getTileBuffer().getPixelSize();
        for (int index = 0; index < size; ++index) {
            if (nullValue != buffer.get(index)) continue;
            this.initializedMask(size).put(index, (byte)1);
        }
    }

    private void preserveNullShorts() {
        ShortBuffer buffer = (ShortBuffer)this.getTileBuffer().getBuffer();
        short nullValue = (short)this.getNullValue();
        int size = this.getTileBuffer().getPixelSize();
        for (int index = 0; index < size; ++index) {
            if (nullValue != buffer.get(index)) continue;
            this.initializedMask(size).put(index, (byte)1);
        }
    }
}

