/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.tile.operation;

import java.nio.Buffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import nom.tam.image.tile.operation.ITileOperation;
import nom.tam.image.tile.operation.ITiledImageOperation;
import nom.tam.image.tile.operation.TileArea;
import nom.tam.image.tile.operation.buffer.TileBuffer;
import nom.tam.image.tile.operation.buffer.TileBufferFactory;
import nom.tam.util.type.ElementType;

public abstract class AbstractTileOperation
implements Runnable,
ITileOperation {
    private final ITiledImageOperation tiledImageOperation;
    private Future<?> future;
    private TileBuffer tileBuffer;
    private final int tileIndex;
    private final TileArea area;

    public AbstractTileOperation(ITiledImageOperation operation, int tileIndex, TileArea area) {
        this.tiledImageOperation = operation;
        this.tileIndex = tileIndex;
        this.area = area;
    }

    public void execute(ExecutorService threadPool) {
        this.future = threadPool.submit(this);
    }

    public TileArea getArea() {
        return this.area;
    }

    public int getPixelSize() {
        return this.tileBuffer.getPixelSize();
    }

    public int getTileIndex() {
        return this.tileIndex;
    }

    public void setWholeImageBuffer(Buffer buffer) {
        this.tileBuffer.setData(buffer);
    }

    @Override
    public void waitForResult() {
        try {
            this.future.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("could not process tile", e);
        }
    }

    protected ElementType<Buffer> getBaseType() {
        return this.tiledImageOperation.getBaseType();
    }

    protected ITileOperation getPreviousTileOperation() {
        return this.tiledImageOperation.getTileOperation(this.getTileIndex() - 1);
    }

    protected TileBuffer getTileBuffer() {
        return this.tileBuffer;
    }

    protected ITiledImageOperation getTiledImageOperation() {
        return this.tiledImageOperation;
    }

    @Override
    public ITileOperation setDimensions(int dataOffset, int width, int height) {
        this.setTileBuffer(TileBufferFactory.createTileBuffer(this.getBaseType(), dataOffset, this.tiledImageOperation.getImageWidth(), width, height));
        this.area.size(width, height);
        return this;
    }

    protected void setTileBuffer(TileBuffer tileBuffer) {
        this.tileBuffer = tileBuffer;
    }
}

