/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.tile.operation;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import nom.tam.fits.FitsException;
import nom.tam.image.tile.operation.ITileOperation;
import nom.tam.image.tile.operation.ITileOperationInitialisation;
import nom.tam.image.tile.operation.ITiledImageOperation;
import nom.tam.image.tile.operation.TileArea;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.type.ElementType;

public abstract class AbstractTiledImageOperation<OPERATION extends ITileOperation>
implements ITiledImageOperation {
    private int[] axes;
    private ElementType<Buffer> baseType;
    private int[] tileAxes;
    private OPERATION[] tileOperations;
    private final Class<OPERATION> operationClass;

    public AbstractTiledImageOperation(Class<OPERATION> operationClass) {
        this.operationClass = operationClass;
    }

    @Override
    public ElementType<Buffer> getBaseType() {
        return this.baseType;
    }

    public int getBufferSize() {
        int bufferSize = 1;
        for (int axisValue : this.axes) {
            bufferSize *= axisValue;
        }
        return bufferSize;
    }

    @Override
    public int getImageWidth() {
        return this.axes[this.axes.length - 1];
    }

    public OPERATION getTileOperation(int i) {
        return this.tileOperations[i];
    }

    public void setAxes(int[] axes) {
        this.axes = Arrays.copyOf(axes, axes.length);
    }

    public void setTileAxes(int[] value) throws FitsException {
        int i = value.length - 2;
        while (--i >= 0) {
            if (value[i] == 1) continue;
            throw new FitsException("Tile sizes in higher dimensions (>2) must be 1 as per the FITSIO convention (" + i + ":" + value[i] + ")");
        }
        this.tileAxes = Arrays.copyOf(value, value.length);
    }

    protected boolean hasAxes() {
        return this.axes != null;
    }

    protected boolean hasTileAxes() {
        return this.tileAxes != null;
    }

    private int getBufferOffset(int[] index) {
        int l = 0;
        int blockSize = 1;
        int i = index.length;
        while (--i >= 0) {
            l += index[i] * blockSize;
            blockSize *= this.axes[i];
        }
        return l;
    }

    protected void createTiles(ITileOperationInitialisation<OPERATION> init) throws FitsException {
        int[] offset = new int[this.axes.length];
        int[] tileSize = new int[2];
        int pos = 0;
        int imLength = 1;
        int i = this.axes.length;
        while (--i >= 0) {
            imLength *= this.axes[i];
        }
        tileSize[1] = 1;
        if (this.tileAxes.length < this.axes.length) {
            int[] tile = new int[this.axes.length];
            System.arraycopy(this.tileAxes, 0, tile, tile.length - this.tileAxes.length, this.tileAxes.length);
            Arrays.fill(tile, 0, tile.length - this.tileAxes.length, 1);
            this.tileAxes = tile;
        }
        ArrayList<OPERATION> opList = new ArrayList<OPERATION>();
        int tileIndex = 0;
        while (pos < imLength) {
            int k;
            int i2 = Math.min(tileSize.length, this.tileAxes.length);
            while (--i2 >= 0) {
                k = this.axes.length - 1 - i2;
                tileSize[i2] = offset[k] + this.tileAxes[k] > this.axes[k] ? this.axes[k] - offset[k] : this.tileAxes[k];
            }
            OPERATION op = init.createTileOperation(tileIndex, new TileArea().start(ArrayFuncs.getReversed(offset)));
            op.setDimensions(pos, tileSize[0], tileSize[1]);
            opList.add(op);
            k = this.axes.length;
            while (--k >= 0) {
                int n = k;
                offset[n] = offset[n] + this.tileAxes[k];
                if (offset[k] < this.axes[k]) break;
                if (k <= 0) continue;
                offset[k] = 0;
            }
            pos = this.getBufferOffset(offset);
            ++tileIndex;
        }
        this.tileOperations = (ITileOperation[])Array.newInstance(this.operationClass, opList.size());
        opList.toArray(this.tileOperations);
        init.tileCount(this.tileOperations.length);
        for (OPERATION op : this.tileOperations) {
            init.init(op);
        }
    }

    protected int getNAxes() {
        return this.axes.length;
    }

    protected int getNumberOfTileOperations() {
        return this.tileOperations.length;
    }

    protected int[] getTileAxes() {
        return this.tileAxes;
    }

    protected OPERATION[] getTileOperations() {
        return this.tileOperations;
    }

    protected void setBaseType(ElementType<Buffer> baseType) {
        this.baseType = baseType;
    }
}

