/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.tile.operation;

import java.util.Arrays;

public class TileArea {
    private int[] startPoint;
    private int[] endPoint;

    public TileArea end(int ... newEndPoint) {
        this.endPoint = Arrays.copyOf(newEndPoint, newEndPoint.length);
        return this;
    }

    public int dimension() {
        return this.startPoint == null ? 0 : this.startPoint.length;
    }

    public boolean intersects(TileArea other) throws IllegalArgumentException {
        if (other.dimension() != this.dimension()) {
            throw new IllegalArgumentException("Tiles of different dimensionalities (" + other.dimension() + " vs " + this.dimension() + ".");
        }
        int i = this.dimension();
        while (--i >= 0) {
            if (other.startPoint[i] < this.endPoint[i] && this.startPoint[i] < other.endPoint[i]) continue;
            return false;
        }
        return true;
    }

    public TileArea size(int ... sizes) {
        this.endPoint = new int[this.startPoint.length];
        for (int index = 0; index < this.startPoint.length; ++index) {
            this.endPoint[index] = this.startPoint[index] + (index < sizes.length ? sizes[index] : 1);
        }
        return this;
    }

    public TileArea start(int ... newStartPoint) {
        this.startPoint = Arrays.copyOf(newStartPoint, newStartPoint.length);
        return this;
    }
}

