/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.tile.operation.buffer;

import java.nio.Buffer;
import nom.tam.image.tile.operation.buffer.TileBuffer;
import nom.tam.util.type.ElementType;

class TileBufferColumnBased
extends TileBuffer {
    private Buffer packed;
    private final int imageWidth;

    TileBufferColumnBased(ElementType<Buffer> baseType, int dataOffset, int imageWidth, int width, int height) {
        super(baseType, dataOffset, width, height);
        this.imageWidth = imageWidth;
    }

    @Override
    public void finish() {
        this.desolveGapLessBuffer();
    }

    @Override
    public Buffer getBuffer() {
        if (this.packed == null) {
            this.createPackedBuffer();
        }
        return this.packed;
    }

    private void createPackedBuffer() {
        int gap = this.imageWidth - this.getWidth();
        Buffer raw = this.getImageBuffer();
        int imLength = Math.min(raw.capacity(), this.getPixelSizeInData());
        raw.position(0);
        ElementType<Buffer> type = this.elementType();
        this.packed = type.newBuffer(this.getPixelSize());
        for (int i = 0; i < this.getHeight(); ++i) {
            raw.limit(raw.position() + this.getWidth());
            type.appendBuffer(this.packed, raw);
            raw.limit(Math.min(raw.position() + gap, imLength));
            raw.position(raw.limit());
        }
        this.packed.rewind();
        raw.limit(imLength);
    }

    private void desolveGapLessBuffer() {
        int gap = this.imageWidth - this.getWidth();
        Buffer raw = this.getImageBuffer();
        raw.position(0);
        raw.limit(this.getPixelSizeInData());
        this.packed.rewind();
        ElementType<Buffer> type = this.elementType();
        for (int i = 0; i < this.getHeight(); ++i) {
            this.packed.limit(this.packed.position() + this.getWidth());
            type.appendBuffer(raw, this.packed);
            raw.position(Math.min(raw.position() + gap, raw.limit()));
        }
        this.packed = null;
    }

    private int getPixelSizeInData() {
        return (this.getHeight() - 1) * this.imageWidth + this.getWidth();
    }

    private ElementType<Buffer> elementType() {
        return ElementType.forBuffer(this.getImageBuffer());
    }
}

