/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import nom.tam.util.FitsEncoder;
import nom.tam.util.FitsIO;
import nom.tam.util.InputReader;

public interface ArrayDataInput
extends InputReader,
DataInput,
FitsIO {
    public void mark(int var1) throws IOException;

    default public boolean markSupported() {
        return true;
    }

    public int read(byte[] var1) throws EOFException, IOException;

    default public int read(boolean[] buf) throws EOFException, IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(boolean[] var1, int var2, int var3) throws EOFException, IOException;

    default public int read(Boolean[] buf) throws EOFException, IOException {
        return this.read(buf, 0, buf.length);
    }

    default public int read(Boolean[] buf, int offset, int size) throws EOFException, IOException {
        int to = offset + size;
        for (int i = offset; i < to; ++i) {
            buf[i] = this.readBoolean();
        }
        return size;
    }

    default public int read(char[] buf) throws EOFException, IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(char[] var1, int var2, int var3) throws EOFException, IOException;

    default public int read(double[] buf) throws EOFException, IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(double[] var1, int var2, int var3) throws EOFException, IOException;

    default public int read(float[] buf) throws EOFException, IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(float[] var1, int var2, int var3) throws EOFException, IOException;

    default public int read(int[] buf) throws EOFException, IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(int[] var1, int var2, int var3) throws EOFException, IOException;

    default public int read(long[] buf) throws EOFException, IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(long[] var1, int var2, int var3) throws EOFException, IOException;

    default public int read(short[] buf) throws EOFException, IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(short[] var1, int var2, int var3) throws EOFException, IOException;

    @Deprecated
    default public int readArray(Object o) throws EOFException, IOException, IllegalArgumentException {
        return (int)this.readLArray(o);
    }

    public long readLArray(Object var1) throws EOFException, IOException, IllegalArgumentException;

    default public void readArrayFully(Object o) throws EOFException, IOException, IllegalArgumentException {
        if (this.readLArray(o) != FitsEncoder.computeSize(o)) {
            throw new EOFException("Incomplete array read (assuming default FITS format).");
        }
    }

    default public void readImage(Object o) throws IOException, IllegalArgumentException {
        this.readArrayFully(o);
    }

    public void reset() throws IOException;

    public long skip(long var1) throws EOFException, IOException;

    public void skipAllBytes(long var1) throws EOFException, IOException;

    @Deprecated
    default public void skipAllBytes(int toSkip) throws EOFException, IOException {
        this.skipAllBytes((long)toSkip);
    }

    @Override
    public void readFully(byte[] var1, int var2, int var3) throws IOException;
}

