/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.util.ComplexValue;
import nom.tam.util.FitsEncoder;
import nom.tam.util.Quantizer;
import nom.tam.util.array.MultiArrayCopier;
import nom.tam.util.type.ElementType;

public final class ArrayFuncs {
    private static final Logger LOG = Logger.getLogger(ArrayFuncs.class.getName());

    private ArrayFuncs() {
    }

    public static int[] getReversed(int ... index) {
        int[] rev = new int[index.length];
        int nm1 = index.length - 1;
        int i = index.length;
        while (--i >= 0) {
            rev[i] = index[nm1 - i];
        }
        return rev;
    }

    public static void copy(Object src, int srcPos, Object dest, int destPos, int length, int step) {
        if (!dest.getClass().equals(src.getClass())) {
            throw new IllegalArgumentException("Mismatched types: src " + src.getClass() + ", dst " + dest.getClass());
        }
        if (src instanceof Object[]) {
            Object[] from = (Object[])src;
            Object[] to = (Object[])dest;
            int toIndex = 0;
            for (int index = srcPos; index < srcPos + length; index += step) {
                ArrayFuncs.copy(from[index], srcPos, to[toIndex++], destPos, length, step);
            }
        } else if (step == 1) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        } else {
            int srcLength = Array.getLength(src);
            int loopLength = Math.min(srcLength, srcPos + length);
            for (int i = srcPos; i < loopLength; i += step) {
                Array.set(dest, destPos++, Array.get(src, i));
            }
        }
    }

    public static String arrayDescription(Object o) {
        Class<?> base = ArrayFuncs.getBaseClass(o);
        if (base == Void.TYPE) {
            return "NULL";
        }
        return base.getSimpleName() + Arrays.toString(ArrayFuncs.getDimensions(o));
    }

    @Deprecated
    public static long computeLSize(Object o) {
        return FitsEncoder.computeSize(o);
    }

    @Deprecated
    public static int computeSize(Object o) {
        return (int)ArrayFuncs.computeLSize(o);
    }

    public static Object convertArray(Object array, Class<?> newType) {
        if (newType.equals(ArrayFuncs.getBaseClass(array))) {
            Object copy = Array.newInstance(newType, ArrayFuncs.getDimensions(array));
            ArrayFuncs.copyArray(array, copy);
            return copy;
        }
        return ArrayFuncs.convertArray(array, newType, null);
    }

    public static Object convertArray(Object array, Class<?> newType, boolean reuse) {
        if (reuse) {
            return ArrayFuncs.convertArray(array, newType, null);
        }
        return ArrayFuncs.convertArray(array, newType);
    }

    @Deprecated
    public static void copyArray(Object original, Object copy) throws IllegalArgumentException {
        Class<?> cl = original.getClass();
        if (!cl.isArray()) {
            throw new IllegalArgumentException("original is not an array");
        }
        if (!copy.getClass().equals(cl)) {
            throw new IllegalArgumentException("mismatch of types: " + cl.getName() + " vs " + copy.getClass().getName());
        }
        int length = Array.getLength(original);
        if (Array.getLength(copy) != length) {
            throw new IllegalArgumentException("mismatch of sizes: " + length + " vs " + Array.getLength(copy));
        }
        if (original instanceof Object[]) {
            Object[] from = (Object[])original;
            Object[] to = (Object[])copy;
            for (int index = 0; index < length; ++index) {
                ArrayFuncs.copyArray(from[index], to[index]);
            }
        } else {
            System.arraycopy(original, 0, copy, 0, length);
        }
    }

    public static void copyInto(Object array, Object mimic) {
        MultiArrayCopier.copyInto(array, mimic);
    }

    public static Object curl(Object input, int ... dimens) throws IllegalStateException {
        if (input == null) {
            return null;
        }
        if (!input.getClass().isArray()) {
            throw new IllegalArgumentException("Attempt to curl a non-array: " + input.getClass());
        }
        if (input.getClass().getComponentType().isArray()) {
            throw new IllegalArgumentException("Attempt to curl non-1D array: " + input.getClass());
        }
        int size = Array.getLength(input);
        int test = 1;
        for (int dimen : dimens) {
            test *= dimen;
        }
        if (test != size) {
            throw new IllegalStateException("Curled array does not fit desired dimensions: " + size + ", expected " + test + " (" + ArrayFuncs.getBaseClass(input) + ")");
        }
        Object newArray = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(input), dimens);
        MultiArrayCopier.copyInto(input, newArray);
        return newArray;
    }

    public static Object deepClone(Object o) {
        if (o == null) {
            return null;
        }
        if (!o.getClass().isArray()) {
            return ArrayFuncs.genericClone(o);
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            Object[] copy = (Object[])ArrayFuncs.newInstance(array.getClass().getComponentType(), array.length);
            for (int i = 0; i < array.length; ++i) {
                copy[i] = ArrayFuncs.deepClone(array[i]);
            }
            return copy;
        }
        int length = Array.getLength(o);
        Object copy = Array.newInstance(o.getClass().getComponentType(), length);
        System.arraycopy(o, 0, copy, 0, length);
        return copy;
    }

    public static Object flatten(Object input) {
        if (input == null) {
            return null;
        }
        if (!input.getClass().isArray()) {
            return input;
        }
        int[] dimens = ArrayFuncs.getDimensions(input);
        if (dimens.length <= 1) {
            return input;
        }
        int size = 1;
        for (int dimen : dimens) {
            size *= dimen;
        }
        Object flat = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(input), size);
        MultiArrayCopier.copyInto(input, flat);
        return flat;
    }

    public static Object genericClone(Object o) {
        if (o.getClass().isArray()) {
            return ArrayFuncs.deepClone(o);
        }
        if (!(o instanceof Cloneable)) {
            LOG.log(Level.SEVERE, "generic clone called on a non clonable type");
            return null;
        }
        try {
            return o.getClass().getMethod("clone", new Class[0]).invoke(o, new Object[0]);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Implements cloneable, but does not apparently make clone public.", e);
            return null;
        }
    }

    public static Object getBaseArray(Object o) {
        if (o instanceof Object[]) {
            return ArrayFuncs.getBaseArray(((Object[])o)[0]);
        }
        return o;
    }

    public static Class<?> getBaseClass(Object o) {
        if (o == null) {
            return Void.TYPE;
        }
        Class<?> clazz = o.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static int getBaseLength(Object o) {
        if (o == null) {
            return 0;
        }
        ElementType type = ElementType.forClass(ArrayFuncs.getBaseClass(o));
        return type.size();
    }

    public static int[] getDimensions(Object o) {
        if (o == null) {
            return null;
        }
        Object object = o;
        Class<?> clazz = o.getClass();
        int ndim = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++ndim;
        }
        clazz = o.getClass();
        int[] dimens = new int[ndim];
        ndim = 0;
        while (clazz.isArray()) {
            dimens[ndim] = -1;
            if (object != null) {
                int length = Array.getLength(object);
                if (length > 0) {
                    dimens[ndim] = length;
                    object = Array.get(object, 0);
                } else {
                    dimens[ndim] = 0;
                    object = null;
                }
            }
            clazz = clazz.getComponentType();
            ++ndim;
        }
        return dimens;
    }

    public static Object mimicArray(Object array, Class<?> newType) {
        int dims = 0;
        Class<?> arrayClass = array.getClass();
        while (arrayClass.isArray()) {
            arrayClass = arrayClass.getComponentType();
            ++dims;
        }
        if (dims <= 1) {
            return ArrayFuncs.newInstance(newType, Array.getLength(array));
        }
        Object[] xarray = (Object[])array;
        int[] dimens = new int[dims];
        dimens[0] = xarray.length;
        Object mimic = ArrayFuncs.newInstance(newType, dimens);
        for (int i = 0; i < xarray.length; ++i) {
            Object temp;
            ((Object[])mimic)[i] = temp = ArrayFuncs.mimicArray(xarray[i], newType);
        }
        return mimic;
    }

    public static boolean isEmpty(Object o) {
        return o == null || Array.getLength(o) == 0;
    }

    @Deprecated
    public static int nElements(Object o) {
        return (int)ArrayFuncs.nLElements(o);
    }

    public static Object newInstance(Class<?> cl, int ... dims) {
        if (dims.length == 0) {
            dims = new int[]{1};
        }
        return Array.newInstance(cl, dims);
    }

    public static long nLElements(Object o) {
        return ArrayFuncs.countElements(o);
    }

    public static long countElements(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Object[]) {
            long count = 0L;
            for (Object e : (Object[])o) {
                count += ArrayFuncs.countElements(e);
            }
            return count;
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        return 1L;
    }

    public static int[] reverseIndices(int ... indices) {
        int[] result = new int[indices.length];
        int len = indices.length;
        for (int i = 0; i < indices.length; ++i) {
            result[len - i - 1] = indices[i];
        }
        return result;
    }

    public static int[] checkRegularArray(Object o, boolean allowNulls) throws NullPointerException, IllegalArgumentException, ClassCastException {
        if (!o.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array: " + o.getClass());
        }
        if (o.getClass().getComponentType().isPrimitive()) {
            return new int[]{Array.getLength(o)};
        }
        int[] dim = ArrayFuncs.getDimensions(o);
        if (dim[0] == 0) {
            return dim;
        }
        Class<?> type = null;
        Object[] array = (Object[])o;
        for (int i = 0; i < dim[0]; ++i) {
            Object e = array[i];
            if (e == null) {
                if (allowNulls) continue;
                throw new IllegalArgumentException("Entry at index " + i + " is null");
            }
            if (type == null) {
                type = e.getClass();
            } else if (!e.getClass().equals(type)) {
                throw new ClassCastException("Mismatched component type at index " + i + ": " + e.getClass() + ", expected " + type);
            }
            if (!e.getClass().isArray()) continue;
            int[] sub = ArrayFuncs.checkRegularArray(e, allowNulls);
            if (sub.length + 1 != dim.length) {
                throw new IllegalArgumentException("Mismatched component dimension at index " + i + ": " + sub.length + ", expected " + (dim.length - 1));
            }
            if (sub[0] == dim[1]) continue;
            throw new IllegalArgumentException("Mismatched component size at index " + i + ": " + sub[0] + ", expected " + dim[0]);
        }
        return dim;
    }

    public static Object complexToDecimals(Object o, Class<?> decimalType) {
        if (o instanceof ComplexValue) {
            ComplexValue z = (ComplexValue)o;
            if (Float.TYPE.equals(decimalType)) {
                return new float[]{(float)z.re(), (float)z.im()};
            }
            return new double[]{z.re(), z.im()};
        }
        if (o instanceof ComplexValue[]) {
            ComplexValue[] z = (ComplexValue[])o;
            if (Float.TYPE.equals(decimalType)) {
                float[][] f = new float[z.length][];
                for (int i = 0; i < z.length; ++i) {
                    f[i] = (float[])ArrayFuncs.complexToDecimals(z[i], decimalType);
                }
                return f;
            }
            double[][] d = new double[z.length][];
            for (int i = 0; i < z.length; ++i) {
                d[i] = (double[])ArrayFuncs.complexToDecimals(z[i], decimalType);
            }
            return d;
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            Object[] z = null;
            for (int i = 0; i < array.length; ++i) {
                Object e = ArrayFuncs.complexToDecimals(array[i], decimalType);
                if (z == null) {
                    z = (Object[])Array.newInstance(e.getClass(), array.length);
                }
                z[i] = e;
            }
            return z;
        }
        throw new IllegalArgumentException("Cannot convert to complex values: " + o.getClass().getName());
    }

    public static Object decimalsToComplex(Object array) throws IllegalArgumentException {
        if (array instanceof float[]) {
            float[] f = (float[])array;
            if (f.length == 2) {
                return new ComplexValue.Float(f[0], f[1]);
            }
            if (f.length % 2 == 1) {
                throw new IllegalArgumentException("Odd number floats for complex conversion: " + f.length);
            }
            ComplexValue[] z = new ComplexValue[f.length >>> 1];
            for (int i = 0; i < f.length; i += 2) {
                z[i >> 1] = new ComplexValue(f[i], f[i + 1]);
            }
            return z;
        }
        if (array instanceof double[]) {
            double[] d = (double[])array;
            if (d.length == 2) {
                return new ComplexValue(d[0], d[1]);
            }
            if (d.length % 2 == 1) {
                throw new IllegalArgumentException("Odd number floats for complex conversion: " + d.length);
            }
            ComplexValue[] z = new ComplexValue[d.length >>> 1];
            for (int i = 0; i < d.length; i += 2) {
                z[i >> 1] = new ComplexValue(d[i], d[i + 1]);
            }
            return z;
        }
        if (array instanceof Object[]) {
            Object[] o = (Object[])array;
            Object[] z = null;
            for (int i = 0; i < o.length; ++i) {
                Object e = ArrayFuncs.decimalsToComplex(o[i]);
                if (z == null) {
                    z = (Object[])Array.newInstance(e.getClass(), o.length);
                }
                z[i] = e;
            }
            return z;
        }
        throw new IllegalArgumentException("Cannot convert to complex values: " + array.getClass().getName());
    }

    public static Object decimalsToComplex(Object re, Object im) {
        if (!re.getClass().equals(im.getClass())) {
            throw new IllegalArgumentException("Mismatched components: " + re.getClass().getName() + " vs " + re.getClass().getName());
        }
        if (re instanceof float[]) {
            float[] fre = (float[])re;
            float[] fim = (float[])im;
            ComplexValue.Float[] z = new ComplexValue.Float[fre.length];
            int i = fre.length;
            while (--i >= 0) {
                z[i] = new ComplexValue.Float(fre[i], fim[i]);
            }
            return z;
        }
        if (re instanceof double[]) {
            double[] dre = (double[])re;
            double[] dim = (double[])im;
            ComplexValue[] z = new ComplexValue[dre.length];
            int i = dre.length;
            while (--i >= 0) {
                z[i] = new ComplexValue(dre[i], dim[i]);
            }
            return z;
        }
        if (re instanceof Object[]) {
            Object[] ore = (Object[])re;
            Object[] oim = (Object[])im;
            Object[] z = null;
            int i = ore.length;
            while (--i >= 0) {
                Object e = ArrayFuncs.decimalsToComplex(ore[i], oim[i]);
                if (z == null) {
                    z = (Object[])Array.newInstance(e.getClass(), ore.length);
                }
                z[i] = e;
            }
            return z;
        }
        throw new IllegalArgumentException("Cannot convert components to complex: " + re.getClass().getName());
    }

    private static void decimalToInteger(Object from, Object to, Quantizer q) {
        if (from instanceof Object[]) {
            Object[] a = (Object[])from;
            Object[] b = (Object[])to;
            for (int i = 0; i < a.length; ++i) {
                ArrayFuncs.decimalToInteger(a[i], b[i], q);
            }
        } else {
            int i = Array.getLength(from);
            while (--i >= 0) {
                long l = q.toLong(from instanceof double[] ? ((double[])from)[i] : (double)((float[])from)[i]);
                if (to instanceof byte[]) {
                    ((byte[])to)[i] = (byte)l;
                    continue;
                }
                if (to instanceof short[]) {
                    ((short[])to)[i] = (short)l;
                    continue;
                }
                if (to instanceof int[]) {
                    ((int[])to)[i] = (int)l;
                    continue;
                }
                ((long[])to)[i] = l;
            }
        }
    }

    private static void integerToDecimal(Object from, Object to, Quantizer q) {
        if (from instanceof Object[]) {
            Object[] a = (Object[])from;
            Object[] b = (Object[])to;
            for (int i = 0; i < a.length; ++i) {
                ArrayFuncs.integerToDecimal(a[i], b[i], q);
            }
        } else {
            int i = Array.getLength(from);
            while (--i >= 0) {
                double d = q.toDouble(Array.getLong(from, i));
                if (to instanceof float[]) {
                    ((float[])to)[i] = (float)d;
                    continue;
                }
                ((double[])to)[i] = d;
            }
        }
    }

    public static Object convertArray(Object array, Class<?> newType, Quantizer quant) throws IllegalArgumentException {
        boolean toInteger;
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array: " + array.getClass().getName());
        }
        Class<Object> fromType = ArrayFuncs.getBaseClass(array);
        if (newType.isAssignableFrom(fromType)) {
            return array;
        }
        boolean toComplex = ComplexValue.class.isAssignableFrom(newType);
        if (toComplex) {
            Class<Number> clazz = newType = ComplexValue.Float.class.isAssignableFrom(newType) ? Float.TYPE : Double.TYPE;
        }
        if (!newType.isPrimitive() || newType == Boolean.TYPE || newType == Character.TYPE) {
            throw new IllegalArgumentException("Not a supported numerical type: " + newType.getName());
        }
        boolean bl = toInteger = newType != Float.TYPE && newType != Double.TYPE;
        if (ComplexValue.class.isAssignableFrom(fromType)) {
            fromType = ComplexValue.Float.class.isAssignableFrom(fromType) ? Float.TYPE : Double.TYPE;
            array = ArrayFuncs.complexToDecimals(array, fromType);
        }
        boolean fromInteger = fromType != Float.TYPE && fromType != Double.TYPE;
        Object t = Array.newInstance(newType, ArrayFuncs.getDimensions(array));
        if (quant != null) {
            if (fromInteger && !toInteger) {
                ArrayFuncs.integerToDecimal(array, t, quant);
            } else if (!fromInteger && toInteger) {
                ArrayFuncs.decimalToInteger(array, t, quant);
            } else {
                MultiArrayCopier.copyInto(array, t);
            }
        } else {
            MultiArrayCopier.copyInto(array, t);
        }
        if (toComplex) {
            t = ArrayFuncs.decimalsToComplex(t);
        }
        return t;
    }

    public static Object sample(Object orig, int step) throws IndexOutOfBoundsException {
        int[] n = ArrayFuncs.getDimensions(orig);
        Arrays.fill(n, step);
        return ArrayFuncs.sample(orig, n);
    }

    public static Object sample(Object orig, int[] step) throws IndexOutOfBoundsException {
        return ArrayFuncs.sample(orig, null, null, step);
    }

    public static Object slice(Object orig, int[] from) throws IndexOutOfBoundsException {
        return ArrayFuncs.slice(orig, from, null);
    }

    public static Object slice(Object orig, int[] from, int[] size) throws IndexOutOfBoundsException {
        int[] step = null;
        if (size != null) {
            step = new int[size.length];
            for (int i = 0; i < size.length; ++i) {
                step[i] = size[i] < 0 ? -1 : 1;
            }
        }
        return ArrayFuncs.sample(orig, from, size, step, 0);
    }

    public static Object sample(Object orig, int[] from, int[] size, int[] step) throws IndexOutOfBoundsException {
        return ArrayFuncs.sample(orig, from, size, step, 0);
    }

    private static Object sample(Object orig, int[] from, int[] size, int[] step, int idx) throws IndexOutOfBoundsException {
        int istep;
        int isize;
        boolean isReversed;
        if (!orig.getClass().isArray() || from != null && idx == from.length) {
            return orig;
        }
        int l = Array.getLength(orig);
        int ndim = from == null ? ArrayFuncs.getDimensions(orig).length : from.length;
        boolean bl = isReversed = step != null && step[idx] < 0;
        int ifrom = from == null ? (isReversed ? l - 1 : 0) : from[idx];
        int n = isize = size == null ? 0 : Math.abs(size[idx]);
        if (isize == 0) {
            isize = l - ifrom;
        }
        int ito = ifrom + (isReversed ? -isize : isize);
        if (ifrom < 0 || ito < -1 || ifrom >= l || ito > l) {
            throw new IndexOutOfBoundsException("Sampled bounds are out of range for original array");
        }
        int n2 = istep = step == null ? 1 : step[idx];
        if (istep == 0) {
            istep = 1;
        }
        int astep = Math.abs(istep);
        int n3 = Math.abs((isize + astep - 1) / astep);
        Object slice = Array.newInstance(orig.getClass().getComponentType(), n3);
        if (!isReversed && ndim == 1 && istep == 1) {
            System.arraycopy(orig, ifrom, slice, 0, isize);
        } else {
            for (int i = 0; i < n3; ++i) {
                Object efrom = Array.get(orig, ifrom + i * istep);
                Array.set(slice, i, ArrayFuncs.sample(efrom, from, size, step, idx + 1));
            }
        }
        return slice;
    }
}

