/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import nom.tam.util.InputReader;
import nom.tam.util.OutputWriter;
import nom.tam.util.RandomAccessFileIO;

class BufferedFileIO
implements InputReader,
OutputWriter,
Flushable,
Closeable {
    protected static final int BYTE_MASK = 255;
    private final RandomAccessFileIO file;
    private long startOfBuf;
    private final byte[] buf;
    private int offset;
    private int end;
    private boolean isModified;
    private boolean writeAhead;

    BufferedFileIO(File f, String mode, int bufferSize) throws IOException {
        this(new RandomFileIO(f, mode), bufferSize);
    }

    BufferedFileIO(RandomAccessFileIO f, int bufferSize) {
        this.file = f;
        this.buf = new byte[bufferSize];
        this.startOfBuf = 0L;
        this.offset = 0;
        this.end = 0;
        this.isModified = false;
        this.writeAhead = false;
    }

    public final synchronized void seek(long newPos) throws IOException {
        if (newPos < 0L) {
            throw new IllegalArgumentException("seek at " + newPos);
        }
        if (newPos <= this.startOfBuf + (long)this.end) {
            this.writeAhead = false;
        } else {
            boolean bl = this.writeAhead = newPos > this.length();
        }
        if (newPos < this.startOfBuf || newPos >= this.startOfBuf + (long)this.end) {
            this.flush();
            this.startOfBuf = newPos;
            this.end = 0;
        }
        this.offset = (int)(newPos - this.startOfBuf);
        this.matchBufferPos();
    }

    public final FileChannel getChannel() {
        return this.file.getChannel();
    }

    public final FileDescriptor getFD() throws IOException {
        return this.file.getFD();
    }

    public final synchronized long getFilePointer() {
        return this.startOfBuf + (long)this.offset;
    }

    private synchronized long getRemaining() throws IOException {
        long n = this.file.length() - this.getFilePointer();
        return n > 0L ? n : 0L;
    }

    private synchronized boolean makeAvailable() throws IOException {
        if (this.offset < this.end) {
            return true;
        }
        if (this.getRemaining() <= 0L) {
            return false;
        }
        this.seek(this.getFilePointer());
        this.end = this.file.read(this.buf, 0, this.buf.length);
        return this.end > 0;
    }

    public final synchronized boolean hasAvailable(int need) throws IOException {
        if (this.end >= this.offset + need) {
            return true;
        }
        return this.file.length() >= this.getFilePointer() + (long)need;
    }

    public final synchronized long length() throws IOException {
        if (this.end > 0) {
            return Math.max(this.file.length(), this.startOfBuf + (long)this.end);
        }
        return this.file.length();
    }

    public synchronized void setLength(long newLength) throws IOException {
        long bufEnd = this.startOfBuf + (long)this.end;
        if (newLength >= this.startOfBuf && newLength < bufEnd) {
            this.end = (int)(newLength - this.startOfBuf);
        } else {
            this.flush();
            this.end = 0;
        }
        if (this.getFilePointer() > newLength) {
            this.seek(newLength);
        }
        this.file.setLength(newLength);
    }

    private synchronized void matchBufferPos() throws IOException {
        this.file.position(this.getFilePointer());
    }

    private synchronized void matchFilePos() throws IOException {
        this.seek(this.file.position());
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.file.close();
        this.startOfBuf = 0L;
        this.offset = 0;
        this.end = 0;
    }

    private synchronized void moveBuffer() throws IOException {
        this.seek(this.getFilePointer());
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.isModified) {
            return;
        }
        if (this.end > 0) {
            this.file.position(this.startOfBuf);
            this.file.write(this.buf, 0, this.end);
        }
        this.isModified = false;
    }

    @Override
    public final synchronized void write(int b) throws IOException {
        if (this.writeAhead) {
            this.setLength(this.getFilePointer());
        }
        if (this.offset >= this.buf.length) {
            this.moveBuffer();
        }
        this.isModified = true;
        this.buf[this.offset++] = (byte)b;
        if (this.offset > this.end) {
            this.end = this.offset;
        }
    }

    @Override
    public final synchronized int read() throws IOException {
        if (!this.makeAvailable()) {
            return -1;
        }
        return this.buf[this.offset++] & 0xFF;
    }

    @Override
    public final synchronized void write(byte[] b, int from, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.writeAhead) {
            this.setLength(this.getFilePointer());
        }
        if (len > 2 * this.buf.length) {
            this.matchBufferPos();
            this.file.write(b, from, len);
            this.matchFilePos();
            return;
        }
        while (len > 0) {
            if (this.offset >= this.buf.length) {
                this.moveBuffer();
            }
            this.isModified = true;
            int n = Math.min(len, this.buf.length - this.offset);
            System.arraycopy(b, from, this.buf, this.offset, n);
            this.offset += n;
            from += n;
            len -= n;
            if (this.offset <= this.end) continue;
            this.end = this.offset;
        }
    }

    @Override
    public final synchronized int read(byte[] b, int from, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        if (len > 2 * this.buf.length) {
            this.matchBufferPos();
            int l = this.file.read(b, from, len);
            this.matchFilePos();
            return l;
        }
        int got = 0;
        while (got < len) {
            if (!this.makeAvailable()) {
                return got > 0 ? got : -1;
            }
            int n = Math.min(len - got, this.end - this.offset);
            System.arraycopy(this.buf, this.offset, b, from, n);
            got += n;
            this.offset += n;
            from += n;
        }
        return got;
    }

    public final synchronized void readFully(byte[] b) throws EOFException, IOException {
        this.readFully(b, 0, b.length);
    }

    public synchronized void readFully(byte[] b, int off, int len) throws EOFException, IOException {
        while (len > 0) {
            int n = this.read(b, off, len);
            if (n < 0) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }

    public final synchronized String readUTF() throws IOException {
        this.matchBufferPos();
        String s = this.file.readUTF();
        this.matchFilePos();
        return s;
    }

    public final synchronized void writeUTF(String s) throws IOException {
        this.matchBufferPos();
        this.file.writeUTF(s);
        this.matchFilePos();
    }

    public final synchronized long skip(long n) throws IOException {
        if ((long)this.offset + n >= 0L && (long)this.offset + n <= (long)this.end) {
            this.offset = (int)((long)this.offset + n);
            return n;
        }
        long pos = this.getFilePointer();
        n = Math.max(n, -pos);
        this.seek(pos + n);
        return n;
    }

    public final synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    static final class RandomFileIO
    extends RandomAccessFile
    implements RandomAccessFileIO {
        RandomFileIO(File file, String mode) throws FileNotFoundException {
            super(file, mode);
        }

        @Override
        public long position() throws IOException {
            return super.getFilePointer();
        }

        @Override
        public void position(long n) throws IOException {
            super.seek(n);
        }
    }
}

