/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import nom.tam.util.ReadWriteAccess;

public class ByteArrayIO
implements ReadWriteAccess {
    private static final int BYTE_MASK = 255;
    private byte[] buf;
    private boolean isGrowable;
    private int pos;
    private int end;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="by design this class provides an IO interface for an accessible array.")
    public ByteArrayIO(byte[] buffer) {
        this.buf = buffer;
        this.end = 0;
        this.isGrowable = false;
    }

    public ByteArrayIO(int initialCapacity) throws IllegalArgumentException {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Illegal buffer size:" + initialCapacity);
        }
        this.buf = new byte[initialCapacity];
        this.end = 0;
        this.isGrowable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteArrayIO copy() {
        ByteArrayIO copy;
        ByteArrayIO byteArrayIO = copy = new ByteArrayIO(Arrays.copyOf(this.buf, this.buf.length));
        synchronized (byteArrayIO) {
            copy.isGrowable = this.isGrowable;
            copy.pos = this.pos;
            copy.end = this.end;
        }
        return copy;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="by design this class provides an IO interface for an accessible array.")
    public synchronized byte[] getBuffer() {
        return this.buf;
    }

    public final synchronized int capacity() {
        return this.buf.length;
    }

    @Override
    public final synchronized long length() {
        return this.end;
    }

    public final synchronized int getRemaining() {
        if (this.pos >= this.end) {
            return 0;
        }
        return this.end - this.pos;
    }

    @Override
    public final synchronized long position() {
        return this.pos;
    }

    @Override
    public synchronized void position(long offset) throws IOException {
        if (offset < 0L) {
            throw new EOFException("Negative buffer index: " + offset);
        }
        if (offset > (long)this.buf.length && !this.isGrowable) {
            throw new EOFException("Position " + offset + " beyond fixed buffer size " + this.buf.length);
        }
        this.pos = (int)offset;
    }

    public synchronized void setLength(int length) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("Buffer set to negative length: " + length);
        }
        if (length > this.capacity()) {
            if (!this.isGrowable) {
                throw new IllegalArgumentException("the new length " + length + " is larger than the fixed capacity " + this.capacity());
            }
            this.grow(length - this.capacity());
        }
        this.end = length;
        if (this.pos > this.end) {
            this.pos = this.end;
        }
    }

    private synchronized void grow(int need) {
        long size = this.capacity() + need;
        long below = Long.highestOneBit(size);
        if (below != size) {
            size = below << 1;
        }
        byte[] newbuf = new byte[(int)Math.min(size, Integer.MAX_VALUE)];
        System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
        this.buf = newbuf;
    }

    @Override
    public final synchronized void write(int b) throws IOException {
        if (this.pos + 1 > this.buf.length) {
            if (!this.isGrowable) {
                throw new EOFException("buffer is full (size=" + this.length() + ")");
            }
            this.grow(this.pos + 1 - this.buf.length);
        }
        this.buf[this.pos++] = (byte)b;
        if (this.pos > this.end) {
            this.end = this.pos;
        }
    }

    @Override
    public final synchronized void write(byte[] b, int from, int length) throws IOException {
        if (length <= 0) {
            return;
        }
        if (this.pos > this.buf.length || this.isGrowable && this.pos + length > this.buf.length) {
            this.grow(this.buf.length + length - this.pos);
        }
        int l = Math.min(length, this.buf.length - this.pos);
        System.arraycopy(b, from, this.buf, this.pos, l);
        this.pos += l;
        if (this.pos > this.end) {
            this.end = this.pos;
        }
        if (l < length) {
            throw new EOFException("Incomplete write of " + l + " of " + length + " bytes in buffer of size " + this.length());
        }
    }

    @Override
    public final synchronized int read() throws IOException {
        if (this.getRemaining() <= 0) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public final synchronized int read(byte[] b, int from, int length) {
        if (length <= 0) {
            return 0;
        }
        int remaining = this.getRemaining();
        if (remaining <= 0) {
            return -1;
        }
        int n = Math.min(remaining, length);
        System.arraycopy(this.buf, this.pos, b, from, n);
        this.pos += n;
        return n;
    }
}

