/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.FormatException;

@Deprecated
public class ByteParser {
    private static final int EXPONENT_DENORMALISATION_CORR_LIMIT = -300;
    private static final double EXPONENT_DENORMALISATION_FACTOR = 1.0E-300;
    private static final byte[] INFINITY_LOWER = AsciiFuncs.getBytes("Infinity".toLowerCase());
    private static final byte[] INFINITY_UPPER = AsciiFuncs.getBytes("Infinity".toUpperCase());
    private static final int INFINITY_LENGTH = INFINITY_UPPER.length;
    private static final int INFINITY_SHORTCUT_LENGTH = 3;
    private static final byte[] NOT_A_NUMBER_LOWER = AsciiFuncs.getBytes("NaN".toLowerCase());
    private static final byte[] NOT_A_NUMBER_UPPER = AsciiFuncs.getBytes("NaN".toUpperCase());
    private static final int NOT_A_NUMBER_LENGTH = NOT_A_NUMBER_UPPER.length;
    private static final int NUMBER_BASE = 10;
    private static final double NUMBER_BASE_DOUBLE = 10.0;
    private boolean foundSign;
    private byte[] input;
    private int numberLength;
    private int offset;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public ByteParser(byte[] input) {
        this.input = input;
        this.offset = 0;
    }

    private int checkSign() {
        this.foundSign = false;
        if (this.input[this.offset] == 43) {
            this.foundSign = true;
            ++this.offset;
            return 1;
        }
        if (this.input[this.offset] == 45) {
            this.foundSign = true;
            ++this.offset;
            return -1;
        }
        return 1;
    }

    private double getBareInteger(int length) {
        int startOffset = this.offset;
        double number = 0.0;
        while (length > 0 && this.input[this.offset] >= 48 && this.input[this.offset] <= 57) {
            number *= 10.0;
            number += (double)(this.input[this.offset] - 48);
            ++this.offset;
            --length;
        }
        this.numberLength = this.offset - startOffset;
        return number;
    }

    public boolean getBoolean() throws FormatException {
        return this.getBoolean(this.input.length - this.offset);
    }

    public boolean getBoolean(int length) throws FormatException {
        int startOffset = this.offset;
        if ((length -= this.skipWhite(length)) == 0) {
            throw new FormatException("Blank boolean field");
        }
        boolean value = false;
        if (this.input[this.offset] == 84 || this.input[this.offset] == 116) {
            value = true;
        } else if (this.input[this.offset] != 70 && this.input[this.offset] != 102) {
            this.numberLength = 0;
            this.offset = startOffset;
            throw new FormatException("Invalid boolean value");
        }
        ++this.offset;
        this.numberLength = this.offset - startOffset;
        return value;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public byte[] getBuffer() {
        return this.input;
    }

    public double getDouble() throws FormatException {
        return this.getDouble(this.input.length - this.offset);
    }

    public double getDouble(int length) throws FormatException {
        double number;
        int startOffset = this.offset;
        boolean error = true;
        if ((length -= this.skipWhite(length)) == 0) {
            this.numberLength = this.offset - startOffset;
            return 0.0;
        }
        double mantissaSign = this.checkSign();
        if (this.foundSign) {
            --length;
        }
        if (this.isCaseInsensitiv(length, NOT_A_NUMBER_LENGTH, NOT_A_NUMBER_LOWER, NOT_A_NUMBER_UPPER)) {
            number = Double.NaN;
            this.offset += NOT_A_NUMBER_LENGTH;
        } else if (this.isCaseInsensitiv(length, INFINITY_LENGTH, INFINITY_LOWER, INFINITY_UPPER)) {
            number = Double.POSITIVE_INFINITY;
            this.offset += INFINITY_LENGTH;
        } else if (this.isCaseInsensitiv(length, 3, INFINITY_LOWER, INFINITY_UPPER)) {
            number = Double.POSITIVE_INFINITY;
            this.offset += 3;
        } else {
            number = this.getBareInteger(length);
            length -= this.numberLength;
            if (this.numberLength > 0) {
                error = false;
            }
            if (length > 0 && this.input[this.offset] == 46) {
                double numerator;
                ++this.offset;
                if ((numerator = this.getBareInteger(--length)) > 0.0) {
                    number += numerator / Math.pow(10.0, this.numberLength);
                }
                length -= this.numberLength;
                if (this.numberLength > 0) {
                    error = false;
                }
            }
            if (error) {
                this.offset = startOffset;
                this.numberLength = 0;
                throw new FormatException("Invalid real field");
            }
            if (length > 0 && (this.input[this.offset] == 101 || this.input[this.offset] == 69 || this.input[this.offset] == 100 || this.input[this.offset] == 68)) {
                ++this.offset;
                if (--length > 0) {
                    int exponent;
                    int sign = this.checkSign();
                    if (this.foundSign) {
                        --length;
                    }
                    number = (exponent = (int)this.getBareInteger(length)) * sign > -300 ? (number *= Math.pow(10.0, exponent * sign)) : 1.0E-300 * (number * Math.pow(10.0, exponent * sign + 300));
                }
            }
        }
        this.numberLength = this.offset - startOffset;
        return mantissaSign * number;
    }

    public float getFloat() throws FormatException {
        return (float)this.getDouble(this.input.length - this.offset);
    }

    public float getFloat(int length) throws FormatException {
        return (float)this.getDouble(length);
    }

    public int getInt() throws FormatException {
        return this.getInt(this.input.length - this.offset);
    }

    public int getInt(int length) throws FormatException {
        int startOffset = this.offset;
        if ((length -= this.skipWhite(length)) == 0) {
            this.numberLength = this.offset - startOffset;
            return 0;
        }
        int number = 0;
        boolean error = true;
        int sign = this.checkSign();
        if (this.foundSign) {
            --length;
        }
        while (length > 0 && this.input[this.offset] >= 48 && this.input[this.offset] <= 57) {
            number = number * 10 + this.input[this.offset] - 48;
            ++this.offset;
            --length;
            error = false;
        }
        if (error) {
            this.numberLength = 0;
            this.offset = startOffset;
            throw new FormatException("Invalid Integer");
        }
        this.numberLength = this.offset - startOffset;
        return sign * number;
    }

    public long getLong(int length) throws FormatException {
        int startOffset = this.offset;
        if ((length -= this.skipWhite(length)) == 0) {
            this.numberLength = this.offset - startOffset;
            return 0L;
        }
        long number = 0L;
        boolean error = true;
        long sign = this.checkSign();
        if (this.foundSign) {
            --length;
        }
        while (length > 0 && this.input[this.offset] >= 48 && this.input[this.offset] <= 57) {
            number = number * 10L + (long)this.input[this.offset] - 48L;
            error = false;
            ++this.offset;
            --length;
        }
        if (error) {
            this.numberLength = 0;
            this.offset = startOffset;
            throw new FormatException("Invalid long number");
        }
        this.numberLength = this.offset - startOffset;
        return sign * number;
    }

    public int getNumberLength() {
        return this.numberLength;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getString(int length) {
        String s = AsciiFuncs.asciiString(this.input, this.offset, length);
        this.offset += length;
        this.numberLength = length;
        return s;
    }

    private boolean isCaseInsensitiv(int length, int constantLength, byte[] lowerConstant, byte[] upperConstant) {
        if (length < constantLength) {
            return false;
        }
        for (int i = 0; i < constantLength; ++i) {
            if (this.input[this.offset + i] == lowerConstant[i] || this.input[this.offset + i] == upperConstant[i]) continue;
            return false;
        }
        return true;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public void setBuffer(byte[] buf) {
        this.input = buf;
        this.offset = 0;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void skip(int nBytes) {
        this.offset += nBytes;
    }

    public int skipWhite(int length) {
        int i;
        for (i = 0; i < length && (this.input[this.offset + i] == 32 || this.input[this.offset + i] == 9 || this.input[this.offset + i] == 10 || this.input[this.offset + i] == 13); ++i) {
        }
        this.offset += i;
        return i;
    }
}

