/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.DataTable;
import nom.tam.util.TableException;
import nom.tam.util.type.ElementType;

public class ColumnTable<T>
implements DataTable,
Cloneable {
    private ArrayList<Column<?>> columns = new ArrayList();
    private int nrow = 0;
    private static final int MIN_CAPACITY = 16;
    private T extraState;

    public ColumnTable() {
    }

    public ColumnTable(Object[] arrays, int[] sizes) throws TableException {
        for (int i = 0; i < arrays.length; ++i) {
            this.addColumn(arrays[i], sizes[i]);
        }
    }

    public final boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public void clear() {
        this.columns.clear();
        this.nrow = 0;
    }

    public void ensureSize(int rows) {
        for (Column<?> c : this.columns) {
            c.ensureSize(rows);
        }
    }

    private int checkWrappedColumn(Object newColumn) throws TableException, NullPointerException {
        if (!(newColumn instanceof Object[])) {
            this.checkFlatColumn(newColumn, 1);
            return 1;
        }
        try {
            int[] dims = ArrayFuncs.checkRegularArray(newColumn, false);
            if (dims.length != 2) {
                throw new TableException("Not a 2D array: " + newColumn.getClass());
            }
        }
        catch (Exception e) {
            throw new TableException(e);
        }
        Object[] entries = (Object[])newColumn;
        if (entries.length == 0) {
            return 0;
        }
        Object first = entries[0];
        if (!first.getClass().getComponentType().isPrimitive()) {
            throw new TableException("Entries are not a primitive arrays: " + first.getClass());
        }
        return Array.getLength(first);
    }

    public void addWrappedColumn(Object newColumn) throws TableException {
        if (newColumn == null) {
            throw new TableException("Cannot add a null column.");
        }
        int eCount = this.checkWrappedColumn(newColumn);
        Class<?> eType = newColumn.getClass().getComponentType();
        if (eType.isArray()) {
            eType = eType.getComponentType();
        }
        Column<?> c = this.createColumn(eType, eCount);
        c.data = newColumn;
        this.nrow = Array.getLength(newColumn);
        this.columns.add(c);
    }

    public void addColumn(Class<?> type, int size) throws TableException {
        this.columns.add(this.createColumn(type, size));
    }

    private Object wrapColumn(Object data, int size) throws TableException {
        this.checkFlatColumn(data, size);
        Class<?> type = data.getClass().getComponentType();
        int len = size == 0 ? this.nrow : Array.getLength(data) / size;
        Object[] array = (Object[])Array.newInstance(data.getClass(), len);
        int offset = 0;
        int i = 0;
        while (i < len) {
            array[i] = Array.newInstance(type, size);
            System.arraycopy(data, offset, array[i], 0, size);
            ++i;
            offset += size;
        }
        return array;
    }

    public void addColumn(Object newColumn, int size) throws TableException {
        if (newColumn == null) {
            throw new TableException("Cannot add a null column: we don't know its type.");
        }
        if (size < 0) {
            throw new TableException("Invalid element size: " + size);
        }
        if (size == 1 && newColumn.getClass().getComponentType().isPrimitive()) {
            this.addWrappedColumn(newColumn);
            return;
        }
        this.checkFlatColumn(newColumn, size);
        Column<?> c = this.createColumn(newColumn.getClass().getComponentType(), size);
        c.data = this.wrapColumn(newColumn, size);
        this.columns.add(c);
        this.nrow = Array.getLength(c.data);
    }

    private int nextLargerCapacity() {
        return this.nextLargerCapacity(this.nrow);
    }

    private int nextLargerCapacity(int rows) {
        if (rows < 16) {
            return 16;
        }
        return (int)Math.min(Long.highestOneBit(rows) << 1, Integer.MAX_VALUE);
    }

    private void checkRow(Object[] row) throws TableException {
        if (row.length != this.columns.size()) {
            throw new TableException("Mismatched row size: " + row.length + ", expected " + this.columns.size());
        }
        for (int col = 0; col < row.length; ++col) {
            Column<?> c = this.columns.get(col);
            c.checkEntry(row[col]);
        }
    }

    public void addRow(Object[] row) throws TableException {
        if (row == null) {
            throw new TableException("Cannot add null row");
        }
        if (this.nrow == Integer.MAX_VALUE) {
            throw new TableException("Table has reached its capacity limit");
        }
        if (this.isEmpty()) {
            try {
                for (int col = 0; col < row.length; ++col) {
                    this.addColumn(row[col], Array.getLength(row[col]));
                }
                return;
            }
            catch (TableException e) {
                this.columns = new ArrayList();
                throw e;
            }
        }
        this.checkRow(row);
        int capacity = this.nextLargerCapacity();
        for (int i = 0; i < row.length; ++i) {
            Column<?> c = this.columns.get(i);
            c.ensureSize(capacity);
            c.checkEntry(row[i]);
            c.setArrayElement(this.nrow, row[i]);
        }
        ++this.nrow;
    }

    private void checkFlatColumn(Object data, int size) throws TableException {
        if (!data.getClass().isArray()) {
            throw new TableException("Argument is not an array: " + data.getClass());
        }
        int len = Array.getLength(data);
        if (size > 0 && len % size != 0) {
            throw new TableException("The column size " + len + " is not a multiple of the element size " + size);
        }
        if (this.nrow == 0 || size == 0) {
            return;
        }
        if (len != this.nrow * size) {
            throw new TableException("Mismatched element count: " + len + ", expected " + this.nrow * size + " for " + this.nrow + " rows of size " + size);
        }
    }

    protected ColumnTable<T> clone() {
        try {
            return (ColumnTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public ColumnTable<T> copy() throws TableException {
        Object copy = this.clone();
        ((ColumnTable)copy).columns = new ArrayList(this.columns.size());
        for (Column<?> c : this.columns) {
            ((ColumnTable)copy).columns.add(c.copy(this.nrow));
        }
        return copy;
    }

    public void deleteColumn(int col) throws TableException {
        if (col < 0 || col >= this.columns.size()) {
            throw new TableException("Column out of bounds: col=" + col + ", size=" + this.columns.size());
        }
        this.columns.remove(col);
        if (this.isEmpty()) {
            this.nrow = 0;
        }
    }

    public void deleteColumns(int start, int len) throws TableException {
        int i;
        if (len == 0) {
            return;
        }
        if (start < 0 || len < 0 || start + len > this.columns.size()) {
            throw new TableException("Column eange out of bounds: start=" + start + ", len=" + len + ", size=" + this.columns.size());
        }
        ArrayList c = new ArrayList();
        for (i = 0; i < start; ++i) {
            c.add(this.columns.get(i));
        }
        i += len;
        while (i < this.columns.size()) {
            c.add(this.columns.get(i));
            ++i;
        }
        this.columns = c;
        if (this.isEmpty()) {
            this.nrow = 0;
        }
    }

    public final void deleteAllRows() throws TableException {
        this.nrow = 0;
        for (Column<?> c : this.columns) {
            c.trim(16);
        }
    }

    public final void deleteRow(int row) throws TableException {
        this.deleteRows(row, 1);
    }

    public void deleteRows(int from, int length) throws TableException {
        if (length == 0) {
            return;
        }
        if (from < 0 || length < 0 || from + length > this.nrow) {
            throw new TableException("Row range out of bounds: start=" + from + ", len=" + length + ", size=" + this.nrow);
        }
        int maxSize = this.nextLargerCapacity(this.nrow - length);
        for (Column<?> c : this.columns) {
            c.deleteRows(from, length, this.nrow, maxSize);
        }
        this.nrow -= length;
    }

    public final Class<?> getElementClass(int col) {
        return this.columns.get(col).baseType();
    }

    public Class<?>[] getBases() {
        Class[] bases = new Class[this.columns.size()];
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = this.getElementClass(i);
        }
        return bases;
    }

    public Object getWrappedColumn(int col) {
        Column<?> c = this.columns.get(col);
        c.trim(this.nrow);
        return c.getData();
    }

    @Override
    public Object getColumn(int col) {
        Column<?> c = this.columns.get(col);
        c.trim(this.nrow);
        return c.getFlatData();
    }

    public Object[] getColumns() {
        Object[] table = new Object[this.columns.size()];
        for (int i = 0; i < table.length; ++i) {
            table[i] = this.getColumn(i);
        }
        return table;
    }

    @Override
    public Object getElement(int row, int col) {
        if (row < 0 || row >= this.nrow) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        return this.columns.get(col).getArrayElement(row);
    }

    public T getExtraState() {
        return this.extraState;
    }

    @Override
    public final int getNCols() {
        return this.columns.size();
    }

    @Override
    public final int getNRows() {
        return this.nrow;
    }

    @Override
    public Object getRow(int row) {
        if (row < 0 || row >= this.nrow) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        Object[] x = new Object[this.columns.size()];
        for (int col = 0; col < x.length; ++col) {
            x[col] = this.getElement(row, col);
        }
        return x;
    }

    public final int getElementSize(int col) {
        return this.columns.get(col).elementCount();
    }

    public int[] getSizes() {
        int[] sizes = new int[this.columns.size()];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = this.getElementSize(i);
        }
        return sizes;
    }

    public final char getTypeChar(int col) {
        return this.columns.get(col).getElementType().type();
    }

    public char[] getTypes() {
        char[] types = new char[this.columns.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getTypeChar(i);
        }
        return types;
    }

    public void read(ArrayDataInput in) throws EOFException, IOException {
        for (int row = 0; row < this.nrow; ++row) {
            for (Column<?> c : this.columns) {
                c.read(row, in);
            }
        }
    }

    @Override
    public void setColumn(int col, Object newColumn) throws TableException {
        if (newColumn == null) {
            throw new TableException("Cannot set column data to null");
        }
        if (!newColumn.getClass().isArray()) {
            throw new TableException("Not an array: " + newColumn.getClass().getName());
        }
        Column<?> c = this.columns.get(col);
        if (!c.baseType().equals(newColumn.getClass().getComponentType())) {
            throw new TableException("Mismatched type " + newColumn.getClass().getName() + ", expected " + c.baseType().getName());
        }
        if (Array.getLength(newColumn) != this.nrow * c.elementCount()) {
            throw new TableException("Mismatched size " + Array.getLength(newColumn) + ", expected " + this.nrow * c.elementCount());
        }
        c.data = c.elementCount() > 1 ? this.wrapColumn(newColumn, c.elementCount()) : newColumn;
    }

    public void setWrappedColumn(int col, Object newColumn) throws TableException {
        if (!newColumn.getClass().isArray()) {
            throw new TableException("Not an array: " + newColumn.getClass().getName());
        }
        if (Array.getLength(newColumn) != this.nrow) {
            throw new TableException("Mismatched row count " + Array.getLength(newColumn) + ", expected " + this.nrow);
        }
        Column<?> c = this.columns.get(col);
        int eSize = 0;
        try {
            eSize = this.checkWrappedColumn(newColumn);
        }
        catch (Exception e) {
            throw new TableException(e);
        }
        if (eSize != c.elementCount()) {
            throw new TableException("Mismatched element size " + eSize + ", expected " + c.elementCount());
        }
        Class<?> eType = newColumn.getClass().getComponentType();
        if (newColumn instanceof Object[]) {
            eType = eType.getComponentType();
        }
        if (!c.baseType().equals(eType)) {
            throw new TableException("Mismatched type " + newColumn.getClass().getName() + ", expected " + c.baseType().getName());
        }
        c.data = newColumn;
    }

    @Override
    public void setElement(int row, int col, Object x) throws TableException {
        if (row < 0 || row >= this.nrow) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        Column<?> c = this.columns.get(col);
        c.checkEntry(x);
        c.setArrayElement(row, x);
    }

    public void setExtraState(T opaque) {
        this.extraState = opaque;
    }

    @Override
    public void setRow(int row, Object data) throws TableException {
        if (row < 0 || row >= this.nrow) {
            throw new ArrayIndexOutOfBoundsException(row);
        }
        if (data == null) {
            throw new TableException("Unexpected null data for row " + row);
        }
        if (!(data instanceof Object[])) {
            throw new TableException("Not an Object[] array: " + data.getClass().getName());
        }
        Object[] r = (Object[])data;
        this.checkRow(r);
        for (int i = 0; i < this.columns.size(); ++i) {
            Column<?> c = this.columns.get(i);
            c.checkEntry(r[i]);
            c.setArrayElement(row, r[i]);
        }
    }

    public void write(ArrayDataOutput out) throws IOException {
        for (int row = 0; row < this.nrow; ++row) {
            for (Column<?> c : this.columns) {
                c.write(row, out);
            }
        }
    }

    public void write(ArrayDataOutput out, int rowStart, int rowEnd, int col) throws IOException {
        this.columns.get(col).write(rowStart, rowEnd - rowStart, out);
    }

    public void read(ArrayDataInput in, int rowStart, int rowEnd, int col) throws EOFException, IOException {
        this.columns.get(col).read(rowStart, rowEnd - rowStart, in);
    }

    private Column<?> createColumn(Class<?> type, int size) throws TableException {
        if (type == null) {
            throw new TableException("Column type cannot be null.");
        }
        if (!type.isPrimitive()) {
            throw new TableException("Not a primitive base type: " + type.getName());
        }
        if (size == 1) {
            if (type.equals(Byte.TYPE)) {
                return new Bytes();
            }
            if (type.equals(Boolean.TYPE)) {
                return new Booleans();
            }
            if (type.equals(Character.TYPE)) {
                return new Chars();
            }
            if (type.equals(Short.TYPE)) {
                return new Shorts();
            }
            if (type.equals(Integer.TYPE)) {
                return new Integers();
            }
            if (type.equals(Long.TYPE)) {
                return new Longs();
            }
            if (type.equals(Float.TYPE)) {
                return new Floats();
            }
            if (type.equals(Double.TYPE)) {
                return new Doubles();
            }
        }
        return new Generic(type, size);
    }

    private static abstract class Column<Data>
    implements Cloneable {
        protected Data data;
        private ElementType<?> fitsType;

        Column(ElementType<?> fitsType) {
            this.fitsType = fitsType;
            this.init(fitsType.primitiveClass());
        }

        void init(Class<?> storeType) {
            this.data = Array.newInstance(storeType, 0);
        }

        Data getData() {
            return this.data;
        }

        Object getFlatData() {
            return this.data;
        }

        ElementType<?> getElementType() {
            return this.fitsType;
        }

        Class<?> baseType() {
            return this.fitsType.primitiveClass();
        }

        Class<?> arrayType() {
            return this.data.getClass();
        }

        int elementCount() {
            return 1;
        }

        int capacity() {
            return Array.getLength(this.data);
        }

        void deleteRows(int from, int len, int size, int maxCapacity) {
            int end = from + len;
            System.arraycopy(this.data, end, this.data, from, size - end);
            this.trim(maxCapacity);
        }

        abstract int read(int var1, ArrayDataInput var2) throws EOFException, IOException;

        abstract void write(int var1, ArrayDataOutput var2) throws IOException;

        abstract int read(int var1, int var2, ArrayDataInput var3) throws EOFException, IOException;

        abstract void write(int var1, int var2, ArrayDataOutput var3) throws IOException;

        void checkEntry(Object x) throws TableException {
            if (x == null) {
                throw new TableException("Unexpected null element");
            }
            if (!this.baseType().equals(x.getClass().getComponentType())) {
                throw new TableException("Incompatible element type: " + x.getClass().getName() + ", expected " + this.arrayType());
            }
            if (Array.getLength(x) != this.elementCount()) {
                throw new TableException("Incompatible element size: " + Array.getLength(x) + ", expected " + this.elementCount());
            }
        }

        abstract Object getArrayElement(int var1);

        abstract void setArrayElement(int var1, Object var2);

        abstract void resize(int var1);

        void ensureSize(int size) {
            if (size > this.capacity()) {
                this.resize(size);
            }
        }

        void trim(int size) {
            if (this.capacity() > size) {
                this.resize(size);
            }
        }

        protected Column<Data> clone() {
            try {
                return (Column)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        Data copyData(int length) {
            Object copy = Array.newInstance(this.baseType(), length);
            System.arraycopy(this.data, 0, copy, 0, Math.min(length, Array.getLength(this.data)));
            return (Data)copy;
        }

        Column<Data> copy(int size) {
            Object c = this.clone();
            ((Column)c).data = this.copyData(size);
            return c;
        }
    }

    private static class Bytes
    extends Column<byte[]> {
        Bytes() {
            super(ElementType.BYTE);
        }

        @Override
        void resize(int size) {
            this.data = Arrays.copyOf((byte[])this.data, size);
        }

        @Override
        int read(int index, ArrayDataInput in) throws IOException {
            int i = in.read();
            if (i < 0) {
                throw new EOFException();
            }
            ((byte[])this.data)[index] = (byte)i;
            return 1;
        }

        @Override
        void write(int index, ArrayDataOutput out) throws IOException {
            out.write(((byte[])this.data)[index]);
        }

        @Override
        int read(int from, int n, ArrayDataInput in) throws IOException {
            int got = in.read((byte[])this.data, from, n);
            if (got < 0) {
                throw new EOFException();
            }
            return -1;
        }

        @Override
        void write(int from, int n, ArrayDataOutput out) throws IOException {
            out.write((byte[])this.data, from, n);
        }

        byte[] getArrayElement(int i) {
            return new byte[]{((byte[])this.data)[i]};
        }

        @Override
        void setArrayElement(int i, Object o) {
            ((byte[])this.data)[i] = ((byte[])o)[0];
        }
    }

    private static class Booleans
    extends Column<boolean[]> {
        Booleans() {
            super(ElementType.BOOLEAN);
        }

        @Override
        void resize(int size) {
            this.data = Arrays.copyOf((boolean[])this.data, size);
        }

        @Override
        int read(int index, ArrayDataInput in) throws IOException {
            ((boolean[])this.data)[index] = in.readBoolean();
            return 1;
        }

        @Override
        void write(int index, ArrayDataOutput out) throws IOException {
            out.writeBoolean(((boolean[])this.data)[index]);
        }

        @Override
        int read(int from, int n, ArrayDataInput in) throws IOException {
            return in.read((boolean[])this.data, from, n);
        }

        @Override
        void write(int from, int n, ArrayDataOutput out) throws IOException {
            out.write((boolean[])this.data, from, n);
        }

        boolean[] getArrayElement(int i) {
            return new boolean[]{((boolean[])this.data)[i]};
        }

        @Override
        void setArrayElement(int i, Object o) {
            ((boolean[])this.data)[i] = ((boolean[])o)[0];
        }
    }

    private static class Chars
    extends Column<char[]> {
        Chars() {
            super(ElementType.CHAR);
        }

        @Override
        void resize(int size) {
            this.data = Arrays.copyOf((char[])this.data, size);
        }

        @Override
        int read(int index, ArrayDataInput in) throws IOException {
            ((char[])this.data)[index] = in.readChar();
            return ElementType.CHAR.size();
        }

        @Override
        void write(int index, ArrayDataOutput out) throws IOException {
            out.writeChar(((char[])this.data)[index]);
        }

        @Override
        @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="not exposed and never needed locally")
        int read(int from, int n, ArrayDataInput in) throws IOException {
            return in.read((char[])this.data, from, n);
        }

        @Override
        void write(int from, int n, ArrayDataOutput out) throws IOException {
            out.write((char[])this.data, from, n);
        }

        char[] getArrayElement(int i) {
            return new char[]{((char[])this.data)[i]};
        }

        @Override
        void setArrayElement(int i, Object o) {
            ((char[])this.data)[i] = ((char[])o)[0];
        }
    }

    private static class Shorts
    extends Column<short[]> {
        Shorts() {
            super(ElementType.SHORT);
        }

        @Override
        void resize(int size) {
            this.data = Arrays.copyOf((short[])this.data, size);
        }

        @Override
        int read(int index, ArrayDataInput in) throws IOException {
            int i = in.readUnsignedShort();
            if (i < 0) {
                throw new EOFException();
            }
            ((short[])this.data)[index] = (short)i;
            return 2;
        }

        @Override
        void write(int index, ArrayDataOutput out) throws IOException {
            out.writeShort(((short[])this.data)[index]);
        }

        @Override
        @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="not exposed and never needed locally")
        int read(int from, int n, ArrayDataInput in) throws IOException {
            return in.read((short[])this.data, from, n);
        }

        @Override
        void write(int from, int n, ArrayDataOutput out) throws IOException {
            out.write((short[])this.data, from, n);
        }

        short[] getArrayElement(int i) {
            return new short[]{((short[])this.data)[i]};
        }

        @Override
        void setArrayElement(int i, Object o) {
            ((short[])this.data)[i] = ((short[])o)[0];
        }
    }

    private static class Integers
    extends Column<int[]> {
        Integers() {
            super(ElementType.INT);
        }

        @Override
        void resize(int size) {
            this.data = Arrays.copyOf((int[])this.data, size);
        }

        @Override
        int read(int index, ArrayDataInput in) throws IOException {
            ((int[])this.data)[index] = in.readInt();
            return 4;
        }

        @Override
        void write(int index, ArrayDataOutput out) throws IOException {
            out.writeInt(((int[])this.data)[index]);
        }

        @Override
        int read(int from, int n, ArrayDataInput in) throws IOException {
            return in.read((int[])this.data, from, n);
        }

        @Override
        void write(int from, int n, ArrayDataOutput out) throws IOException {
            out.write((int[])this.data, from, n);
        }

        int[] getArrayElement(int i) {
            return new int[]{((int[])this.data)[i]};
        }

        @Override
        void setArrayElement(int i, Object o) {
            ((int[])this.data)[i] = ((int[])o)[0];
        }
    }

    private static class Longs
    extends Column<long[]> {
        Longs() {
            super(ElementType.LONG);
        }

        @Override
        void resize(int size) {
            this.data = Arrays.copyOf((long[])this.data, size);
        }

        @Override
        int read(int index, ArrayDataInput in) throws IOException {
            ((long[])this.data)[index] = in.readLong();
            return 8;
        }

        @Override
        void write(int index, ArrayDataOutput out) throws IOException {
            out.writeLong(((long[])this.data)[index]);
        }

        @Override
        int read(int from, int n, ArrayDataInput in) throws IOException {
            return in.read((long[])this.data, from, n);
        }

        @Override
        void write(int from, int n, ArrayDataOutput out) throws IOException {
            out.write((long[])this.data, from, n);
        }

        long[] getArrayElement(int i) {
            return new long[]{((long[])this.data)[i]};
        }

        @Override
        void setArrayElement(int i, Object o) {
            ((long[])this.data)[i] = ((long[])o)[0];
        }
    }

    private static class Floats
    extends Column<float[]> {
        Floats() {
            super(ElementType.FLOAT);
        }

        @Override
        void resize(int size) {
            this.data = Arrays.copyOf((float[])this.data, size);
        }

        @Override
        int read(int index, ArrayDataInput in) throws IOException {
            ((float[])this.data)[index] = in.readFloat();
            return 4;
        }

        @Override
        void write(int index, ArrayDataOutput out) throws IOException {
            out.writeFloat(((float[])this.data)[index]);
        }

        @Override
        int read(int from, int n, ArrayDataInput in) throws IOException {
            return in.read((float[])this.data, from, n);
        }

        @Override
        void write(int from, int n, ArrayDataOutput out) throws IOException {
            out.write((float[])this.data, from, n);
        }

        float[] getArrayElement(int i) {
            return new float[]{((float[])this.data)[i]};
        }

        @Override
        void setArrayElement(int i, Object o) {
            ((float[])this.data)[i] = ((float[])o)[0];
        }
    }

    private static class Doubles
    extends Column<double[]> {
        Doubles() {
            super(ElementType.DOUBLE);
        }

        @Override
        void resize(int size) {
            this.data = Arrays.copyOf((double[])this.data, size);
        }

        @Override
        int read(int index, ArrayDataInput in) throws IOException {
            ((double[])this.data)[index] = in.readDouble();
            return 8;
        }

        @Override
        void write(int index, ArrayDataOutput out) throws IOException {
            out.writeDouble(((double[])this.data)[index]);
        }

        @Override
        int read(int from, int n, ArrayDataInput in) throws IOException {
            return in.read((double[])this.data, from, n);
        }

        @Override
        void write(int from, int n, ArrayDataOutput out) throws IOException {
            out.write((double[])this.data, from, n);
        }

        double[] getArrayElement(int i) {
            return new double[]{((double[])this.data)[i]};
        }

        @Override
        void setArrayElement(int i, Object o) {
            ((double[])this.data)[i] = ((double[])o)[0];
        }
    }

    private static class Generic
    extends Column<Object[]> {
        private Class<?> type;
        private int size;

        Generic(Class<?> type, int size) {
            super(ElementType.forClass(type));
            this.type = type;
            this.size = size;
        }

        @Override
        void init(Class<?> storeType) {
            this.data = (Object[])Array.newInstance(storeType, 0, 0);
        }

        @Override
        int elementCount() {
            return this.size;
        }

        @Override
        void resize(int newSize) {
            this.data = Arrays.copyOf((Object[])this.data, newSize);
        }

        @Override
        int read(int index, ArrayDataInput in) throws IOException {
            in.readArrayFully(((Object[])this.data)[index]);
            return this.size * this.getElementType().size();
        }

        @Override
        void write(int index, ArrayDataOutput out) throws IOException {
            out.writeArray(((Object[])this.data)[index]);
        }

        @Override
        int read(int from, int n, ArrayDataInput in) throws IOException {
            int to = from + n;
            for (int i = from; i < to; ++i) {
                in.readArrayFully(((Object[])this.data)[i]);
            }
            return n * this.size * this.getElementType().size();
        }

        @Override
        void write(int from, int n, ArrayDataOutput out) throws IOException {
            int to = from + n;
            for (int i = from; i < to; ++i) {
                out.writeArray(((Object[])this.data)[i]);
            }
        }

        @Override
        Object getArrayElement(int i) {
            return ((Object[])this.data)[i];
        }

        @Override
        void setArrayElement(int i, Object o) {
            ((Object[])this.data)[i] = o;
        }

        @Override
        Object[] copyData(int length) {
            Object[] array = Arrays.copyOf((Object[])this.data, length);
            for (int i = 0; i < length; ++i) {
                array[i] = Array.newInstance(this.type, this.size);
                System.arraycopy(((Object[])this.data)[i], 0, array[i], 0, this.size);
            }
            return array;
        }

        @Override
        Object getFlatData() {
            Object array = Array.newInstance(this.type, ((Object[])this.data).length * this.size);
            int offset = 0;
            int i = 0;
            while (i < ((Object[])this.data).length) {
                System.arraycopy(((Object[])this.data)[i], 0, array, offset, this.size);
                ++i;
                offset += this.size;
            }
            return array;
        }
    }
}

