/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.util.StringTokenizer;
import java.util.logging.Logger;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.LongValueException;
import nom.tam.util.FlexFormat;

public class ComplexValue {
    private static final Logger LOG = Logger.getLogger(ComplexValue.class.getName());
    public static final ComplexValue ZERO = new ComplexValue(0.0, 0.0);
    public static final ComplexValue ONE = new ComplexValue(1.0, 0.0);
    public static final ComplexValue I = new ComplexValue(0.0, 1.0);
    private double re;
    private double im;
    private static final int MIN_STRING_LENGTH = 5;

    private ComplexValue() {
    }

    public ComplexValue(double re, double im) {
        this();
        this.re = re;
        this.im = im;
    }

    public final double re() {
        return this.re;
    }

    public final double im() {
        return this.im;
    }

    public int hashCode() {
        return Double.hashCode(this.re()) ^ Double.hashCode(this.im());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComplexValue)) {
            return false;
        }
        ComplexValue z = (ComplexValue)o;
        return z.re() == this.re() && z.im() == this.im();
    }

    public final boolean isZero() {
        return this.re() == 0.0 && this.im() == 0.0;
    }

    public final boolean isFinite() {
        return Double.isFinite(this.re()) && Double.isFinite(this.im());
    }

    public String toString() {
        return "(" + this.re() + "," + this.im() + ")";
    }

    public String toString(int decimals) {
        FlexFormat f = new FlexFormat().setPrecision(decimals);
        return "(" + f.format(this.re()) + "," + f.format(this.im()) + ")";
    }

    public ComplexValue(String text) throws IllegalArgumentException {
        this();
        int end;
        int start;
        StringTokenizer tokens;
        boolean hasClosingBracket;
        text = text.trim().toUpperCase().replace('D', 'E');
        boolean hasOpeningBracket = text.charAt(0) == '(';
        boolean bl = hasClosingBracket = text.charAt(text.length() - 1) == ')';
        if (!hasOpeningBracket && !hasClosingBracket) {
            this.re = Double.parseDouble(text);
            return;
        }
        if (!hasOpeningBracket || !hasClosingBracket) {
            if (!FitsFactory.isAllowHeaderRepairs()) {
                throw new IllegalArgumentException("Missing bracket around complex value: '" + text + "'\n\n --> Try FitsFactory.setAllowHeaderRepair(true).\n");
            }
            LOG.warning("Ignored missing bracket in '" + text + "'.");
        }
        if ((tokens = new StringTokenizer(text.substring(start = hasOpeningBracket ? 1 : 0, end = hasClosingBracket ? text.length() - 1 : text.length()), FitsFactory.isAllowHeaderRepairs() ? ",; \t" : ", ")).countTokens() != 2) {
            if (!FitsFactory.isAllowHeaderRepairs()) {
                throw new IllegalArgumentException("Invalid complex value: '" + text + "'\n\n --> Try FitsFactory.setAllowHeaderRepair(true).\n");
            }
            LOG.warning("Ignored wrong number of components (" + tokens.countTokens() + ") in '" + text + "'.");
        }
        if (tokens.hasMoreTokens()) {
            this.re = Double.parseDouble(tokens.nextToken());
        }
        if (tokens.hasMoreTokens()) {
            this.im = Double.parseDouble(tokens.nextToken());
        }
    }

    public String toBoundedString(int maxLength) throws LongValueException {
        if (maxLength < 5) {
            throw new LongValueException(maxLength, this.toString());
        }
        String s = this.toString();
        if (s.length() <= maxLength) {
            return s;
        }
        int decimals = 16;
        s = this.toString(decimals);
        while (s.length() > maxLength) {
            if ((decimals -= (s.length() - maxLength + 1) / 2) < 0) {
                throw new LongValueException(maxLength, this.toString());
            }
            s = this.toString(decimals);
        }
        return s;
    }

    Object toArray() {
        return new double[]{this.re, this.im};
    }

    public static final class Float
    extends ComplexValue {
        public Float(float re, float im) {
            super(re, im);
        }

        public Float(String str) throws IllegalArgumentException {
            super(str);
        }

        @Override
        Object toArray() {
            return new float[]{(float)this.re(), (float)this.im()};
        }
    }
}

