/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import nom.tam.fits.FitsFactory;
import nom.tam.util.InputDecoder;
import nom.tam.util.InputReader;
import nom.tam.util.type.ElementType;

public class FitsDecoder
extends InputDecoder {
    private static final byte FITS_TRUE = 84;

    protected FitsDecoder() {
    }

    public FitsDecoder(InputReader i) {
        super(i);
    }

    public static final boolean booleanFor(int c) {
        return c == 84 || c == 1;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="null values are explicitly allowed by FITS, so we want to support them.")
    public static final Boolean booleanObjectFor(int c) {
        if (c == 0) {
            return null;
        }
        return FitsDecoder.booleanFor(c);
    }

    @Deprecated
    protected synchronized boolean readBoolean() throws EOFException, IOException {
        return FitsDecoder.booleanFor(this.readByte());
    }

    @Deprecated
    protected synchronized char readChar() throws EOFException, IOException {
        int b;
        int n = b = FitsFactory.isUseUnicodeChars() ? this.readUnsignedShort() : this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (char)b;
    }

    @Deprecated
    protected final byte readByte() throws IOException {
        int i = this.read();
        if (i < 0) {
            throw new EOFException();
        }
        return (byte)i;
    }

    @Deprecated
    protected synchronized int readUnsignedByte() throws IOException {
        return this.read();
    }

    @Deprecated
    protected final short readShort() throws EOFException, IOException {
        int i = this.readUnsignedShort();
        if (i < 0) {
            throw new EOFException();
        }
        return (short)i;
    }

    @Deprecated
    protected synchronized int readUnsignedShort() throws IOException {
        this.getInputBuffer().loadOne(2);
        return this.getInputBuffer().getUnsignedShort();
    }

    @Deprecated
    protected synchronized int readInt() throws EOFException, IOException {
        this.getInputBuffer().loadOne(4);
        return this.getInputBuffer().getInt();
    }

    @Deprecated
    protected synchronized long readLong() throws EOFException, IOException {
        this.getInputBuffer().loadOne(8);
        return this.getInputBuffer().getLong();
    }

    @Deprecated
    protected synchronized float readFloat() throws EOFException, IOException {
        this.getInputBuffer().loadOne(4);
        return this.getInputBuffer().getFloat();
    }

    @Deprecated
    protected synchronized double readDouble() throws EOFException, IOException {
        this.getInputBuffer().loadOne(8);
        return this.getInputBuffer().getDouble();
    }

    @Deprecated
    protected synchronized String readAsciiLine() throws EOFException, IOException {
        StringBuffer str = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.read()) < 0) {
                if (str.length() > 0) break;
                throw new EOFException();
            }
            if (c == 10) break;
            str.append((char)c);
        }
        return new String(str);
    }

    protected synchronized int read(boolean[] b, int start, int length) throws EOFException, IOException {
        if (length == 0) {
            return 0;
        }
        byte[] ascii = new byte[length];
        if ((length = this.read(ascii, 0, length)) < 0) {
            throw new EOFException();
        }
        for (int i = 0; i < length; ++i) {
            b[start + i] = FitsDecoder.booleanFor(ascii[i]);
        }
        return length;
    }

    protected synchronized int read(Boolean[] b, int start, int length) throws EOFException, IOException {
        if (length == 0) {
            return 0;
        }
        byte[] ascii = new byte[length];
        if ((length = this.read(ascii, 0, length)) < 0) {
            throw new EOFException();
        }
        for (int i = 0; i < length; ++i) {
            b[start + i] = FitsDecoder.booleanObjectFor(ascii[i]);
        }
        return length;
    }

    protected synchronized int read(char[] c, int start, int length) throws EOFException, IOException {
        if (length == 0) {
            return 0;
        }
        if (ElementType.CHAR.size() == 1) {
            byte[] ascii = new byte[length];
            if ((length = this.read(ascii, 0, length)) < 0) {
                throw new EOFException();
            }
            for (int i = 0; i < length; ++i) {
                c[start + i] = (char)(ascii[i] & 0xFF);
            }
        } else {
            this.getInputBuffer().loadBytes(length, 2);
            short[] s = new short[length];
            length = this.getInputBuffer().get(s, 0, length);
            for (int i = 0; i < length; ++i) {
                c[start + i] = (char)(s[i] & 0xFFFF);
            }
        }
        return length * ElementType.CHAR.size();
    }

    protected synchronized int read(short[] s, int start, int length) throws EOFException, IOException {
        this.getInputBuffer().loadBytes(length, 2);
        return this.getInputBuffer().get(s, start, length) * 2;
    }

    protected synchronized int read(int[] j, int start, int length) throws EOFException, IOException {
        this.getInputBuffer().loadBytes(length, 4);
        return this.getInputBuffer().get(j, start, length) * 4;
    }

    protected synchronized int read(long[] l, int start, int length) throws EOFException, IOException {
        this.getInputBuffer().loadBytes(length, 8);
        return this.getInputBuffer().get(l, start, length) * 8;
    }

    protected synchronized int read(float[] f, int start, int length) throws EOFException, IOException {
        this.getInputBuffer().loadBytes(length, 4);
        return this.getInputBuffer().get(f, start, length) * 4;
    }

    protected synchronized int read(double[] d, int start, int length) throws EOFException, IOException {
        this.getInputBuffer().loadBytes(length, 8);
        return this.getInputBuffer().get(d, start, length) * 8;
    }

    @Override
    public synchronized long readArray(Object o) throws IOException, IllegalArgumentException {
        if (o == null) {
            return 0L;
        }
        if (!o.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array: " + o.getClass().getName());
        }
        int length = Array.getLength(o);
        if (length == 0) {
            return 0L;
        }
        if (o instanceof byte[]) {
            this.readFully((byte[])o, 0, length);
            return length;
        }
        if (o instanceof boolean[]) {
            return this.read((boolean[])o, 0, length);
        }
        if (o instanceof char[]) {
            return this.read((char[])o, 0, length);
        }
        if (o instanceof short[]) {
            return this.read((short[])o, 0, length);
        }
        if (o instanceof int[]) {
            return this.read((int[])o, 0, length);
        }
        if (o instanceof float[]) {
            return this.read((float[])o, 0, length);
        }
        if (o instanceof long[]) {
            return this.read((long[])o, 0, length);
        }
        if (o instanceof double[]) {
            return this.read((double[])o, 0, length);
        }
        if (o instanceof Boolean[]) {
            return this.read((Boolean[])o, 0, length);
        }
        Object[] array = (Object[])o;
        long count = 0L;
        for (int i = 0; i < length; ++i) {
            try {
                count += this.readArray(array[i]);
                continue;
            }
            catch (EOFException e) {
                return this.eofCheck(e, count, -1L);
            }
        }
        return count;
    }
}

