/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsFactory;
import nom.tam.util.ComplexValue;
import nom.tam.util.OutputEncoder;
import nom.tam.util.OutputWriter;
import nom.tam.util.type.ElementType;

public class FitsEncoder
extends OutputEncoder {
    private static final Logger LOG = Logger.getLogger(FitsEncoder.class.getName());
    private static final byte BYTE_TRUE = 84;
    private static final byte BYTE_FALSE = 70;

    protected FitsEncoder() {
    }

    public FitsEncoder(OutputWriter o) {
        super(o);
    }

    public static byte byteForBoolean(Boolean b) {
        if (b == null) {
            return 0;
        }
        return b != false ? (byte)84 : 70;
    }

    @Deprecated
    protected synchronized void writeBoolean(Boolean b) throws IOException {
        this.write(FitsEncoder.byteForBoolean(b));
    }

    @Deprecated
    protected synchronized void writeChar(int c) throws IOException {
        if (FitsFactory.isUseUnicodeChars()) {
            this.writeShort((short)c);
        } else {
            this.write(c & 0xFF);
        }
    }

    private void put(boolean[] b, int start, int length) throws IOException {
        if (length == 1) {
            this.write(FitsEncoder.byteForBoolean(b[start]));
            return;
        }
        byte[] ascii = new byte[length];
        for (int i = 0; i < length; ++i) {
            ascii[i] = FitsEncoder.byteForBoolean(b[start + i]);
        }
        this.write(ascii, 0, length);
    }

    private void put(Boolean[] b, int start, int length) throws IOException {
        if (length == 1) {
            this.write(FitsEncoder.byteForBoolean(b[start]));
            return;
        }
        byte[] ascii = new byte[length];
        for (int i = 0; i < length; ++i) {
            ascii[i] = FitsEncoder.byteForBoolean(b[start + i]);
        }
        this.write(ascii, 0, length);
    }

    private void put(char[] c, int start, int length) throws IOException {
        if (length == 1) {
            if (ElementType.CHAR.size() == 1) {
                this.write((byte)c[start]);
            } else {
                this.getOutputBuffer().putShort((short)c[start]);
            }
            return;
        }
        if (ElementType.CHAR.size() == 1) {
            byte[] ascii = new byte[length];
            for (int i = 0; i < length; ++i) {
                ascii[i] = (byte)c[start + i];
            }
            this.write(ascii, 0, length);
        } else {
            short[] s = new short[length];
            for (int i = 0; i < length; ++i) {
                s[i] = (short)c[start + i];
            }
            this.getOutputBuffer().put(s, 0, length);
        }
    }

    private void put(String[] str, int start, int length) throws IOException {
        length += start;
        while (start < length) {
            this.put(str[start++]);
        }
    }

    void put(String str) throws IOException {
        OutputEncoder.OutputBuffer out = this.getOutputBuffer();
        for (int i = 0; i < str.length(); ++i) {
            out.putByte((byte)str.charAt(i));
        }
    }

    protected synchronized void write(boolean[] b, int start, int length) throws IOException {
        this.put(b, start, length);
        this.flush();
    }

    protected synchronized void write(Boolean[] b, int start, int length) throws IOException {
        this.put(b, start, length);
        this.flush();
    }

    @Deprecated
    protected synchronized void writeByte(int b) throws IOException {
        this.write(b);
    }

    @Deprecated
    protected synchronized void writeShort(int s) throws IOException {
        this.getOutputBuffer().putShort((short)s);
        this.flush();
    }

    @Deprecated
    protected synchronized void writeInt(int i) throws IOException {
        this.getOutputBuffer().putInt(i);
        this.flush();
    }

    @Deprecated
    protected synchronized void writeLong(long l) throws IOException {
        this.getOutputBuffer().putLong(l);
        this.flush();
    }

    @Deprecated
    protected synchronized void writeFloat(float f) throws IOException {
        this.getOutputBuffer().putFloat(f);
        this.flush();
    }

    @Deprecated
    protected synchronized void writeDouble(double d) throws IOException {
        this.getOutputBuffer().putDouble(d);
        this.flush();
    }

    protected synchronized void writeBytes(String s) throws IOException {
        this.put(s);
        this.flush();
    }

    protected synchronized void writeChars(String s) throws IOException {
        if (ElementType.CHAR.size() == 1) {
            this.writeBytes(s);
        } else {
            OutputEncoder.OutputBuffer out = this.getOutputBuffer();
            for (int i = 0; i < s.length(); ++i) {
                out.putShort((short)s.charAt(i));
            }
            this.flush();
        }
    }

    protected synchronized void write(char[] c, int start, int length) throws IOException {
        this.put(c, start, length);
        this.flush();
    }

    protected synchronized void write(short[] s, int start, int length) throws IOException {
        this.getOutputBuffer().put(s, start, length);
        this.flush();
    }

    protected synchronized void write(int[] i, int start, int length) throws IOException {
        this.getOutputBuffer().put(i, start, length);
        this.flush();
    }

    protected synchronized void write(long[] l, int start, int length) throws IOException {
        this.getOutputBuffer().put(l, start, length);
        this.flush();
    }

    protected synchronized void write(float[] f, int start, int length) throws IOException {
        this.getOutputBuffer().put(f, start, length);
        this.flush();
    }

    protected synchronized void write(double[] d, int start, int length) throws IOException {
        this.getOutputBuffer().put(d, start, length);
        this.flush();
    }

    protected synchronized void write(String[] str, int start, int length) throws IOException {
        length += start;
        while (start < length) {
            this.writeBytes(str[start++]);
        }
    }

    @Override
    public synchronized void writeArray(Object o) throws IOException, IllegalArgumentException {
        this.putArray(o);
        this.flush();
    }

    protected void putArray(Object o) throws IOException, IllegalArgumentException {
        if (o == null) {
            return;
        }
        if (o instanceof ComplexValue) {
            this.putArray(((ComplexValue)o).toArray());
            return;
        }
        if (!o.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array: " + o.getClass().getName());
        }
        int length = Array.getLength(o);
        if (length == 0) {
            return;
        }
        if (o instanceof byte[]) {
            this.getOutputBuffer().put((byte[])o, 0, length);
        } else if (o instanceof boolean[]) {
            this.put((boolean[])o, 0, length);
        } else if (o instanceof char[]) {
            this.put((char[])o, 0, length);
        } else if (o instanceof short[]) {
            this.getOutputBuffer().put((short[])o, 0, length);
        } else if (o instanceof int[]) {
            this.getOutputBuffer().put((int[])o, 0, length);
        } else if (o instanceof float[]) {
            this.getOutputBuffer().put((float[])o, 0, length);
        } else if (o instanceof long[]) {
            this.getOutputBuffer().put((long[])o, 0, length);
        } else if (o instanceof double[]) {
            this.getOutputBuffer().put((double[])o, 0, length);
        } else if (o instanceof Boolean[]) {
            this.put((Boolean[])o, 0, length);
        } else if (o instanceof String[]) {
            this.put((String[])o, 0, length);
        } else {
            Object[] array = (Object[])o;
            for (int i = 0; i < length; ++i) {
                this.putArray(array[i]);
            }
        }
    }

    public static long computeSize(Object o) {
        ElementType eType;
        if (o == null) {
            return 0L;
        }
        if (o instanceof Object[]) {
            long size = 0L;
            for (Object e : (Object[])o) {
                size += FitsEncoder.computeSize(e);
            }
            return size;
        }
        if (o instanceof ComplexValue) {
            return 2 * (o instanceof ComplexValue.Float ? ElementType.FLOAT.size() : ElementType.DOUBLE.size());
        }
        Class<?> type = o.getClass();
        ElementType elementType = eType = type.isArray() ? ElementType.forClass(type.getComponentType()) : ElementType.forClass(type);
        if (eType == ElementType.UNKNOWN) {
            LOG.log(Level.WARNING, "computeSize() called with unknown type.", new IllegalArgumentException("Don't know FITS size of type " + type.getSimpleName()));
        }
        if (eType.isVariableSize()) {
            return eType.size(o);
        }
        if (type.isArray()) {
            return Array.getLength(o) * eType.size();
        }
        return eType.size();
    }
}

