/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.util.ArrayDataFile;
import nom.tam.util.FitsDecoder;
import nom.tam.util.FitsEncoder;
import nom.tam.util.FitsOutput;
import nom.tam.util.RandomAccess;
import nom.tam.util.RandomAccessFileIO;

public class FitsFile
extends ArrayDataFile
implements FitsOutput,
RandomAccess {
    private static final Logger LOG = Logger.getLogger(FitsFile.class.getName());
    private long marker;

    public FitsFile(File file) throws IOException {
        this(file, "r", 23040);
    }

    public FitsFile(File file, String mode) throws IOException {
        this(file, mode, 23040);
    }

    public FitsFile(File file, String mode, int bufferSize) throws IOException {
        super(file, mode, bufferSize);
        this.setDecoder(new FitsDecoder(this));
        this.setEncoder(new FitsEncoder(this));
    }

    public FitsFile(RandomAccessFileIO src, int bufferSize) throws IOException {
        super(src, bufferSize);
        this.setDecoder(new FitsDecoder(this));
        this.setEncoder(new FitsEncoder(this));
    }

    public FitsFile(String filename) throws IOException {
        this(filename, "r", 23040);
    }

    public FitsFile(String filename, String mode) throws IOException {
        this(filename, mode, 23040);
    }

    public FitsFile(String filename, String mode, int bufferSize) throws IOException {
        this(new File(filename), mode, bufferSize);
    }

    @Override
    public FitsEncoder getEncoder() {
        return (FitsEncoder)super.getEncoder();
    }

    @Override
    public FitsDecoder getDecoder() {
        return (FitsDecoder)super.getDecoder();
    }

    @Override
    public boolean isAtStart() {
        return this.getFilePointer() == 0L;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.getDecoder().readUnsignedByte();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.getDecoder().readByte();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.getDecoder().readBoolean();
    }

    @Override
    public char readChar() throws IOException {
        return this.getDecoder().readChar();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.getDecoder().readUnsignedShort();
    }

    @Override
    public final short readShort() throws IOException {
        return this.getDecoder().readShort();
    }

    @Override
    public final int readInt() throws IOException {
        return this.getDecoder().readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this.getDecoder().readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return this.getDecoder().readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this.getDecoder().readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.getDecoder().readAsciiLine();
    }

    @Override
    public int read(boolean[] b, int start, int length) throws IOException {
        return this.getDecoder().read(b, start, length);
    }

    @Override
    public int read(Boolean[] buf, int offset, int size) throws IOException {
        return this.getDecoder().read(buf, offset, size);
    }

    @Override
    public int read(char[] c, int start, int length) throws IOException {
        return this.getDecoder().read(c, start, length);
    }

    @Override
    public int read(short[] s, int start, int length) throws IOException {
        return this.getDecoder().read(s, start, length);
    }

    @Override
    public int read(int[] i, int start, int length) throws IOException {
        return this.getDecoder().read(i, start, length);
    }

    @Override
    public int read(long[] l, int start, int length) throws IOException {
        return this.getDecoder().read(l, start, length);
    }

    @Override
    public int read(float[] f, int start, int length) throws IOException {
        return this.getDecoder().read(f, start, length);
    }

    @Override
    public int read(double[] d, int start, int length) throws IOException {
        return this.getDecoder().read(d, start, length);
    }

    @Override
    @Deprecated
    public final int readArray(Object o) throws IOException {
        return (int)this.readLArray(o);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) throws IOException {
        this.marker = this.getFilePointer();
        if (!this.hasAvailable(readlimit)) {
            LOG.log(Level.FINE, "mark over file limit, so read as far as possible.");
        }
    }

    @Override
    public void reset() throws IOException {
        this.seek(this.marker);
    }

    @Override
    public int skipBytes(int toSkip) throws IOException {
        return (int)this.skip(toSkip);
    }

    @Override
    public void skipAllBytes(long toSkip) throws EOFException, IOException {
        long n = this.skip(toSkip);
        if (n != toSkip) {
            throw new EOFException("Skip reached file boundary at " + n + " of " + toSkip);
        }
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.getEncoder().writeByte(v);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.getEncoder().writeBoolean(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.getEncoder().writeChar(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.getEncoder().writeShort(v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.getEncoder().writeInt(v);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.getEncoder().writeLong(v);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.getEncoder().writeFloat(v);
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.getEncoder().writeDouble(v);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.getEncoder().writeBytes(s);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        this.getEncoder().writeChars(s);
    }

    @Override
    public void write(boolean[] b, int start, int length) throws IOException {
        this.getEncoder().write(b, start, length);
    }

    @Override
    public void write(Boolean[] buf, int offset, int size) throws IOException {
        this.getEncoder().write(buf, offset, size);
    }

    @Override
    public void write(char[] c, int start, int length) throws IOException {
        this.getEncoder().write(c, start, length);
    }

    @Override
    public void write(short[] s, int start, int length) throws IOException {
        this.getEncoder().write(s, start, length);
    }

    @Override
    public void write(int[] i, int start, int length) throws IOException {
        this.getEncoder().write(i, start, length);
    }

    @Override
    public void write(long[] l, int start, int length) throws IOException {
        this.getEncoder().write(l, start, length);
    }

    @Override
    public void write(float[] f, int start, int length) throws IOException {
        this.getEncoder().write(f, start, length);
    }

    @Override
    public void write(double[] d, int start, int length) throws IOException {
        this.getEncoder().write(d, start, length);
    }

    @Override
    public void write(String[] s, int start, int length) throws IOException {
        this.getEncoder().write(s, start, length);
    }
}

