/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import nom.tam.fits.utilities.FitsCheckSum;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayInputStream;
import nom.tam.util.FitsDecoder;

public class FitsInputStream
extends ArrayInputStream
implements ArrayDataInput {
    private ByteBuffer check;
    private long sum;
    private DataInput data = new DataInputStream(this);

    public FitsInputStream(InputStream i, int bufLength) {
        super(i, bufLength);
        this.check = ByteBuffer.allocate(2880);
        this.check.limit(this.check.capacity());
        this.setDecoder(new FitsDecoder(this));
    }

    public FitsInputStream(InputStream i) {
        this(i, 23040);
    }

    @Override
    protected FitsDecoder getDecoder() {
        return (FitsDecoder)super.getDecoder();
    }

    @Override
    public int read() throws IOException {
        int i = super.read();
        if (i >= 0) {
            this.check.put((byte)i);
            if (this.check.remaining() <= 0) {
                this.aggregate();
            }
        }
        return i;
    }

    @Override
    public int read(byte[] b, int from, int len) throws IOException {
        int l;
        int n = super.read(b, from, len);
        for (int i = 0; i < n; i += l) {
            l = Math.min(n - i, this.check.remaining());
            this.check.put(b, from + i, l);
            if (this.check.remaining() > 0) continue;
            this.aggregate();
        }
        return n;
    }

    private void aggregate() {
        this.sum = FitsCheckSum.sumOf(this.sum, FitsCheckSum.checksum(this.check));
        this.check.position(0);
    }

    public final long nextChecksum() {
        long ret = this.sum;
        this.sum = 0L;
        return ret;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.getDecoder().readFully(b, off, len);
    }

    @Override
    public int read(boolean[] b, int start, int length) throws IOException {
        return this.getDecoder().read(b, start, length);
    }

    @Override
    public int read(Boolean[] b, int start, int length) throws IOException {
        return this.getDecoder().read(b, start, length);
    }

    @Override
    public int read(char[] c, int start, int length) throws IOException {
        return this.getDecoder().read(c, start, length);
    }

    @Override
    public int read(short[] s, int start, int length) throws IOException {
        return this.getDecoder().read(s, start, length);
    }

    @Override
    public int read(int[] i, int start, int length) throws IOException {
        return this.getDecoder().read(i, start, length);
    }

    @Override
    public int read(long[] l, int start, int length) throws IOException {
        return this.getDecoder().read(l, start, length);
    }

    @Override
    public int read(float[] f, int start, int length) throws IOException {
        return this.getDecoder().read(f, start, length);
    }

    @Override
    public int read(double[] d, int start, int length) throws IOException {
        return this.getDecoder().read(d, start, length);
    }

    @Deprecated
    public final int readPrimitiveArray(Object o) throws IOException {
        return (int)this.readLArray(o);
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        int got;
        byte[] b = new byte[2880];
        for (skipped = 0L; skipped < n && (got = this.read(b, 0, (int)Math.min(n - skipped, (long)b.length))) >= 0; skipped += (long)got) {
        }
        return skipped;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)super.skip(n);
    }

    @Override
    public void skipAllBytes(long toSkip) throws EOFException, IOException {
        long got;
        long n;
        for (got = 0L; got < toSkip && (n = this.skip(toSkip - got)) > 0L; got += n) {
        }
        if (got != toSkip) {
            throw new EOFException("Reached end-of-stream after skipping " + got + " of " + toSkip);
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.getDecoder().readBoolean();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.getDecoder().readUnsignedByte();
    }

    @Override
    public byte readByte() throws IOException {
        return this.getDecoder().readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.getDecoder().readChar();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.getDecoder().readUnsignedShort();
    }

    @Override
    public short readShort() throws IOException {
        return this.getDecoder().readShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.getDecoder().readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.getDecoder().readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.getDecoder().readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.getDecoder().readDouble();
    }

    @Override
    public String readUTF() throws IOException {
        return this.data.readUTF();
    }

    @Override
    public final String readLine() throws IOException {
        return this.getDecoder().readAsciiLine();
    }

    public String toString() {
        return super.toString() + "[count=" + this.count + ",pos=" + this.pos + "]";
    }
}

