/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nom.tam.util.ArrayOutputStream;
import nom.tam.util.FitsEncoder;
import nom.tam.util.FitsOutput;

public class FitsOutputStream
extends ArrayOutputStream
implements FitsOutput {
    private final DataOutput data;
    private int unencodedCount;

    public FitsOutputStream(OutputStream o) {
        this(o, 23040);
    }

    public FitsOutputStream(OutputStream o, int bufLength) {
        super(o, bufLength);
        this.setEncoder(new FitsEncoder(this));
        this.data = o instanceof DataOutput ? (DataOutput)((Object)o) : new DataOutputStream(o);
    }

    @Override
    protected FitsEncoder getEncoder() {
        return (FitsEncoder)super.getEncoder();
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++this.unencodedCount;
    }

    @Override
    public void write(byte[] b, int start, int length) throws IOException {
        super.write(b, start, length);
        this.unencodedCount += length;
    }

    @Override
    public void write(boolean[] b, int start, int length) throws IOException {
        this.getEncoder().write(b, start, length);
    }

    @Override
    public void write(Boolean[] buf, int offset, int size) throws IOException {
        this.getEncoder().write(buf, offset, size);
    }

    @Override
    public void write(char[] c, int start, int length) throws IOException {
        this.getEncoder().write(c, start, length);
    }

    @Override
    public void write(short[] s, int start, int length) throws IOException {
        this.getEncoder().write(s, start, length);
    }

    @Override
    public void write(int[] i, int start, int length) throws IOException {
        this.getEncoder().write(i, start, length);
    }

    @Override
    public void write(long[] l, int start, int length) throws IOException {
        this.getEncoder().write(l, start, length);
    }

    @Override
    public void write(float[] f, int start, int length) throws IOException {
        this.getEncoder().write(f, start, length);
    }

    @Override
    public void write(double[] d, int start, int length) throws IOException {
        this.getEncoder().write(d, start, length);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.getEncoder().writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.getEncoder().writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.data.writeUTF(s);
    }

    @Override
    public void write(String[] s, int start, int len) throws IOException {
        this.getEncoder().write(s, start, len);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.getEncoder().writeByte(b);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.getEncoder().writeBoolean(b);
    }

    @Override
    public void writeChar(int c) throws IOException {
        this.getEncoder().writeChar(c);
    }

    @Override
    public void writeShort(int s) throws IOException {
        this.getEncoder().writeShort(s);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.getEncoder().writeInt(i);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.getEncoder().writeLong(l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.getEncoder().writeFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.getEncoder().writeDouble(d);
    }

    @Deprecated
    public final void writePrimitiveArray(Object o) throws IOException {
        this.writeArray(o);
    }

    @Override
    public boolean isAtStart() {
        return (long)this.unencodedCount + this.getEncoder().getCount() == 0L;
    }
}

